/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPolicyVersionResponse
extends IotResponse
implements ToCopyableBuilder<Builder, GetPolicyVersionResponse> {
    private final String policyArn;
    private final String policyName;
    private final String policyDocument;
    private final String policyVersionId;
    private final Boolean isDefaultVersion;
    private final Instant creationDate;
    private final Instant lastModifiedDate;
    private final String generationId;

    private GetPolicyVersionResponse(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
        this.policyVersionId = builder.policyVersionId;
        this.isDefaultVersion = builder.isDefaultVersion;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.generationId = builder.generationId;
    }

    public String policyArn() {
        return this.policyArn;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    public String policyVersionId() {
        return this.policyVersionId;
    }

    public Boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String generationId() {
        return this.generationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyVersionResponse)) {
            return false;
        }
        GetPolicyVersionResponse other = (GetPolicyVersionResponse)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.policyVersionId(), other.policyVersionId()) && Objects.equals(this.isDefaultVersion(), other.isDefaultVersion()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.generationId(), other.generationId());
    }

    public String toString() {
        return ToString.builder((String)"GetPolicyVersionResponse").add("PolicyArn", (Object)this.policyArn()).add("PolicyName", (Object)this.policyName()).add("PolicyDocument", (Object)this.policyDocument()).add("PolicyVersionId", (Object)this.policyVersionId()).add("IsDefaultVersion", (Object)this.isDefaultVersion()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("GenerationId", (Object)this.generationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "policyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "policyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "policyVersionId": {
                return Optional.ofNullable(clazz.cast(this.policyVersionId()));
            }
            case "isDefaultVersion": {
                return Optional.ofNullable(clazz.cast(this.isDefaultVersion()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "generationId": {
                return Optional.ofNullable(clazz.cast(this.generationId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String policyArn;
        private String policyName;
        private String policyDocument;
        private String policyVersionId;
        private Boolean isDefaultVersion;
        private Instant creationDate;
        private Instant lastModifiedDate;
        private String generationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyVersionResponse model) {
            super(model);
            this.policyArn(model.policyArn);
            this.policyName(model.policyName);
            this.policyDocument(model.policyDocument);
            this.policyVersionId(model.policyVersionId);
            this.isDefaultVersion(model.isDefaultVersion);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
            this.generationId(model.generationId);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final String getPolicyVersionId() {
            return this.policyVersionId;
        }

        @Override
        public final Builder policyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public final void setPolicyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        public final Boolean getIsDefaultVersion() {
            return this.isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getGenerationId() {
            return this.generationId;
        }

        @Override
        public final Builder generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        public final void setGenerationId(String generationId) {
            this.generationId = generationId;
        }

        @Override
        public GetPolicyVersionResponse build() {
            return new GetPolicyVersionResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, GetPolicyVersionResponse> {
        public Builder policyArn(String var1);

        public Builder policyName(String var1);

        public Builder policyDocument(String var1);

        public Builder policyVersionId(String var1);

        public Builder isDefaultVersion(Boolean var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder generationId(String var1);
    }
}

