/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEffectivePoliciesRequest
extends IotRequest
implements ToCopyableBuilder<Builder, GetEffectivePoliciesRequest> {
    private final String principal;
    private final String cognitoIdentityPoolId;
    private final String thingName;

    private GetEffectivePoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.principal = builder.principal;
        this.cognitoIdentityPoolId = builder.cognitoIdentityPoolId;
        this.thingName = builder.thingName;
    }

    public String principal() {
        return this.principal;
    }

    public String cognitoIdentityPoolId() {
        return this.cognitoIdentityPoolId;
    }

    public String thingName() {
        return this.thingName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoIdentityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEffectivePoliciesRequest)) {
            return false;
        }
        GetEffectivePoliciesRequest other = (GetEffectivePoliciesRequest)((Object)obj);
        return Objects.equals(this.principal(), other.principal()) && Objects.equals(this.cognitoIdentityPoolId(), other.cognitoIdentityPoolId()) && Objects.equals(this.thingName(), other.thingName());
    }

    public String toString() {
        return ToString.builder((String)"GetEffectivePoliciesRequest").add("Principal", (Object)this.principal()).add("CognitoIdentityPoolId", (Object)this.cognitoIdentityPoolId()).add("ThingName", (Object)this.thingName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "cognitoIdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.cognitoIdentityPoolId()));
            }
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String principal;
        private String cognitoIdentityPoolId;
        private String thingName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEffectivePoliciesRequest model) {
            super(model);
            this.principal(model.principal);
            this.cognitoIdentityPoolId(model.cognitoIdentityPoolId);
            this.thingName(model.thingName);
        }

        public final String getPrincipal() {
            return this.principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        public final String getCognitoIdentityPoolId() {
            return this.cognitoIdentityPoolId;
        }

        @Override
        public final Builder cognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
            return this;
        }

        public final void setCognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEffectivePoliciesRequest build() {
            return new GetEffectivePoliciesRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, GetEffectivePoliciesRequest> {
        public Builder principal(String var1);

        public Builder cognitoIdentityPoolId(String var1);

        public Builder thingName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

