/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.FirehoseActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirehoseAction
implements StructuredPojo,
ToCopyableBuilder<Builder, FirehoseAction> {
    private final String roleArn;
    private final String deliveryStreamName;
    private final String separator;

    private FirehoseAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.deliveryStreamName = builder.deliveryStreamName;
        this.separator = builder.separator;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public String separator() {
        return this.separator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.separator());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirehoseAction)) {
            return false;
        }
        FirehoseAction other = (FirehoseAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(this.separator(), other.separator());
    }

    public String toString() {
        return ToString.builder((String)"FirehoseAction").add("RoleArn", (Object)this.roleArn()).add("DeliveryStreamName", (Object)this.deliveryStreamName()).add("Separator", (Object)this.separator()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "deliveryStreamName": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamName()));
            }
            case "separator": {
                return Optional.ofNullable(clazz.cast(this.separator()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FirehoseActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String deliveryStreamName;
        private String separator;

        private BuilderImpl() {
        }

        private BuilderImpl(FirehoseAction model) {
            this.roleArn(model.roleArn);
            this.deliveryStreamName(model.deliveryStreamName);
            this.separator(model.separator);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getSeparator() {
            return this.separator;
        }

        @Override
        public final Builder separator(String separator) {
            this.separator = separator;
            return this;
        }

        public final void setSeparator(String separator) {
            this.separator = separator;
        }

        public FirehoseAction build() {
            return new FirehoseAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FirehoseAction> {
        public Builder roleArn(String var1);

        public Builder deliveryStreamName(String var1);

        public Builder separator(String var1);
    }
}

