/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.S3Location;
import software.amazon.awssdk.services.iot.model.Stream;
import software.amazon.awssdk.services.iot.transform.FileLocationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, FileLocation> {
    private final Stream stream;
    private final S3Location s3Location;

    private FileLocation(BuilderImpl builder) {
        this.stream = builder.stream;
        this.s3Location = builder.s3Location;
    }

    public Stream stream() {
        return this.stream;
    }

    public S3Location s3Location() {
        return this.s3Location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stream());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileLocation)) {
            return false;
        }
        FileLocation other = (FileLocation)obj;
        return Objects.equals(this.stream(), other.stream()) && Objects.equals(this.s3Location(), other.s3Location());
    }

    public String toString() {
        return ToString.builder((String)"FileLocation").add("Stream", (Object)this.stream()).add("S3Location", (Object)this.s3Location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stream": {
                return Optional.ofNullable(clazz.cast(this.stream()));
            }
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Stream stream;
        private S3Location s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(FileLocation model) {
            this.stream(model.stream);
            this.s3Location(model.s3Location);
        }

        public final Stream.Builder getStream() {
            return this.stream != null ? this.stream.toBuilder() : null;
        }

        @Override
        public final Builder stream(Stream stream) {
            this.stream = stream;
            return this;
        }

        public final void setStream(Stream.BuilderImpl stream) {
            this.stream = stream != null ? stream.build() : null;
        }

        public final S3Location.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        @Override
        public final Builder s3Location(S3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(S3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        public FileLocation build() {
            return new FileLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FileLocation> {
        public Builder stream(Stream var1);

        default public Builder stream(Consumer<Stream.Builder> stream) {
            return this.stream((Stream)((Stream.Builder)Stream.builder().applyMutation(stream)).build());
        }

        public Builder s3Location(S3Location var1);

        default public Builder s3Location(Consumer<S3Location.Builder> s3Location) {
            return this.s3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(s3Location)).build());
        }
    }
}

