/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.CodeSigningCertificateChain;
import software.amazon.awssdk.services.iot.model.CodeSigningSignature;
import software.amazon.awssdk.services.iot.transform.CustomCodeSigningMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomCodeSigning
implements StructuredPojo,
ToCopyableBuilder<Builder, CustomCodeSigning> {
    private final CodeSigningSignature signature;
    private final CodeSigningCertificateChain certificateChain;
    private final String hashAlgorithm;
    private final String signatureAlgorithm;

    private CustomCodeSigning(BuilderImpl builder) {
        this.signature = builder.signature;
        this.certificateChain = builder.certificateChain;
        this.hashAlgorithm = builder.hashAlgorithm;
        this.signatureAlgorithm = builder.signatureAlgorithm;
    }

    public CodeSigningSignature signature() {
        return this.signature;
    }

    public CodeSigningCertificateChain certificateChain() {
        return this.certificateChain;
    }

    public String hashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.signature());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureAlgorithm());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomCodeSigning)) {
            return false;
        }
        CustomCodeSigning other = (CustomCodeSigning)obj;
        return Objects.equals(this.signature(), other.signature()) && Objects.equals(this.certificateChain(), other.certificateChain()) && Objects.equals(this.hashAlgorithm(), other.hashAlgorithm()) && Objects.equals(this.signatureAlgorithm(), other.signatureAlgorithm());
    }

    public String toString() {
        return ToString.builder((String)"CustomCodeSigning").add("Signature", (Object)this.signature()).add("CertificateChain", (Object)this.certificateChain()).add("HashAlgorithm", (Object)this.hashAlgorithm()).add("SignatureAlgorithm", (Object)this.signatureAlgorithm()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signature": {
                return Optional.ofNullable(clazz.cast(this.signature()));
            }
            case "certificateChain": {
                return Optional.ofNullable(clazz.cast(this.certificateChain()));
            }
            case "hashAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.hashAlgorithm()));
            }
            case "signatureAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signatureAlgorithm()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomCodeSigningMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private CodeSigningSignature signature;
        private CodeSigningCertificateChain certificateChain;
        private String hashAlgorithm;
        private String signatureAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomCodeSigning model) {
            this.signature(model.signature);
            this.certificateChain(model.certificateChain);
            this.hashAlgorithm(model.hashAlgorithm);
            this.signatureAlgorithm(model.signatureAlgorithm);
        }

        public final CodeSigningSignature.Builder getSignature() {
            return this.signature != null ? this.signature.toBuilder() : null;
        }

        @Override
        public final Builder signature(CodeSigningSignature signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(CodeSigningSignature.BuilderImpl signature) {
            this.signature = signature != null ? signature.build() : null;
        }

        public final CodeSigningCertificateChain.Builder getCertificateChain() {
            return this.certificateChain != null ? this.certificateChain.toBuilder() : null;
        }

        @Override
        public final Builder certificateChain(CodeSigningCertificateChain certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final void setCertificateChain(CodeSigningCertificateChain.BuilderImpl certificateChain) {
            this.certificateChain = certificateChain != null ? certificateChain.build() : null;
        }

        public final String getHashAlgorithm() {
            return this.hashAlgorithm;
        }

        @Override
        public final Builder hashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            return this;
        }

        public final void setHashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
        }

        public final String getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        @Override
        public final Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public final void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        public CustomCodeSigning build() {
            return new CustomCodeSigning(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CustomCodeSigning> {
        public Builder signature(CodeSigningSignature var1);

        default public Builder signature(Consumer<CodeSigningSignature.Builder> signature) {
            return this.signature((CodeSigningSignature)((CodeSigningSignature.Builder)CodeSigningSignature.builder().applyMutation(signature)).build());
        }

        public Builder certificateChain(CodeSigningCertificateChain var1);

        default public Builder certificateChain(Consumer<CodeSigningCertificateChain.Builder> certificateChain) {
            return this.certificateChain((CodeSigningCertificateChain)((CodeSigningCertificateChain.Builder)CodeSigningCertificateChain.builder().applyMutation(certificateChain)).build());
        }

        public Builder hashAlgorithm(String var1);

        public Builder signatureAlgorithm(String var1);
    }
}

