/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.OTAUpdateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOtaUpdateResponse
extends IotResponse
implements ToCopyableBuilder<Builder, CreateOtaUpdateResponse> {
    private final String otaUpdateId;
    private final String awsIotJobId;
    private final String otaUpdateArn;
    private final String awsIotJobArn;
    private final String otaUpdateStatus;

    private CreateOtaUpdateResponse(BuilderImpl builder) {
        super(builder);
        this.otaUpdateId = builder.otaUpdateId;
        this.awsIotJobId = builder.awsIotJobId;
        this.otaUpdateArn = builder.otaUpdateArn;
        this.awsIotJobArn = builder.awsIotJobArn;
        this.otaUpdateStatus = builder.otaUpdateStatus;
    }

    public String otaUpdateId() {
        return this.otaUpdateId;
    }

    public String awsIotJobId() {
        return this.awsIotJobId;
    }

    public String otaUpdateArn() {
        return this.otaUpdateArn;
    }

    public String awsIotJobArn() {
        return this.awsIotJobArn;
    }

    public OTAUpdateStatus otaUpdateStatus() {
        return OTAUpdateStatus.fromValue(this.otaUpdateStatus);
    }

    public String otaUpdateStatusAsString() {
        return this.otaUpdateStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIotJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaUpdateStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOtaUpdateResponse)) {
            return false;
        }
        CreateOtaUpdateResponse other = (CreateOtaUpdateResponse)((Object)obj);
        return Objects.equals(this.otaUpdateId(), other.otaUpdateId()) && Objects.equals(this.awsIotJobId(), other.awsIotJobId()) && Objects.equals(this.otaUpdateArn(), other.otaUpdateArn()) && Objects.equals(this.awsIotJobArn(), other.awsIotJobArn()) && Objects.equals(this.otaUpdateStatusAsString(), other.otaUpdateStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateOtaUpdateResponse").add("OtaUpdateId", (Object)this.otaUpdateId()).add("AwsIotJobId", (Object)this.awsIotJobId()).add("OtaUpdateArn", (Object)this.otaUpdateArn()).add("AwsIotJobArn", (Object)this.awsIotJobArn()).add("OtaUpdateStatus", (Object)this.otaUpdateStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "otaUpdateId": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateId()));
            }
            case "awsIotJobId": {
                return Optional.ofNullable(clazz.cast(this.awsIotJobId()));
            }
            case "otaUpdateArn": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateArn()));
            }
            case "awsIotJobArn": {
                return Optional.ofNullable(clazz.cast(this.awsIotJobArn()));
            }
            case "otaUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.otaUpdateStatusAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String otaUpdateId;
        private String awsIotJobId;
        private String otaUpdateArn;
        private String awsIotJobArn;
        private String otaUpdateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOtaUpdateResponse model) {
            super(model);
            this.otaUpdateId(model.otaUpdateId);
            this.awsIotJobId(model.awsIotJobId);
            this.otaUpdateArn(model.otaUpdateArn);
            this.awsIotJobArn(model.awsIotJobArn);
            this.otaUpdateStatus(model.otaUpdateStatus);
        }

        public final String getOtaUpdateId() {
            return this.otaUpdateId;
        }

        @Override
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        public final String getAwsIotJobId() {
            return this.awsIotJobId;
        }

        @Override
        public final Builder awsIotJobId(String awsIotJobId) {
            this.awsIotJobId = awsIotJobId;
            return this;
        }

        public final void setAwsIotJobId(String awsIotJobId) {
            this.awsIotJobId = awsIotJobId;
        }

        public final String getOtaUpdateArn() {
            return this.otaUpdateArn;
        }

        @Override
        public final Builder otaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
            return this;
        }

        public final void setOtaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
        }

        public final String getAwsIotJobArn() {
            return this.awsIotJobArn;
        }

        @Override
        public final Builder awsIotJobArn(String awsIotJobArn) {
            this.awsIotJobArn = awsIotJobArn;
            return this;
        }

        public final void setAwsIotJobArn(String awsIotJobArn) {
            this.awsIotJobArn = awsIotJobArn;
        }

        public final String getOtaUpdateStatus() {
            return this.otaUpdateStatus;
        }

        @Override
        public final Builder otaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
            return this;
        }

        @Override
        public final Builder otaUpdateStatus(OTAUpdateStatus otaUpdateStatus) {
            this.otaUpdateStatus(otaUpdateStatus.toString());
            return this;
        }

        public final void setOtaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
        }

        @Override
        public CreateOtaUpdateResponse build() {
            return new CreateOtaUpdateResponse(this);
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    CopyableBuilder<Builder, CreateOtaUpdateResponse> {
        public Builder otaUpdateId(String var1);

        public Builder awsIotJobId(String var1);

        public Builder otaUpdateArn(String var1);

        public Builder awsIotJobArn(String var1);

        public Builder otaUpdateStatus(String var1);

        public Builder otaUpdateStatus(OTAUpdateStatus var1);
    }
}

