/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.CodeSigningCertificateChainMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeSigningCertificateChain
implements StructuredPojo,
ToCopyableBuilder<Builder, CodeSigningCertificateChain> {
    private final String certificateName;
    private final String inlineDocument;

    private CodeSigningCertificateChain(BuilderImpl builder) {
        this.certificateName = builder.certificateName;
        this.inlineDocument = builder.inlineDocument;
    }

    public String certificateName() {
        return this.certificateName;
    }

    public String inlineDocument() {
        return this.inlineDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineDocument());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSigningCertificateChain)) {
            return false;
        }
        CodeSigningCertificateChain other = (CodeSigningCertificateChain)obj;
        return Objects.equals(this.certificateName(), other.certificateName()) && Objects.equals(this.inlineDocument(), other.inlineDocument());
    }

    public String toString() {
        return ToString.builder((String)"CodeSigningCertificateChain").add("CertificateName", (Object)this.certificateName()).add("InlineDocument", (Object)this.inlineDocument()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateName": {
                return Optional.ofNullable(clazz.cast(this.certificateName()));
            }
            case "inlineDocument": {
                return Optional.ofNullable(clazz.cast(this.inlineDocument()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeSigningCertificateChainMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateName;
        private String inlineDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSigningCertificateChain model) {
            this.certificateName(model.certificateName);
            this.inlineDocument(model.inlineDocument);
        }

        public final String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final String getInlineDocument() {
            return this.inlineDocument;
        }

        @Override
        public final Builder inlineDocument(String inlineDocument) {
            this.inlineDocument = inlineDocument;
            return this;
        }

        public final void setInlineDocument(String inlineDocument) {
            this.inlineDocument = inlineDocument;
        }

        public CodeSigningCertificateChain build() {
            return new CodeSigningCertificateChain(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CodeSigningCertificateChain> {
        public Builder certificateName(String var1);

        public Builder inlineDocument(String var1);
    }
}

