/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.CustomCodeSigning;
import software.amazon.awssdk.services.iot.model.StartSigningJobParameter;
import software.amazon.awssdk.services.iot.transform.CodeSigningMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeSigning
implements StructuredPojo,
ToCopyableBuilder<Builder, CodeSigning> {
    private final String awsSignerJobId;
    private final StartSigningJobParameter startSigningJobParameter;
    private final CustomCodeSigning customCodeSigning;

    private CodeSigning(BuilderImpl builder) {
        this.awsSignerJobId = builder.awsSignerJobId;
        this.startSigningJobParameter = builder.startSigningJobParameter;
        this.customCodeSigning = builder.customCodeSigning;
    }

    public String awsSignerJobId() {
        return this.awsSignerJobId;
    }

    public StartSigningJobParameter startSigningJobParameter() {
        return this.startSigningJobParameter;
    }

    public CustomCodeSigning customCodeSigning() {
        return this.customCodeSigning;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsSignerJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startSigningJobParameter());
        hashCode = 31 * hashCode + Objects.hashCode(this.customCodeSigning());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSigning)) {
            return false;
        }
        CodeSigning other = (CodeSigning)obj;
        return Objects.equals(this.awsSignerJobId(), other.awsSignerJobId()) && Objects.equals(this.startSigningJobParameter(), other.startSigningJobParameter()) && Objects.equals(this.customCodeSigning(), other.customCodeSigning());
    }

    public String toString() {
        return ToString.builder((String)"CodeSigning").add("AwsSignerJobId", (Object)this.awsSignerJobId()).add("StartSigningJobParameter", (Object)this.startSigningJobParameter()).add("CustomCodeSigning", (Object)this.customCodeSigning()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsSignerJobId": {
                return Optional.ofNullable(clazz.cast(this.awsSignerJobId()));
            }
            case "startSigningJobParameter": {
                return Optional.ofNullable(clazz.cast(this.startSigningJobParameter()));
            }
            case "customCodeSigning": {
                return Optional.ofNullable(clazz.cast(this.customCodeSigning()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeSigningMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsSignerJobId;
        private StartSigningJobParameter startSigningJobParameter;
        private CustomCodeSigning customCodeSigning;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSigning model) {
            this.awsSignerJobId(model.awsSignerJobId);
            this.startSigningJobParameter(model.startSigningJobParameter);
            this.customCodeSigning(model.customCodeSigning);
        }

        public final String getAwsSignerJobId() {
            return this.awsSignerJobId;
        }

        @Override
        public final Builder awsSignerJobId(String awsSignerJobId) {
            this.awsSignerJobId = awsSignerJobId;
            return this;
        }

        public final void setAwsSignerJobId(String awsSignerJobId) {
            this.awsSignerJobId = awsSignerJobId;
        }

        public final StartSigningJobParameter.Builder getStartSigningJobParameter() {
            return this.startSigningJobParameter != null ? this.startSigningJobParameter.toBuilder() : null;
        }

        @Override
        public final Builder startSigningJobParameter(StartSigningJobParameter startSigningJobParameter) {
            this.startSigningJobParameter = startSigningJobParameter;
            return this;
        }

        public final void setStartSigningJobParameter(StartSigningJobParameter.BuilderImpl startSigningJobParameter) {
            this.startSigningJobParameter = startSigningJobParameter != null ? startSigningJobParameter.build() : null;
        }

        public final CustomCodeSigning.Builder getCustomCodeSigning() {
            return this.customCodeSigning != null ? this.customCodeSigning.toBuilder() : null;
        }

        @Override
        public final Builder customCodeSigning(CustomCodeSigning customCodeSigning) {
            this.customCodeSigning = customCodeSigning;
            return this;
        }

        public final void setCustomCodeSigning(CustomCodeSigning.BuilderImpl customCodeSigning) {
            this.customCodeSigning = customCodeSigning != null ? customCodeSigning.build() : null;
        }

        public CodeSigning build() {
            return new CodeSigning(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CodeSigning> {
        public Builder awsSignerJobId(String var1);

        public Builder startSigningJobParameter(StartSigningJobParameter var1);

        default public Builder startSigningJobParameter(Consumer<StartSigningJobParameter.Builder> startSigningJobParameter) {
            return this.startSigningJobParameter((StartSigningJobParameter)((StartSigningJobParameter.Builder)StartSigningJobParameter.builder().applyMutation(startSigningJobParameter)).build());
        }

        public Builder customCodeSigning(CustomCodeSigning var1);

        default public Builder customCodeSigning(Consumer<CustomCodeSigning.Builder> customCodeSigning) {
            return this.customCodeSigning((CustomCodeSigning)((CustomCodeSigning.Builder)CustomCodeSigning.builder().applyMutation(customCodeSigning)).build());
        }
    }
}

