/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.AutoRegistrationStatus;
import software.amazon.awssdk.services.iot.model.CACertificateStatus;
import software.amazon.awssdk.services.iot.model.CertificateValidity;
import software.amazon.awssdk.services.iot.transform.CACertificateDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CACertificateDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, CACertificateDescription> {
    private final String certificateArn;
    private final String certificateId;
    private final String status;
    private final String certificatePem;
    private final String ownedBy;
    private final Instant creationDate;
    private final String autoRegistrationStatus;
    private final Instant lastModifiedDate;
    private final Integer customerVersion;
    private final String generationId;
    private final CertificateValidity validity;

    private CACertificateDescription(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.status = builder.status;
        this.certificatePem = builder.certificatePem;
        this.ownedBy = builder.ownedBy;
        this.creationDate = builder.creationDate;
        this.autoRegistrationStatus = builder.autoRegistrationStatus;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.customerVersion = builder.customerVersion;
        this.generationId = builder.generationId;
        this.validity = builder.validity;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public CACertificateStatus status() {
        return CACertificateStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String certificatePem() {
        return this.certificatePem;
    }

    public String ownedBy() {
        return this.ownedBy;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public AutoRegistrationStatus autoRegistrationStatus() {
        return AutoRegistrationStatus.fromValue(this.autoRegistrationStatus);
    }

    public String autoRegistrationStatusAsString() {
        return this.autoRegistrationStatus;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Integer customerVersion() {
        return this.customerVersion;
    }

    public String generationId() {
        return this.generationId;
    }

    public CertificateValidity validity() {
        return this.validity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRegistrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.validity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CACertificateDescription)) {
            return false;
        }
        CACertificateDescription other = (CACertificateDescription)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.certificatePem(), other.certificatePem()) && Objects.equals(this.ownedBy(), other.ownedBy()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.autoRegistrationStatusAsString(), other.autoRegistrationStatusAsString()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.customerVersion(), other.customerVersion()) && Objects.equals(this.generationId(), other.generationId()) && Objects.equals(this.validity(), other.validity());
    }

    public String toString() {
        return ToString.builder((String)"CACertificateDescription").add("CertificateArn", (Object)this.certificateArn()).add("CertificateId", (Object)this.certificateId()).add("Status", (Object)this.statusAsString()).add("CertificatePem", (Object)this.certificatePem()).add("OwnedBy", (Object)this.ownedBy()).add("CreationDate", (Object)this.creationDate()).add("AutoRegistrationStatus", (Object)this.autoRegistrationStatusAsString()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("CustomerVersion", (Object)this.customerVersion()).add("GenerationId", (Object)this.generationId()).add("Validity", (Object)this.validity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "certificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "certificatePem": {
                return Optional.ofNullable(clazz.cast(this.certificatePem()));
            }
            case "ownedBy": {
                return Optional.ofNullable(clazz.cast(this.ownedBy()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "autoRegistrationStatus": {
                return Optional.ofNullable(clazz.cast(this.autoRegistrationStatusAsString()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "customerVersion": {
                return Optional.ofNullable(clazz.cast(this.customerVersion()));
            }
            case "generationId": {
                return Optional.ofNullable(clazz.cast(this.generationId()));
            }
            case "validity": {
                return Optional.ofNullable(clazz.cast(this.validity()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CACertificateDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String certificateId;
        private String status;
        private String certificatePem;
        private String ownedBy;
        private Instant creationDate;
        private String autoRegistrationStatus;
        private Instant lastModifiedDate;
        private Integer customerVersion;
        private String generationId;
        private CertificateValidity validity;

        private BuilderImpl() {
        }

        private BuilderImpl(CACertificateDescription model) {
            this.certificateArn(model.certificateArn);
            this.certificateId(model.certificateId);
            this.status(model.status);
            this.certificatePem(model.certificatePem);
            this.ownedBy(model.ownedBy);
            this.creationDate(model.creationDate);
            this.autoRegistrationStatus(model.autoRegistrationStatus);
            this.lastModifiedDate(model.lastModifiedDate);
            this.customerVersion(model.customerVersion);
            this.generationId(model.generationId);
            this.validity(model.validity);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CACertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final String getOwnedBy() {
            return this.ownedBy;
        }

        @Override
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getAutoRegistrationStatus() {
            return this.autoRegistrationStatus;
        }

        @Override
        public final Builder autoRegistrationStatus(String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
            return this;
        }

        @Override
        public final Builder autoRegistrationStatus(AutoRegistrationStatus autoRegistrationStatus) {
            this.autoRegistrationStatus(autoRegistrationStatus.toString());
            return this;
        }

        public final void setAutoRegistrationStatus(String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Integer getCustomerVersion() {
            return this.customerVersion;
        }

        @Override
        public final Builder customerVersion(Integer customerVersion) {
            this.customerVersion = customerVersion;
            return this;
        }

        public final void setCustomerVersion(Integer customerVersion) {
            this.customerVersion = customerVersion;
        }

        public final String getGenerationId() {
            return this.generationId;
        }

        @Override
        public final Builder generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        public final void setGenerationId(String generationId) {
            this.generationId = generationId;
        }

        public final CertificateValidity.Builder getValidity() {
            return this.validity != null ? this.validity.toBuilder() : null;
        }

        @Override
        public final Builder validity(CertificateValidity validity) {
            this.validity = validity;
            return this;
        }

        public final void setValidity(CertificateValidity.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        public CACertificateDescription build() {
            return new CACertificateDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CACertificateDescription> {
        public Builder certificateArn(String var1);

        public Builder certificateId(String var1);

        public Builder status(String var1);

        public Builder status(CACertificateStatus var1);

        public Builder certificatePem(String var1);

        public Builder ownedBy(String var1);

        public Builder creationDate(Instant var1);

        public Builder autoRegistrationStatus(String var1);

        public Builder autoRegistrationStatus(AutoRegistrationStatus var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder customerVersion(Integer var1);

        public Builder generationId(String var1);

        public Builder validity(CertificateValidity var1);

        default public Builder validity(Consumer<CertificateValidity.Builder> validity) {
            return this.validity((CertificateValidity)((CertificateValidity.Builder)CertificateValidity.builder().applyMutation(validity)).build());
        }
    }
}

