/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.ComparisonOperator;
import software.amazon.awssdk.services.iot.model.MetricValue;
import software.amazon.awssdk.services.iot.transform.BehaviorCriteriaMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BehaviorCriteria
implements StructuredPojo,
ToCopyableBuilder<Builder, BehaviorCriteria> {
    private final String comparisonOperator;
    private final MetricValue value;
    private final Integer durationSeconds;

    private BehaviorCriteria(BuilderImpl builder) {
        this.comparisonOperator = builder.comparisonOperator;
        this.value = builder.value;
        this.durationSeconds = builder.durationSeconds;
    }

    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public MetricValue value() {
        return this.value;
    }

    public Integer durationSeconds() {
        return this.durationSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BehaviorCriteria)) {
            return false;
        }
        BehaviorCriteria other = (BehaviorCriteria)obj;
        return Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.durationSeconds(), other.durationSeconds());
    }

    public String toString() {
        return ToString.builder((String)"BehaviorCriteria").add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("Value", (Object)this.value()).add("DurationSeconds", (Object)this.durationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "comparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "durationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BehaviorCriteriaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String comparisonOperator;
        private MetricValue value;
        private Integer durationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(BehaviorCriteria model) {
            this.comparisonOperator(model.comparisonOperator);
            this.value(model.value);
            this.durationSeconds(model.durationSeconds);
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final MetricValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        @Override
        public final Builder value(MetricValue value) {
            this.value = value;
            return this;
        }

        public final void setValue(MetricValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        public BehaviorCriteria build() {
            return new BehaviorCriteria(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BehaviorCriteria> {
        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder value(MetricValue var1);

        default public Builder value(Consumer<MetricValue.Builder> value) {
            return this.value((MetricValue)((MetricValue.Builder)MetricValue.builder().applyMutation(value)).build());
        }

        public Builder durationSeconds(Integer var1);
    }
}

