/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.AuditNotificationTargetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditNotificationTarget
implements StructuredPojo,
ToCopyableBuilder<Builder, AuditNotificationTarget> {
    private final String targetArn;
    private final String roleArn;
    private final Boolean enabled;

    private AuditNotificationTarget(BuilderImpl builder) {
        this.targetArn = builder.targetArn;
        this.roleArn = builder.roleArn;
        this.enabled = builder.enabled;
    }

    public String targetArn() {
        return this.targetArn;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditNotificationTarget)) {
            return false;
        }
        AuditNotificationTarget other = (AuditNotificationTarget)obj;
        return Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.enabled(), other.enabled());
    }

    public String toString() {
        return ToString.builder((String)"AuditNotificationTarget").add("TargetArn", (Object)this.targetArn()).add("RoleArn", (Object)this.roleArn()).add("Enabled", (Object)this.enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuditNotificationTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetArn;
        private String roleArn;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditNotificationTarget model) {
            this.targetArn(model.targetArn);
            this.roleArn(model.roleArn);
            this.enabled(model.enabled);
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public AuditNotificationTarget build() {
            return new AuditNotificationTarget(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AuditNotificationTarget> {
        public Builder targetArn(String var1);

        public Builder roleArn(String var1);

        public Builder enabled(Boolean var1);
    }
}

