/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.AuditCheckRunStatus;
import software.amazon.awssdk.services.iot.transform.AuditCheckDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditCheckDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, AuditCheckDetails> {
    private final String checkRunStatus;
    private final Boolean checkCompliant;
    private final Long totalResourcesCount;
    private final Long nonCompliantResourcesCount;
    private final String errorCode;
    private final String message;

    private AuditCheckDetails(BuilderImpl builder) {
        this.checkRunStatus = builder.checkRunStatus;
        this.checkCompliant = builder.checkCompliant;
        this.totalResourcesCount = builder.totalResourcesCount;
        this.nonCompliantResourcesCount = builder.nonCompliantResourcesCount;
        this.errorCode = builder.errorCode;
        this.message = builder.message;
    }

    public AuditCheckRunStatus checkRunStatus() {
        return AuditCheckRunStatus.fromValue(this.checkRunStatus);
    }

    public String checkRunStatusAsString() {
        return this.checkRunStatus;
    }

    public Boolean checkCompliant() {
        return this.checkCompliant;
    }

    public Long totalResourcesCount() {
        return this.totalResourcesCount;
    }

    public Long nonCompliantResourcesCount() {
        return this.nonCompliantResourcesCount;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checkRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkCompliant());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResourcesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantResourcesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditCheckDetails)) {
            return false;
        }
        AuditCheckDetails other = (AuditCheckDetails)obj;
        return Objects.equals(this.checkRunStatusAsString(), other.checkRunStatusAsString()) && Objects.equals(this.checkCompliant(), other.checkCompliant()) && Objects.equals(this.totalResourcesCount(), other.totalResourcesCount()) && Objects.equals(this.nonCompliantResourcesCount(), other.nonCompliantResourcesCount()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        return ToString.builder((String)"AuditCheckDetails").add("CheckRunStatus", (Object)this.checkRunStatusAsString()).add("CheckCompliant", (Object)this.checkCompliant()).add("TotalResourcesCount", (Object)this.totalResourcesCount()).add("NonCompliantResourcesCount", (Object)this.nonCompliantResourcesCount()).add("ErrorCode", (Object)this.errorCode()).add("Message", (Object)this.message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checkRunStatus": {
                return Optional.ofNullable(clazz.cast(this.checkRunStatusAsString()));
            }
            case "checkCompliant": {
                return Optional.ofNullable(clazz.cast(this.checkCompliant()));
            }
            case "totalResourcesCount": {
                return Optional.ofNullable(clazz.cast(this.totalResourcesCount()));
            }
            case "nonCompliantResourcesCount": {
                return Optional.ofNullable(clazz.cast(this.nonCompliantResourcesCount()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuditCheckDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String checkRunStatus;
        private Boolean checkCompliant;
        private Long totalResourcesCount;
        private Long nonCompliantResourcesCount;
        private String errorCode;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditCheckDetails model) {
            this.checkRunStatus(model.checkRunStatus);
            this.checkCompliant(model.checkCompliant);
            this.totalResourcesCount(model.totalResourcesCount);
            this.nonCompliantResourcesCount(model.nonCompliantResourcesCount);
            this.errorCode(model.errorCode);
            this.message(model.message);
        }

        public final String getCheckRunStatus() {
            return this.checkRunStatus;
        }

        @Override
        public final Builder checkRunStatus(String checkRunStatus) {
            this.checkRunStatus = checkRunStatus;
            return this;
        }

        @Override
        public final Builder checkRunStatus(AuditCheckRunStatus checkRunStatus) {
            this.checkRunStatus(checkRunStatus.toString());
            return this;
        }

        public final void setCheckRunStatus(String checkRunStatus) {
            this.checkRunStatus = checkRunStatus;
        }

        public final Boolean getCheckCompliant() {
            return this.checkCompliant;
        }

        @Override
        public final Builder checkCompliant(Boolean checkCompliant) {
            this.checkCompliant = checkCompliant;
            return this;
        }

        public final void setCheckCompliant(Boolean checkCompliant) {
            this.checkCompliant = checkCompliant;
        }

        public final Long getTotalResourcesCount() {
            return this.totalResourcesCount;
        }

        @Override
        public final Builder totalResourcesCount(Long totalResourcesCount) {
            this.totalResourcesCount = totalResourcesCount;
            return this;
        }

        public final void setTotalResourcesCount(Long totalResourcesCount) {
            this.totalResourcesCount = totalResourcesCount;
        }

        public final Long getNonCompliantResourcesCount() {
            return this.nonCompliantResourcesCount;
        }

        @Override
        public final Builder nonCompliantResourcesCount(Long nonCompliantResourcesCount) {
            this.nonCompliantResourcesCount = nonCompliantResourcesCount;
            return this;
        }

        public final void setNonCompliantResourcesCount(Long nonCompliantResourcesCount) {
            this.nonCompliantResourcesCount = nonCompliantResourcesCount;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public AuditCheckDetails build() {
            return new AuditCheckDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AuditCheckDetails> {
        public Builder checkRunStatus(String var1);

        public Builder checkRunStatus(AuditCheckRunStatus var1);

        public Builder checkCompliant(Boolean var1);

        public Builder totalResourcesCount(Long var1);

        public Builder nonCompliantResourcesCount(Long var1);

        public Builder errorCode(String var1);

        public Builder message(String var1);
    }
}

