/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptCertificateTransferRequest
extends IotRequest
implements ToCopyableBuilder<Builder, AcceptCertificateTransferRequest> {
    private final String certificateId;
    private final Boolean setAsActive;

    private AcceptCertificateTransferRequest(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.setAsActive = builder.setAsActive;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public Boolean setAsActive() {
        return this.setAsActive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.setAsActive());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptCertificateTransferRequest)) {
            return false;
        }
        AcceptCertificateTransferRequest other = (AcceptCertificateTransferRequest)((Object)obj);
        return Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.setAsActive(), other.setAsActive());
    }

    public String toString() {
        return ToString.builder((String)"AcceptCertificateTransferRequest").add("CertificateId", (Object)this.certificateId()).add("SetAsActive", (Object)this.setAsActive()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "setAsActive": {
                return Optional.ofNullable(clazz.cast(this.setAsActive()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String certificateId;
        private Boolean setAsActive;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptCertificateTransferRequest model) {
            super(model);
            this.certificateId(model.certificateId);
            this.setAsActive(model.setAsActive);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final Boolean getSetAsActive() {
            return this.setAsActive;
        }

        @Override
        public final Builder setAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
            return this;
        }

        public final void setSetAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptCertificateTransferRequest build() {
            return new AcceptCertificateTransferRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, AcceptCertificateTransferRequest> {
        public Builder certificateId(String var1);

        public Builder setAsActive(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

