/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.UpdateThingRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateThingRequestModelMarshaller {
    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("thingName").isBinary(false).build();
    private static final MarshallingInfo<String> THINGTYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingTypeName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTEPAYLOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributePayload").isBinary(false).build();
    private static final MarshallingInfo<Long> EXPECTEDVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expectedVersion").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REMOVETHINGTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("removeThingType").isBinary(false).build();
    private static final UpdateThingRequestModelMarshaller INSTANCE = new UpdateThingRequestModelMarshaller();

    private UpdateThingRequestModelMarshaller() {
    }

    public static UpdateThingRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateThingRequest updateThingRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateThingRequest), (String)"updateThingRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateThingRequest.thingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall((Object)updateThingRequest.thingTypeName(), THINGTYPENAME_BINDING);
            protocolMarshaller.marshall((Object)updateThingRequest.attributePayload(), ATTRIBUTEPAYLOAD_BINDING);
            protocolMarshaller.marshall((Object)updateThingRequest.expectedVersion(), EXPECTEDVERSION_BINDING);
            protocolMarshaller.marshall((Object)updateThingRequest.removeThingType(), REMOVETHINGTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

