/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.DynamoDBv2Action;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DynamoDBv2ActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PUTITEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("putItem").isBinary(false).build();
    private static final DynamoDBv2ActionMarshaller INSTANCE = new DynamoDBv2ActionMarshaller();

    private DynamoDBv2ActionMarshaller() {
    }

    public static DynamoDBv2ActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DynamoDBv2Action dynamoDBv2Action, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dynamoDBv2Action, (String)"dynamoDBv2Action");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dynamoDBv2Action.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBv2Action.putItem(), PUTITEM_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

