/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CloudwatchMetricAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CloudwatchMetricActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> METRICNAMESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricNamespace").isBinary(false).build();
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricName").isBinary(false).build();
    private static final MarshallingInfo<String> METRICVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricValue").isBinary(false).build();
    private static final MarshallingInfo<String> METRICUNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricUnit").isBinary(false).build();
    private static final MarshallingInfo<String> METRICTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricTimestamp").isBinary(false).build();
    private static final CloudwatchMetricActionMarshaller INSTANCE = new CloudwatchMetricActionMarshaller();

    private CloudwatchMetricActionMarshaller() {
    }

    public static CloudwatchMetricActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CloudwatchMetricAction cloudwatchMetricAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cloudwatchMetricAction, (String)"cloudwatchMetricAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cloudwatchMetricAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)cloudwatchMetricAction.metricNamespace(), METRICNAMESPACE_BINDING);
            protocolMarshaller.marshall((Object)cloudwatchMetricAction.metricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall((Object)cloudwatchMetricAction.metricValue(), METRICVALUE_BINDING);
            protocolMarshaller.marshall((Object)cloudwatchMetricAction.metricUnit(), METRICUNIT_BINDING);
            protocolMarshaller.marshall((Object)cloudwatchMetricAction.metricTimestamp(), METRICTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

