/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCaCertificatesRequest
extends IotRequest
implements ToCopyableBuilder<Builder, ListCaCertificatesRequest> {
    private final Integer pageSize;
    private final String marker;
    private final Boolean ascendingOrder;

    private ListCaCertificatesRequest(BuilderImpl builder) {
        super(builder);
        this.pageSize = builder.pageSize;
        this.marker = builder.marker;
        this.ascendingOrder = builder.ascendingOrder;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean ascendingOrder() {
        return this.ascendingOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.ascendingOrder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCaCertificatesRequest)) {
            return false;
        }
        ListCaCertificatesRequest other = (ListCaCertificatesRequest)((Object)obj);
        return Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.ascendingOrder(), other.ascendingOrder());
    }

    public String toString() {
        return ToString.builder((String)"ListCaCertificatesRequest").add("PageSize", (Object)this.pageSize()).add("Marker", (Object)this.marker()).add("AscendingOrder", (Object)this.ascendingOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ascendingOrder": {
                return Optional.ofNullable(clazz.cast(this.ascendingOrder()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private Integer pageSize;
        private String marker;
        private Boolean ascendingOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCaCertificatesRequest model) {
            super(model);
            this.pageSize(model.pageSize);
            this.marker(model.marker);
            this.ascendingOrder(model.ascendingOrder);
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getAscendingOrder() {
            return this.ascendingOrder;
        }

        @Override
        public final Builder ascendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
            return this;
        }

        public final void setAscendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCaCertificatesRequest build() {
            return new ListCaCertificatesRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, ListCaCertificatesRequest> {
        public Builder pageSize(Integer var1);

        public Builder marker(String var1);

        public Builder ascendingOrder(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

