/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.iot.model.AttributePayload;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateThingRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateThingRequest> {
    private final String thingName;
    private final String thingTypeName;
    private final AttributePayload attributePayload;

    private CreateThingRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.attributePayload = builder.attributePayload;
    }

    public String thingName() {
        return this.thingName;
    }

    public String thingTypeName() {
        return this.thingTypeName;
    }

    public AttributePayload attributePayload() {
        return this.attributePayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributePayload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingRequest)) {
            return false;
        }
        CreateThingRequest other = (CreateThingRequest)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.thingTypeName(), other.thingTypeName()) && Objects.equals(this.attributePayload(), other.attributePayload());
    }

    public String toString() {
        return ToString.builder((String)"CreateThingRequest").add("ThingName", (Object)this.thingName()).add("ThingTypeName", (Object)this.thingTypeName()).add("AttributePayload", (Object)this.attributePayload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "thingTypeName": {
                return Optional.ofNullable(clazz.cast(this.thingTypeName()));
            }
            case "attributePayload": {
                return Optional.ofNullable(clazz.cast(this.attributePayload()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String thingName;
        private String thingTypeName;
        private AttributePayload attributePayload;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingRequest model) {
            super(model);
            this.thingName(model.thingName);
            this.thingTypeName(model.thingTypeName);
            this.attributePayload(model.attributePayload);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final AttributePayload.Builder getAttributePayload() {
            return this.attributePayload != null ? this.attributePayload.toBuilder() : null;
        }

        @Override
        public final Builder attributePayload(AttributePayload attributePayload) {
            this.attributePayload = attributePayload;
            return this;
        }

        public final void setAttributePayload(AttributePayload.BuilderImpl attributePayload) {
            this.attributePayload = attributePayload != null ? attributePayload.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateThingRequest build() {
            return new CreateThingRequest(this);
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    CopyableBuilder<Builder, CreateThingRequest> {
        public Builder thingName(String var1);

        public Builder thingTypeName(String var1);

        public Builder attributePayload(AttributePayload var1);

        default public Builder attributePayload(Consumer<AttributePayload.Builder> attributePayload) {
            return this.attributePayload((AttributePayload)((AttributePayload.Builder)AttributePayload.builder().applyMutation(attributePayload)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

