/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.ThingTypeMetadata;
import software.amazon.awssdk.services.iot.model.ThingTypeProperties;
import software.amazon.awssdk.services.iot.transform.ThingTypeDefinitionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ThingTypeDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, ThingTypeDefinition> {
    private final String thingTypeName;
    private final ThingTypeProperties thingTypeProperties;
    private final ThingTypeMetadata thingTypeMetadata;

    private ThingTypeDefinition(BuilderImpl builder) {
        this.thingTypeName = builder.thingTypeName;
        this.thingTypeProperties = builder.thingTypeProperties;
        this.thingTypeMetadata = builder.thingTypeMetadata;
    }

    public String thingTypeName() {
        return this.thingTypeName;
    }

    public ThingTypeProperties thingTypeProperties() {
        return this.thingTypeProperties;
    }

    public ThingTypeMetadata thingTypeMetadata() {
        return this.thingTypeMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingTypeDefinition)) {
            return false;
        }
        ThingTypeDefinition other = (ThingTypeDefinition)obj;
        return Objects.equals(this.thingTypeName(), other.thingTypeName()) && Objects.equals(this.thingTypeProperties(), other.thingTypeProperties()) && Objects.equals(this.thingTypeMetadata(), other.thingTypeMetadata());
    }

    public String toString() {
        return ToString.builder((String)"ThingTypeDefinition").add("ThingTypeName", (Object)this.thingTypeName()).add("ThingTypeProperties", (Object)this.thingTypeProperties()).add("ThingTypeMetadata", (Object)this.thingTypeMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingTypeName": {
                return Optional.of(clazz.cast(this.thingTypeName()));
            }
            case "thingTypeProperties": {
                return Optional.of(clazz.cast(this.thingTypeProperties()));
            }
            case "thingTypeMetadata": {
                return Optional.of(clazz.cast(this.thingTypeMetadata()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingTypeDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingTypeName;
        private ThingTypeProperties thingTypeProperties;
        private ThingTypeMetadata thingTypeMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingTypeDefinition model) {
            this.thingTypeName(model.thingTypeName);
            this.thingTypeProperties(model.thingTypeProperties);
            this.thingTypeMetadata(model.thingTypeMetadata);
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final ThingTypeProperties.Builder getThingTypeProperties() {
            return this.thingTypeProperties != null ? this.thingTypeProperties.toBuilder() : null;
        }

        @Override
        public final Builder thingTypeProperties(ThingTypeProperties thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties;
            return this;
        }

        public final void setThingTypeProperties(ThingTypeProperties.BuilderImpl thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties != null ? thingTypeProperties.build() : null;
        }

        public final ThingTypeMetadata.Builder getThingTypeMetadata() {
            return this.thingTypeMetadata != null ? this.thingTypeMetadata.toBuilder() : null;
        }

        @Override
        public final Builder thingTypeMetadata(ThingTypeMetadata thingTypeMetadata) {
            this.thingTypeMetadata = thingTypeMetadata;
            return this;
        }

        public final void setThingTypeMetadata(ThingTypeMetadata.BuilderImpl thingTypeMetadata) {
            this.thingTypeMetadata = thingTypeMetadata != null ? thingTypeMetadata.build() : null;
        }

        public ThingTypeDefinition build() {
            return new ThingTypeDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ThingTypeDefinition> {
        public Builder thingTypeName(String var1);

        public Builder thingTypeProperties(ThingTypeProperties var1);

        default public Builder thingTypeProperties(Consumer<ThingTypeProperties.Builder> thingTypeProperties) {
            return this.thingTypeProperties((ThingTypeProperties)((ThingTypeProperties.Builder)ThingTypeProperties.builder().apply(thingTypeProperties)).build());
        }

        public Builder thingTypeMetadata(ThingTypeMetadata var1);

        default public Builder thingTypeMetadata(Consumer<ThingTypeMetadata.Builder> thingTypeMetadata) {
            return this.thingTypeMetadata((ThingTypeMetadata)((ThingTypeMetadata.Builder)ThingTypeMetadata.builder().apply(thingTypeMetadata)).build());
        }
    }
}

