/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iot.model.IoTRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListThingTypesRequest
extends IoTRequest
implements ToCopyableBuilder<Builder, ListThingTypesRequest> {
    private final String nextToken;
    private final Integer maxResults;
    private final String thingTypeName;

    private ListThingTypesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.thingTypeName = builder.thingTypeName;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String thingTypeName() {
        return this.thingTypeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingTypesRequest)) {
            return false;
        }
        ListThingTypesRequest other = (ListThingTypesRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.thingTypeName(), other.thingTypeName());
    }

    public String toString() {
        return ToString.builder((String)"ListThingTypesRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ThingTypeName", (Object)this.thingTypeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "thingTypeName": {
                return Optional.of(clazz.cast(this.thingTypeName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String thingTypeName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingTypesRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.thingTypeName(model.thingTypeName);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListThingTypesRequest build() {
            return new ListThingTypesRequest(this);
        }
    }

    public static interface Builder
    extends IoTRequest.Builder,
    CopyableBuilder<Builder, ListThingTypesRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder thingTypeName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

