/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.KeyPair;

public class KeyPairUnmarshaller
implements Unmarshaller<KeyPair, JsonUnmarshallerContext> {
    private static KeyPairUnmarshaller INSTANCE;

    public KeyPair unmarshall(JsonUnmarshallerContext context) throws Exception {
        KeyPair.Builder keyPairBuilder = KeyPair.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("PublicKey", targetDepth)) {
                    context.nextToken();
                    keyPairBuilder.publicKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PrivateKey", targetDepth)) {
                    context.nextToken();
                    keyPairBuilder.privateKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (KeyPair)keyPairBuilder.build();
    }

    public static KeyPairUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KeyPairUnmarshaller();
        }
        return INSTANCE;
    }
}

