/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.invoicing.InvoicingClient;
import software.amazon.awssdk.services.invoicing.internal.UserAgentUtils;
import software.amazon.awssdk.services.invoicing.model.ListProcurementPortalPreferencesRequest;
import software.amazon.awssdk.services.invoicing.model.ListProcurementPortalPreferencesResponse;
import software.amazon.awssdk.services.invoicing.model.ProcurementPortalPreferenceSummary;

public class ListProcurementPortalPreferencesIterable
implements SdkIterable<ListProcurementPortalPreferencesResponse> {
    private final InvoicingClient client;
    private final ListProcurementPortalPreferencesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProcurementPortalPreferencesIterable(InvoicingClient client, ListProcurementPortalPreferencesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProcurementPortalPreferencesResponseFetcher();
    }

    public Iterator<ListProcurementPortalPreferencesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProcurementPortalPreferenceSummary> procurementPortalPreferences() {
        Function<ListProcurementPortalPreferencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.procurementPortalPreferences() != null) {
                return response.procurementPortalPreferences().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProcurementPortalPreferencesResponseFetcher
    implements SyncPageFetcher<ListProcurementPortalPreferencesResponse> {
        private ListProcurementPortalPreferencesResponseFetcher() {
        }

        public boolean hasNextPage(ListProcurementPortalPreferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProcurementPortalPreferencesResponse nextPage(ListProcurementPortalPreferencesResponse previousPage) {
            if (previousPage == null) {
                return ListProcurementPortalPreferencesIterable.this.client.listProcurementPortalPreferences(ListProcurementPortalPreferencesIterable.this.firstRequest);
            }
            return ListProcurementPortalPreferencesIterable.this.client.listProcurementPortalPreferences((ListProcurementPortalPreferencesRequest)((Object)ListProcurementPortalPreferencesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

