/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.invoicing.model.Contact;
import software.amazon.awssdk.services.invoicing.model.ContactsCopier;
import software.amazon.awssdk.services.invoicing.model.EinvoiceDeliveryPreference;
import software.amazon.awssdk.services.invoicing.model.InvoicingRequest;
import software.amazon.awssdk.services.invoicing.model.ProcurementPortalPreferenceSelector;
import software.amazon.awssdk.services.invoicing.model.TestEnvPreferenceInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutProcurementPortalPreferenceRequest
extends InvoicingRequest
implements ToCopyableBuilder<Builder, PutProcurementPortalPreferenceRequest> {
    private static final SdkField<String> PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcurementPortalPreferenceArn").getter(PutProcurementPortalPreferenceRequest.getter(PutProcurementPortalPreferenceRequest::procurementPortalPreferenceArn)).setter(PutProcurementPortalPreferenceRequest.setter(Builder::procurementPortalPreferenceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalPreferenceArn").build()}).build();
    private static final SdkField<ProcurementPortalPreferenceSelector> SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Selector").getter(PutProcurementPortalPreferenceRequest.getter(PutProcurementPortalPreferenceRequest::selector)).setter(PutProcurementPortalPreferenceRequest.setter(Builder::selector)).constructor(ProcurementPortalPreferenceSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Selector").build()}).build();
    private static final SdkField<String> PROCUREMENT_PORTAL_SHARED_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcurementPortalSharedSecret").getter(PutProcurementPortalPreferenceRequest.getter(PutProcurementPortalPreferenceRequest::procurementPortalSharedSecret)).setter(PutProcurementPortalPreferenceRequest.setter(Builder::procurementPortalSharedSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalSharedSecret").build()}).build();
    private static final SdkField<String> PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcurementPortalInstanceEndpoint").getter(PutProcurementPortalPreferenceRequest.getter(PutProcurementPortalPreferenceRequest::procurementPortalInstanceEndpoint)).setter(PutProcurementPortalPreferenceRequest.setter(Builder::procurementPortalInstanceEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalInstanceEndpoint").build()}).build();
    private static final SdkField<TestEnvPreferenceInput> TEST_ENV_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TestEnvPreference").getter(PutProcurementPortalPreferenceRequest.getter(PutProcurementPortalPreferenceRequest::testEnvPreference)).setter(PutProcurementPortalPreferenceRequest.setter(Builder::testEnvPreference)).constructor(TestEnvPreferenceInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestEnvPreference").build()}).build();
    private static final SdkField<Boolean> EINVOICE_DELIVERY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EinvoiceDeliveryEnabled").getter(PutProcurementPortalPreferenceRequest.getter(PutProcurementPortalPreferenceRequest::einvoiceDeliveryEnabled)).setter(PutProcurementPortalPreferenceRequest.setter(Builder::einvoiceDeliveryEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryEnabled").build()}).build();
    private static final SdkField<EinvoiceDeliveryPreference> EINVOICE_DELIVERY_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EinvoiceDeliveryPreference").getter(PutProcurementPortalPreferenceRequest.getter(PutProcurementPortalPreferenceRequest::einvoiceDeliveryPreference)).setter(PutProcurementPortalPreferenceRequest.setter(Builder::einvoiceDeliveryPreference)).constructor(EinvoiceDeliveryPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryPreference").build()}).build();
    private static final SdkField<Boolean> PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PurchaseOrderRetrievalEnabled").getter(PutProcurementPortalPreferenceRequest.getter(PutProcurementPortalPreferenceRequest::purchaseOrderRetrievalEnabled)).setter(PutProcurementPortalPreferenceRequest.setter(Builder::purchaseOrderRetrievalEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderRetrievalEnabled").build()}).build();
    private static final SdkField<List<Contact>> CONTACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Contacts").getter(PutProcurementPortalPreferenceRequest.getter(PutProcurementPortalPreferenceRequest::contacts)).setter(PutProcurementPortalPreferenceRequest.setter(Builder::contacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Contact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD, SELECTOR_FIELD, PROCUREMENT_PORTAL_SHARED_SECRET_FIELD, PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD, TEST_ENV_PREFERENCE_FIELD, EINVOICE_DELIVERY_ENABLED_FIELD, EINVOICE_DELIVERY_PREFERENCE_FIELD, PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD, CONTACTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutProcurementPortalPreferenceRequest.memberNameToFieldInitializer();
    private final String procurementPortalPreferenceArn;
    private final ProcurementPortalPreferenceSelector selector;
    private final String procurementPortalSharedSecret;
    private final String procurementPortalInstanceEndpoint;
    private final TestEnvPreferenceInput testEnvPreference;
    private final Boolean einvoiceDeliveryEnabled;
    private final EinvoiceDeliveryPreference einvoiceDeliveryPreference;
    private final Boolean purchaseOrderRetrievalEnabled;
    private final List<Contact> contacts;

    private PutProcurementPortalPreferenceRequest(BuilderImpl builder) {
        super(builder);
        this.procurementPortalPreferenceArn = builder.procurementPortalPreferenceArn;
        this.selector = builder.selector;
        this.procurementPortalSharedSecret = builder.procurementPortalSharedSecret;
        this.procurementPortalInstanceEndpoint = builder.procurementPortalInstanceEndpoint;
        this.testEnvPreference = builder.testEnvPreference;
        this.einvoiceDeliveryEnabled = builder.einvoiceDeliveryEnabled;
        this.einvoiceDeliveryPreference = builder.einvoiceDeliveryPreference;
        this.purchaseOrderRetrievalEnabled = builder.purchaseOrderRetrievalEnabled;
        this.contacts = builder.contacts;
    }

    public final String procurementPortalPreferenceArn() {
        return this.procurementPortalPreferenceArn;
    }

    public final ProcurementPortalPreferenceSelector selector() {
        return this.selector;
    }

    public final String procurementPortalSharedSecret() {
        return this.procurementPortalSharedSecret;
    }

    public final String procurementPortalInstanceEndpoint() {
        return this.procurementPortalInstanceEndpoint;
    }

    public final TestEnvPreferenceInput testEnvPreference() {
        return this.testEnvPreference;
    }

    public final Boolean einvoiceDeliveryEnabled() {
        return this.einvoiceDeliveryEnabled;
    }

    public final EinvoiceDeliveryPreference einvoiceDeliveryPreference() {
        return this.einvoiceDeliveryPreference;
    }

    public final Boolean purchaseOrderRetrievalEnabled() {
        return this.purchaseOrderRetrievalEnabled;
    }

    public final boolean hasContacts() {
        return this.contacts != null && !(this.contacts instanceof SdkAutoConstructList);
    }

    public final List<Contact> contacts() {
        return this.contacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.procurementPortalPreferenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.selector());
        hashCode = 31 * hashCode + Objects.hashCode(this.procurementPortalSharedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.procurementPortalInstanceEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.testEnvPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.einvoiceDeliveryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.einvoiceDeliveryPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseOrderRetrievalEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContacts() ? this.contacts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProcurementPortalPreferenceRequest)) {
            return false;
        }
        PutProcurementPortalPreferenceRequest other = (PutProcurementPortalPreferenceRequest)((Object)obj);
        return Objects.equals(this.procurementPortalPreferenceArn(), other.procurementPortalPreferenceArn()) && Objects.equals(this.selector(), other.selector()) && Objects.equals(this.procurementPortalSharedSecret(), other.procurementPortalSharedSecret()) && Objects.equals(this.procurementPortalInstanceEndpoint(), other.procurementPortalInstanceEndpoint()) && Objects.equals(this.testEnvPreference(), other.testEnvPreference()) && Objects.equals(this.einvoiceDeliveryEnabled(), other.einvoiceDeliveryEnabled()) && Objects.equals(this.einvoiceDeliveryPreference(), other.einvoiceDeliveryPreference()) && Objects.equals(this.purchaseOrderRetrievalEnabled(), other.purchaseOrderRetrievalEnabled()) && this.hasContacts() == other.hasContacts() && Objects.equals(this.contacts(), other.contacts());
    }

    public final String toString() {
        return ToString.builder((String)"PutProcurementPortalPreferenceRequest").add("ProcurementPortalPreferenceArn", (Object)this.procurementPortalPreferenceArn()).add("Selector", (Object)this.selector()).add("ProcurementPortalSharedSecret", (Object)(this.procurementPortalSharedSecret() == null ? null : "*** Sensitive Data Redacted ***")).add("ProcurementPortalInstanceEndpoint", (Object)this.procurementPortalInstanceEndpoint()).add("TestEnvPreference", (Object)this.testEnvPreference()).add("EinvoiceDeliveryEnabled", (Object)this.einvoiceDeliveryEnabled()).add("EinvoiceDeliveryPreference", (Object)this.einvoiceDeliveryPreference()).add("PurchaseOrderRetrievalEnabled", (Object)this.purchaseOrderRetrievalEnabled()).add("Contacts", (Object)(this.contacts() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcurementPortalPreferenceArn": {
                return Optional.ofNullable(clazz.cast(this.procurementPortalPreferenceArn()));
            }
            case "Selector": {
                return Optional.ofNullable(clazz.cast(this.selector()));
            }
            case "ProcurementPortalSharedSecret": {
                return Optional.ofNullable(clazz.cast(this.procurementPortalSharedSecret()));
            }
            case "ProcurementPortalInstanceEndpoint": {
                return Optional.ofNullable(clazz.cast(this.procurementPortalInstanceEndpoint()));
            }
            case "TestEnvPreference": {
                return Optional.ofNullable(clazz.cast(this.testEnvPreference()));
            }
            case "EinvoiceDeliveryEnabled": {
                return Optional.ofNullable(clazz.cast(this.einvoiceDeliveryEnabled()));
            }
            case "EinvoiceDeliveryPreference": {
                return Optional.ofNullable(clazz.cast(this.einvoiceDeliveryPreference()));
            }
            case "PurchaseOrderRetrievalEnabled": {
                return Optional.ofNullable(clazz.cast(this.purchaseOrderRetrievalEnabled()));
            }
            case "Contacts": {
                return Optional.ofNullable(clazz.cast(this.contacts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProcurementPortalPreferenceArn", PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD);
        map.put("Selector", SELECTOR_FIELD);
        map.put("ProcurementPortalSharedSecret", PROCUREMENT_PORTAL_SHARED_SECRET_FIELD);
        map.put("ProcurementPortalInstanceEndpoint", PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD);
        map.put("TestEnvPreference", TEST_ENV_PREFERENCE_FIELD);
        map.put("EinvoiceDeliveryEnabled", EINVOICE_DELIVERY_ENABLED_FIELD);
        map.put("EinvoiceDeliveryPreference", EINVOICE_DELIVERY_PREFERENCE_FIELD);
        map.put("PurchaseOrderRetrievalEnabled", PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD);
        map.put("Contacts", CONTACTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutProcurementPortalPreferenceRequest, T> g) {
        return obj -> g.apply((PutProcurementPortalPreferenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InvoicingRequest.BuilderImpl
    implements Builder {
        private String procurementPortalPreferenceArn;
        private ProcurementPortalPreferenceSelector selector;
        private String procurementPortalSharedSecret;
        private String procurementPortalInstanceEndpoint;
        private TestEnvPreferenceInput testEnvPreference;
        private Boolean einvoiceDeliveryEnabled;
        private EinvoiceDeliveryPreference einvoiceDeliveryPreference;
        private Boolean purchaseOrderRetrievalEnabled;
        private List<Contact> contacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutProcurementPortalPreferenceRequest model) {
            super(model);
            this.procurementPortalPreferenceArn(model.procurementPortalPreferenceArn);
            this.selector(model.selector);
            this.procurementPortalSharedSecret(model.procurementPortalSharedSecret);
            this.procurementPortalInstanceEndpoint(model.procurementPortalInstanceEndpoint);
            this.testEnvPreference(model.testEnvPreference);
            this.einvoiceDeliveryEnabled(model.einvoiceDeliveryEnabled);
            this.einvoiceDeliveryPreference(model.einvoiceDeliveryPreference);
            this.purchaseOrderRetrievalEnabled(model.purchaseOrderRetrievalEnabled);
            this.contacts(model.contacts);
        }

        public final String getProcurementPortalPreferenceArn() {
            return this.procurementPortalPreferenceArn;
        }

        public final void setProcurementPortalPreferenceArn(String procurementPortalPreferenceArn) {
            this.procurementPortalPreferenceArn = procurementPortalPreferenceArn;
        }

        @Override
        public final Builder procurementPortalPreferenceArn(String procurementPortalPreferenceArn) {
            this.procurementPortalPreferenceArn = procurementPortalPreferenceArn;
            return this;
        }

        public final ProcurementPortalPreferenceSelector.Builder getSelector() {
            return this.selector != null ? this.selector.toBuilder() : null;
        }

        public final void setSelector(ProcurementPortalPreferenceSelector.BuilderImpl selector) {
            this.selector = selector != null ? selector.build() : null;
        }

        @Override
        public final Builder selector(ProcurementPortalPreferenceSelector selector) {
            this.selector = selector;
            return this;
        }

        public final String getProcurementPortalSharedSecret() {
            return this.procurementPortalSharedSecret;
        }

        public final void setProcurementPortalSharedSecret(String procurementPortalSharedSecret) {
            this.procurementPortalSharedSecret = procurementPortalSharedSecret;
        }

        @Override
        public final Builder procurementPortalSharedSecret(String procurementPortalSharedSecret) {
            this.procurementPortalSharedSecret = procurementPortalSharedSecret;
            return this;
        }

        public final String getProcurementPortalInstanceEndpoint() {
            return this.procurementPortalInstanceEndpoint;
        }

        public final void setProcurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint) {
            this.procurementPortalInstanceEndpoint = procurementPortalInstanceEndpoint;
        }

        @Override
        public final Builder procurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint) {
            this.procurementPortalInstanceEndpoint = procurementPortalInstanceEndpoint;
            return this;
        }

        public final TestEnvPreferenceInput.Builder getTestEnvPreference() {
            return this.testEnvPreference != null ? this.testEnvPreference.toBuilder() : null;
        }

        public final void setTestEnvPreference(TestEnvPreferenceInput.BuilderImpl testEnvPreference) {
            this.testEnvPreference = testEnvPreference != null ? testEnvPreference.build() : null;
        }

        @Override
        public final Builder testEnvPreference(TestEnvPreferenceInput testEnvPreference) {
            this.testEnvPreference = testEnvPreference;
            return this;
        }

        public final Boolean getEinvoiceDeliveryEnabled() {
            return this.einvoiceDeliveryEnabled;
        }

        public final void setEinvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled) {
            this.einvoiceDeliveryEnabled = einvoiceDeliveryEnabled;
        }

        @Override
        public final Builder einvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled) {
            this.einvoiceDeliveryEnabled = einvoiceDeliveryEnabled;
            return this;
        }

        public final EinvoiceDeliveryPreference.Builder getEinvoiceDeliveryPreference() {
            return this.einvoiceDeliveryPreference != null ? this.einvoiceDeliveryPreference.toBuilder() : null;
        }

        public final void setEinvoiceDeliveryPreference(EinvoiceDeliveryPreference.BuilderImpl einvoiceDeliveryPreference) {
            this.einvoiceDeliveryPreference = einvoiceDeliveryPreference != null ? einvoiceDeliveryPreference.build() : null;
        }

        @Override
        public final Builder einvoiceDeliveryPreference(EinvoiceDeliveryPreference einvoiceDeliveryPreference) {
            this.einvoiceDeliveryPreference = einvoiceDeliveryPreference;
            return this;
        }

        public final Boolean getPurchaseOrderRetrievalEnabled() {
            return this.purchaseOrderRetrievalEnabled;
        }

        public final void setPurchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled) {
            this.purchaseOrderRetrievalEnabled = purchaseOrderRetrievalEnabled;
        }

        @Override
        public final Builder purchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled) {
            this.purchaseOrderRetrievalEnabled = purchaseOrderRetrievalEnabled;
            return this;
        }

        public final List<Contact.Builder> getContacts() {
            List<Contact.Builder> result = ContactsCopier.copyToBuilder(this.contacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContacts(Collection<Contact.BuilderImpl> contacts) {
            this.contacts = ContactsCopier.copyFromBuilder(contacts);
        }

        @Override
        public final Builder contacts(Collection<Contact> contacts) {
            this.contacts = ContactsCopier.copy(contacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Contact ... contacts) {
            this.contacts(Arrays.asList(contacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Consumer<Contact.Builder> ... contacts) {
            this.contacts(Stream.of(contacts).map(c -> (Contact)((Contact.Builder)Contact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutProcurementPortalPreferenceRequest build() {
            return new PutProcurementPortalPreferenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends InvoicingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutProcurementPortalPreferenceRequest> {
        public Builder procurementPortalPreferenceArn(String var1);

        public Builder selector(ProcurementPortalPreferenceSelector var1);

        default public Builder selector(Consumer<ProcurementPortalPreferenceSelector.Builder> selector) {
            return this.selector((ProcurementPortalPreferenceSelector)((ProcurementPortalPreferenceSelector.Builder)ProcurementPortalPreferenceSelector.builder().applyMutation(selector)).build());
        }

        public Builder procurementPortalSharedSecret(String var1);

        public Builder procurementPortalInstanceEndpoint(String var1);

        public Builder testEnvPreference(TestEnvPreferenceInput var1);

        default public Builder testEnvPreference(Consumer<TestEnvPreferenceInput.Builder> testEnvPreference) {
            return this.testEnvPreference((TestEnvPreferenceInput)((TestEnvPreferenceInput.Builder)TestEnvPreferenceInput.builder().applyMutation(testEnvPreference)).build());
        }

        public Builder einvoiceDeliveryEnabled(Boolean var1);

        public Builder einvoiceDeliveryPreference(EinvoiceDeliveryPreference var1);

        default public Builder einvoiceDeliveryPreference(Consumer<EinvoiceDeliveryPreference.Builder> einvoiceDeliveryPreference) {
            return this.einvoiceDeliveryPreference((EinvoiceDeliveryPreference)((EinvoiceDeliveryPreference.Builder)EinvoiceDeliveryPreference.builder().applyMutation(einvoiceDeliveryPreference)).build());
        }

        public Builder purchaseOrderRetrievalEnabled(Boolean var1);

        public Builder contacts(Collection<Contact> var1);

        public Builder contacts(Contact ... var1);

        public Builder contacts(Consumer<Contact.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

