/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input parameters for configuring test environment preferences for a procurement portal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestEnvPreferenceInput implements SdkPojo, Serializable,
        ToCopyableBuilder<TestEnvPreferenceInput.Builder, TestEnvPreferenceInput> {
    private static final SdkField<String> BUYER_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BuyerDomain").getter(getter(TestEnvPreferenceInput::buyerDomainAsString))
            .setter(setter(Builder::buyerDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerDomain").build()).build();

    private static final SdkField<String> BUYER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BuyerIdentifier").getter(getter(TestEnvPreferenceInput::buyerIdentifier))
            .setter(setter(Builder::buyerIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerIdentifier").build()).build();

    private static final SdkField<String> SUPPLIER_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupplierDomain").getter(getter(TestEnvPreferenceInput::supplierDomainAsString))
            .setter(setter(Builder::supplierDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplierDomain").build()).build();

    private static final SdkField<String> SUPPLIER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupplierIdentifier").getter(getter(TestEnvPreferenceInput::supplierIdentifier))
            .setter(setter(Builder::supplierIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplierIdentifier").build())
            .build();

    private static final SdkField<String> PROCUREMENT_PORTAL_SHARED_SECRET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProcurementPortalSharedSecret")
            .getter(getter(TestEnvPreferenceInput::procurementPortalSharedSecret))
            .setter(setter(Builder::procurementPortalSharedSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalSharedSecret")
                    .build()).build();

    private static final SdkField<String> PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProcurementPortalInstanceEndpoint")
            .getter(getter(TestEnvPreferenceInput::procurementPortalInstanceEndpoint))
            .setter(setter(Builder::procurementPortalInstanceEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalInstanceEndpoint")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUYER_DOMAIN_FIELD,
            BUYER_IDENTIFIER_FIELD, SUPPLIER_DOMAIN_FIELD, SUPPLIER_IDENTIFIER_FIELD, PROCUREMENT_PORTAL_SHARED_SECRET_FIELD,
            PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String buyerDomain;

    private final String buyerIdentifier;

    private final String supplierDomain;

    private final String supplierIdentifier;

    private final String procurementPortalSharedSecret;

    private final String procurementPortalInstanceEndpoint;

    private TestEnvPreferenceInput(BuilderImpl builder) {
        this.buyerDomain = builder.buyerDomain;
        this.buyerIdentifier = builder.buyerIdentifier;
        this.supplierDomain = builder.supplierDomain;
        this.supplierIdentifier = builder.supplierIdentifier;
        this.procurementPortalSharedSecret = builder.procurementPortalSharedSecret;
        this.procurementPortalInstanceEndpoint = builder.procurementPortalInstanceEndpoint;
    }

    /**
     * <p>
     * The domain identifier to use for the buyer in the test environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buyerDomain} will
     * return {@link BuyerDomain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #buyerDomainAsString}.
     * </p>
     * 
     * @return The domain identifier to use for the buyer in the test environment.
     * @see BuyerDomain
     */
    public final BuyerDomain buyerDomain() {
        return BuyerDomain.fromValue(buyerDomain);
    }

    /**
     * <p>
     * The domain identifier to use for the buyer in the test environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buyerDomain} will
     * return {@link BuyerDomain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #buyerDomainAsString}.
     * </p>
     * 
     * @return The domain identifier to use for the buyer in the test environment.
     * @see BuyerDomain
     */
    public final String buyerDomainAsString() {
        return buyerDomain;
    }

    /**
     * <p>
     * The unique identifier to use for the buyer in the test environment.
     * </p>
     * 
     * @return The unique identifier to use for the buyer in the test environment.
     */
    public final String buyerIdentifier() {
        return buyerIdentifier;
    }

    /**
     * <p>
     * The domain identifier to use for the supplier in the test environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #supplierDomain}
     * will return {@link SupplierDomain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #supplierDomainAsString}.
     * </p>
     * 
     * @return The domain identifier to use for the supplier in the test environment.
     * @see SupplierDomain
     */
    public final SupplierDomain supplierDomain() {
        return SupplierDomain.fromValue(supplierDomain);
    }

    /**
     * <p>
     * The domain identifier to use for the supplier in the test environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #supplierDomain}
     * will return {@link SupplierDomain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #supplierDomainAsString}.
     * </p>
     * 
     * @return The domain identifier to use for the supplier in the test environment.
     * @see SupplierDomain
     */
    public final String supplierDomainAsString() {
        return supplierDomain;
    }

    /**
     * <p>
     * The unique identifier to use for the supplier in the test environment.
     * </p>
     * 
     * @return The unique identifier to use for the supplier in the test environment.
     */
    public final String supplierIdentifier() {
        return supplierIdentifier;
    }

    /**
     * <p>
     * The shared secret or authentication credential to use for secure communication in the test environment.
     * </p>
     * 
     * @return The shared secret or authentication credential to use for secure communication in the test environment.
     */
    public final String procurementPortalSharedSecret() {
        return procurementPortalSharedSecret;
    }

    /**
     * <p>
     * The endpoint URL where e-invoices will be delivered in the test environment.
     * </p>
     * 
     * @return The endpoint URL where e-invoices will be delivered in the test environment.
     */
    public final String procurementPortalInstanceEndpoint() {
        return procurementPortalInstanceEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(buyerDomainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(buyerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(supplierDomainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(supplierIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(procurementPortalSharedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(procurementPortalInstanceEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestEnvPreferenceInput)) {
            return false;
        }
        TestEnvPreferenceInput other = (TestEnvPreferenceInput) obj;
        return Objects.equals(buyerDomainAsString(), other.buyerDomainAsString())
                && Objects.equals(buyerIdentifier(), other.buyerIdentifier())
                && Objects.equals(supplierDomainAsString(), other.supplierDomainAsString())
                && Objects.equals(supplierIdentifier(), other.supplierIdentifier())
                && Objects.equals(procurementPortalSharedSecret(), other.procurementPortalSharedSecret())
                && Objects.equals(procurementPortalInstanceEndpoint(), other.procurementPortalInstanceEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestEnvPreferenceInput").add("BuyerDomain", buyerDomainAsString())
                .add("BuyerIdentifier", buyerIdentifier()).add("SupplierDomain", supplierDomainAsString())
                .add("SupplierIdentifier", supplierIdentifier())
                .add("ProcurementPortalSharedSecret", procurementPortalSharedSecret())
                .add("ProcurementPortalInstanceEndpoint", procurementPortalInstanceEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BuyerDomain":
            return Optional.ofNullable(clazz.cast(buyerDomainAsString()));
        case "BuyerIdentifier":
            return Optional.ofNullable(clazz.cast(buyerIdentifier()));
        case "SupplierDomain":
            return Optional.ofNullable(clazz.cast(supplierDomainAsString()));
        case "SupplierIdentifier":
            return Optional.ofNullable(clazz.cast(supplierIdentifier()));
        case "ProcurementPortalSharedSecret":
            return Optional.ofNullable(clazz.cast(procurementPortalSharedSecret()));
        case "ProcurementPortalInstanceEndpoint":
            return Optional.ofNullable(clazz.cast(procurementPortalInstanceEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BuyerDomain", BUYER_DOMAIN_FIELD);
        map.put("BuyerIdentifier", BUYER_IDENTIFIER_FIELD);
        map.put("SupplierDomain", SUPPLIER_DOMAIN_FIELD);
        map.put("SupplierIdentifier", SUPPLIER_IDENTIFIER_FIELD);
        map.put("ProcurementPortalSharedSecret", PROCUREMENT_PORTAL_SHARED_SECRET_FIELD);
        map.put("ProcurementPortalInstanceEndpoint", PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestEnvPreferenceInput, T> g) {
        return obj -> g.apply((TestEnvPreferenceInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestEnvPreferenceInput> {
        /**
         * <p>
         * The domain identifier to use for the buyer in the test environment.
         * </p>
         * 
         * @param buyerDomain
         *        The domain identifier to use for the buyer in the test environment.
         * @see BuyerDomain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BuyerDomain
         */
        Builder buyerDomain(String buyerDomain);

        /**
         * <p>
         * The domain identifier to use for the buyer in the test environment.
         * </p>
         * 
         * @param buyerDomain
         *        The domain identifier to use for the buyer in the test environment.
         * @see BuyerDomain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BuyerDomain
         */
        Builder buyerDomain(BuyerDomain buyerDomain);

        /**
         * <p>
         * The unique identifier to use for the buyer in the test environment.
         * </p>
         * 
         * @param buyerIdentifier
         *        The unique identifier to use for the buyer in the test environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buyerIdentifier(String buyerIdentifier);

        /**
         * <p>
         * The domain identifier to use for the supplier in the test environment.
         * </p>
         * 
         * @param supplierDomain
         *        The domain identifier to use for the supplier in the test environment.
         * @see SupplierDomain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupplierDomain
         */
        Builder supplierDomain(String supplierDomain);

        /**
         * <p>
         * The domain identifier to use for the supplier in the test environment.
         * </p>
         * 
         * @param supplierDomain
         *        The domain identifier to use for the supplier in the test environment.
         * @see SupplierDomain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupplierDomain
         */
        Builder supplierDomain(SupplierDomain supplierDomain);

        /**
         * <p>
         * The unique identifier to use for the supplier in the test environment.
         * </p>
         * 
         * @param supplierIdentifier
         *        The unique identifier to use for the supplier in the test environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplierIdentifier(String supplierIdentifier);

        /**
         * <p>
         * The shared secret or authentication credential to use for secure communication in the test environment.
         * </p>
         * 
         * @param procurementPortalSharedSecret
         *        The shared secret or authentication credential to use for secure communication in the test
         *        environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder procurementPortalSharedSecret(String procurementPortalSharedSecret);

        /**
         * <p>
         * The endpoint URL where e-invoices will be delivered in the test environment.
         * </p>
         * 
         * @param procurementPortalInstanceEndpoint
         *        The endpoint URL where e-invoices will be delivered in the test environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder procurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String buyerDomain;

        private String buyerIdentifier;

        private String supplierDomain;

        private String supplierIdentifier;

        private String procurementPortalSharedSecret;

        private String procurementPortalInstanceEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(TestEnvPreferenceInput model) {
            buyerDomain(model.buyerDomain);
            buyerIdentifier(model.buyerIdentifier);
            supplierDomain(model.supplierDomain);
            supplierIdentifier(model.supplierIdentifier);
            procurementPortalSharedSecret(model.procurementPortalSharedSecret);
            procurementPortalInstanceEndpoint(model.procurementPortalInstanceEndpoint);
        }

        public final String getBuyerDomain() {
            return buyerDomain;
        }

        public final void setBuyerDomain(String buyerDomain) {
            this.buyerDomain = buyerDomain;
        }

        @Override
        public final Builder buyerDomain(String buyerDomain) {
            this.buyerDomain = buyerDomain;
            return this;
        }

        @Override
        public final Builder buyerDomain(BuyerDomain buyerDomain) {
            this.buyerDomain(buyerDomain == null ? null : buyerDomain.toString());
            return this;
        }

        public final String getBuyerIdentifier() {
            return buyerIdentifier;
        }

        public final void setBuyerIdentifier(String buyerIdentifier) {
            this.buyerIdentifier = buyerIdentifier;
        }

        @Override
        public final Builder buyerIdentifier(String buyerIdentifier) {
            this.buyerIdentifier = buyerIdentifier;
            return this;
        }

        public final String getSupplierDomain() {
            return supplierDomain;
        }

        public final void setSupplierDomain(String supplierDomain) {
            this.supplierDomain = supplierDomain;
        }

        @Override
        public final Builder supplierDomain(String supplierDomain) {
            this.supplierDomain = supplierDomain;
            return this;
        }

        @Override
        public final Builder supplierDomain(SupplierDomain supplierDomain) {
            this.supplierDomain(supplierDomain == null ? null : supplierDomain.toString());
            return this;
        }

        public final String getSupplierIdentifier() {
            return supplierIdentifier;
        }

        public final void setSupplierIdentifier(String supplierIdentifier) {
            this.supplierIdentifier = supplierIdentifier;
        }

        @Override
        public final Builder supplierIdentifier(String supplierIdentifier) {
            this.supplierIdentifier = supplierIdentifier;
            return this;
        }

        public final String getProcurementPortalSharedSecret() {
            return procurementPortalSharedSecret;
        }

        public final void setProcurementPortalSharedSecret(String procurementPortalSharedSecret) {
            this.procurementPortalSharedSecret = procurementPortalSharedSecret;
        }

        @Override
        public final Builder procurementPortalSharedSecret(String procurementPortalSharedSecret) {
            this.procurementPortalSharedSecret = procurementPortalSharedSecret;
            return this;
        }

        public final String getProcurementPortalInstanceEndpoint() {
            return procurementPortalInstanceEndpoint;
        }

        public final void setProcurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint) {
            this.procurementPortalInstanceEndpoint = procurementPortalInstanceEndpoint;
        }

        @Override
        public final Builder procurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint) {
            this.procurementPortalInstanceEndpoint = procurementPortalInstanceEndpoint;
            return this;
        }

        @Override
        public TestEnvPreferenceInput build() {
            return new TestEnvPreferenceInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
