/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tax amount.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaxesBreakdownAmount implements SdkPojo, Serializable,
        ToCopyableBuilder<TaxesBreakdownAmount.Builder, TaxesBreakdownAmount> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(TaxesBreakdownAmount::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Amount")
            .getter(getter(TaxesBreakdownAmount::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amount").build()).build();

    private static final SdkField<String> RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Rate")
            .getter(getter(TaxesBreakdownAmount::rate)).setter(setter(Builder::rate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            AMOUNT_FIELD, RATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String amount;

    private final String rate;

    private TaxesBreakdownAmount(BuilderImpl builder) {
        this.description = builder.description;
        this.amount = builder.amount;
        this.rate = builder.rate;
    }

    /**
     * <p>
     * The details of the taxes.
     * </p>
     * 
     * @return The details of the taxes.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The tax amount.
     * </p>
     * 
     * @return The tax amount.
     */
    public final String amount() {
        return amount;
    }

    /**
     * <p>
     * The details of the tax rate.
     * </p>
     * 
     * @return The details of the tax rate.
     */
    public final String rate() {
        return rate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(rate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxesBreakdownAmount)) {
            return false;
        }
        TaxesBreakdownAmount other = (TaxesBreakdownAmount) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(amount(), other.amount())
                && Objects.equals(rate(), other.rate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaxesBreakdownAmount").add("Description", description()).add("Amount", amount())
                .add("Rate", rate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "Rate":
            return Optional.ofNullable(clazz.cast(rate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Amount", AMOUNT_FIELD);
        map.put("Rate", RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaxesBreakdownAmount, T> g) {
        return obj -> g.apply((TaxesBreakdownAmount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaxesBreakdownAmount> {
        /**
         * <p>
         * The details of the taxes.
         * </p>
         * 
         * @param description
         *        The details of the taxes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tax amount.
         * </p>
         * 
         * @param amount
         *        The tax amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(String amount);

        /**
         * <p>
         * The details of the tax rate.
         * </p>
         * 
         * @param rate
         *        The details of the tax rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rate(String rate);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String amount;

        private String rate;

        private BuilderImpl() {
        }

        private BuilderImpl(TaxesBreakdownAmount model) {
            description(model.description);
            amount(model.amount);
            rate(model.rate);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAmount() {
            return amount;
        }

        public final void setAmount(String amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(String amount) {
            this.amount = amount;
            return this;
        }

        public final String getRate() {
            return rate;
        }

        public final void setRate(String rate) {
            this.rate = rate;
        }

        @Override
        public final Builder rate(String rate) {
            this.rate = rate;
            return this;
        }

        @Override
        public TaxesBreakdownAmount build() {
            return new TaxesBreakdownAmount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
