/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Supplemental document associated with the invoice.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupplementalDocument implements SdkPojo, Serializable,
        ToCopyableBuilder<SupplementalDocument.Builder, SupplementalDocument> {
    private static final SdkField<String> DOCUMENT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentUrl").getter(getter(SupplementalDocument::documentUrl)).setter(setter(Builder::documentUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentUrl").build()).build();

    private static final SdkField<Instant> DOCUMENT_URL_EXPIRATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("DocumentUrlExpirationDate")
            .getter(getter(SupplementalDocument::documentUrlExpirationDate)).setter(setter(Builder::documentUrlExpirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentUrlExpirationDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_URL_FIELD,
            DOCUMENT_URL_EXPIRATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String documentUrl;

    private final Instant documentUrlExpirationDate;

    private SupplementalDocument(BuilderImpl builder) {
        this.documentUrl = builder.documentUrl;
        this.documentUrlExpirationDate = builder.documentUrlExpirationDate;
    }

    /**
     * <p>
     * The pre-signed URL to download invoice supplemental document.
     * </p>
     * 
     * @return The pre-signed URL to download invoice supplemental document.
     */
    public final String documentUrl() {
        return documentUrl;
    }

    /**
     * <p>
     * The pre-signed URL expiration date of invoice supplemental document.
     * </p>
     * 
     * @return The pre-signed URL expiration date of invoice supplemental document.
     */
    public final Instant documentUrlExpirationDate() {
        return documentUrlExpirationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentUrl());
        hashCode = 31 * hashCode + Objects.hashCode(documentUrlExpirationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupplementalDocument)) {
            return false;
        }
        SupplementalDocument other = (SupplementalDocument) obj;
        return Objects.equals(documentUrl(), other.documentUrl())
                && Objects.equals(documentUrlExpirationDate(), other.documentUrlExpirationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupplementalDocument").add("DocumentUrl", documentUrl())
                .add("DocumentUrlExpirationDate", documentUrlExpirationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentUrl":
            return Optional.ofNullable(clazz.cast(documentUrl()));
        case "DocumentUrlExpirationDate":
            return Optional.ofNullable(clazz.cast(documentUrlExpirationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DocumentUrl", DOCUMENT_URL_FIELD);
        map.put("DocumentUrlExpirationDate", DOCUMENT_URL_EXPIRATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupplementalDocument, T> g) {
        return obj -> g.apply((SupplementalDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupplementalDocument> {
        /**
         * <p>
         * The pre-signed URL to download invoice supplemental document.
         * </p>
         * 
         * @param documentUrl
         *        The pre-signed URL to download invoice supplemental document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentUrl(String documentUrl);

        /**
         * <p>
         * The pre-signed URL expiration date of invoice supplemental document.
         * </p>
         * 
         * @param documentUrlExpirationDate
         *        The pre-signed URL expiration date of invoice supplemental document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentUrlExpirationDate(Instant documentUrlExpirationDate);
    }

    static final class BuilderImpl implements Builder {
        private String documentUrl;

        private Instant documentUrlExpirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SupplementalDocument model) {
            documentUrl(model.documentUrl);
            documentUrlExpirationDate(model.documentUrlExpirationDate);
        }

        public final String getDocumentUrl() {
            return documentUrl;
        }

        public final void setDocumentUrl(String documentUrl) {
            this.documentUrl = documentUrl;
        }

        @Override
        public final Builder documentUrl(String documentUrl) {
            this.documentUrl = documentUrl;
            return this;
        }

        public final Instant getDocumentUrlExpirationDate() {
            return documentUrlExpirationDate;
        }

        public final void setDocumentUrlExpirationDate(Instant documentUrlExpirationDate) {
            this.documentUrlExpirationDate = documentUrlExpirationDate;
        }

        @Override
        public final Builder documentUrlExpirationDate(Instant documentUrlExpirationDate) {
            this.documentUrlExpirationDate = documentUrlExpirationDate;
            return this;
        }

        @Override
        public SupplementalDocument build() {
            return new SupplementalDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
