/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutProcurementPortalPreferenceRequest extends InvoicingRequest implements
        ToCopyableBuilder<PutProcurementPortalPreferenceRequest.Builder, PutProcurementPortalPreferenceRequest> {
    private static final SdkField<String> PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProcurementPortalPreferenceArn")
            .getter(getter(PutProcurementPortalPreferenceRequest::procurementPortalPreferenceArn))
            .setter(setter(Builder::procurementPortalPreferenceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalPreferenceArn")
                    .build()).build();

    private static final SdkField<ProcurementPortalPreferenceSelector> SELECTOR_FIELD = SdkField
            .<ProcurementPortalPreferenceSelector> builder(MarshallingType.SDK_POJO).memberName("Selector")
            .getter(getter(PutProcurementPortalPreferenceRequest::selector)).setter(setter(Builder::selector))
            .constructor(ProcurementPortalPreferenceSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Selector").build()).build();

    private static final SdkField<String> PROCUREMENT_PORTAL_SHARED_SECRET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProcurementPortalSharedSecret")
            .getter(getter(PutProcurementPortalPreferenceRequest::procurementPortalSharedSecret))
            .setter(setter(Builder::procurementPortalSharedSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalSharedSecret")
                    .build()).build();

    private static final SdkField<String> PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProcurementPortalInstanceEndpoint")
            .getter(getter(PutProcurementPortalPreferenceRequest::procurementPortalInstanceEndpoint))
            .setter(setter(Builder::procurementPortalInstanceEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalInstanceEndpoint")
                    .build()).build();

    private static final SdkField<TestEnvPreferenceInput> TEST_ENV_PREFERENCE_FIELD = SdkField
            .<TestEnvPreferenceInput> builder(MarshallingType.SDK_POJO).memberName("TestEnvPreference")
            .getter(getter(PutProcurementPortalPreferenceRequest::testEnvPreference)).setter(setter(Builder::testEnvPreference))
            .constructor(TestEnvPreferenceInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestEnvPreference").build()).build();

    private static final SdkField<Boolean> EINVOICE_DELIVERY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EinvoiceDeliveryEnabled").getter(getter(PutProcurementPortalPreferenceRequest::einvoiceDeliveryEnabled))
            .setter(setter(Builder::einvoiceDeliveryEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryEnabled").build())
            .build();

    private static final SdkField<EinvoiceDeliveryPreference> EINVOICE_DELIVERY_PREFERENCE_FIELD = SdkField
            .<EinvoiceDeliveryPreference> builder(MarshallingType.SDK_POJO)
            .memberName("EinvoiceDeliveryPreference")
            .getter(getter(PutProcurementPortalPreferenceRequest::einvoiceDeliveryPreference))
            .setter(setter(Builder::einvoiceDeliveryPreference))
            .constructor(EinvoiceDeliveryPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryPreference").build())
            .build();

    private static final SdkField<Boolean> PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PurchaseOrderRetrievalEnabled")
            .getter(getter(PutProcurementPortalPreferenceRequest::purchaseOrderRetrievalEnabled))
            .setter(setter(Builder::purchaseOrderRetrievalEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderRetrievalEnabled")
                    .build()).build();

    private static final SdkField<List<Contact>> CONTACTS_FIELD = SdkField
            .<List<Contact>> builder(MarshallingType.LIST)
            .memberName("Contacts")
            .getter(getter(PutProcurementPortalPreferenceRequest::contacts))
            .setter(setter(Builder::contacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Contact> builder(MarshallingType.SDK_POJO)
                                            .constructor(Contact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD, SELECTOR_FIELD, PROCUREMENT_PORTAL_SHARED_SECRET_FIELD,
            PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD, TEST_ENV_PREFERENCE_FIELD, EINVOICE_DELIVERY_ENABLED_FIELD,
            EINVOICE_DELIVERY_PREFERENCE_FIELD, PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD, CONTACTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String procurementPortalPreferenceArn;

    private final ProcurementPortalPreferenceSelector selector;

    private final String procurementPortalSharedSecret;

    private final String procurementPortalInstanceEndpoint;

    private final TestEnvPreferenceInput testEnvPreference;

    private final Boolean einvoiceDeliveryEnabled;

    private final EinvoiceDeliveryPreference einvoiceDeliveryPreference;

    private final Boolean purchaseOrderRetrievalEnabled;

    private final List<Contact> contacts;

    private PutProcurementPortalPreferenceRequest(BuilderImpl builder) {
        super(builder);
        this.procurementPortalPreferenceArn = builder.procurementPortalPreferenceArn;
        this.selector = builder.selector;
        this.procurementPortalSharedSecret = builder.procurementPortalSharedSecret;
        this.procurementPortalInstanceEndpoint = builder.procurementPortalInstanceEndpoint;
        this.testEnvPreference = builder.testEnvPreference;
        this.einvoiceDeliveryEnabled = builder.einvoiceDeliveryEnabled;
        this.einvoiceDeliveryPreference = builder.einvoiceDeliveryPreference;
        this.purchaseOrderRetrievalEnabled = builder.purchaseOrderRetrievalEnabled;
        this.contacts = builder.contacts;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the procurement portal preference to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the procurement portal preference to update.
     */
    public final String procurementPortalPreferenceArn() {
        return procurementPortalPreferenceArn;
    }

    /**
     * Returns the value of the Selector property for this object.
     * 
     * @return The value of the Selector property for this object.
     */
    public final ProcurementPortalPreferenceSelector selector() {
        return selector;
    }

    /**
     * <p>
     * The updated shared secret or authentication credential for the procurement portal. This value must be encrypted
     * at rest.
     * </p>
     * 
     * @return The updated shared secret or authentication credential for the procurement portal. This value must be
     *         encrypted at rest.
     */
    public final String procurementPortalSharedSecret() {
        return procurementPortalSharedSecret;
    }

    /**
     * <p>
     * The updated endpoint URL where e-invoices will be delivered to the procurement portal. Must be a valid HTTPS URL.
     * </p>
     * 
     * @return The updated endpoint URL where e-invoices will be delivered to the procurement portal. Must be a valid
     *         HTTPS URL.
     */
    public final String procurementPortalInstanceEndpoint() {
        return procurementPortalInstanceEndpoint;
    }

    /**
     * <p>
     * Updated configuration settings for the test environment of the procurement portal.
     * </p>
     * 
     * @return Updated configuration settings for the test environment of the procurement portal.
     */
    public final TestEnvPreferenceInput testEnvPreference() {
        return testEnvPreference;
    }

    /**
     * <p>
     * Updated flag indicating whether e-invoice delivery is enabled for this procurement portal preference.
     * </p>
     * 
     * @return Updated flag indicating whether e-invoice delivery is enabled for this procurement portal preference.
     */
    public final Boolean einvoiceDeliveryEnabled() {
        return einvoiceDeliveryEnabled;
    }

    /**
     * <p>
     * Updated e-invoice delivery configuration including document types, attachment types, and customization settings
     * for the portal.
     * </p>
     * 
     * @return Updated e-invoice delivery configuration including document types, attachment types, and customization
     *         settings for the portal.
     */
    public final EinvoiceDeliveryPreference einvoiceDeliveryPreference() {
        return einvoiceDeliveryPreference;
    }

    /**
     * <p>
     * Updated flag indicating whether purchase order retrieval is enabled for this procurement portal preference.
     * </p>
     * 
     * @return Updated flag indicating whether purchase order retrieval is enabled for this procurement portal
     *         preference.
     */
    public final Boolean purchaseOrderRetrievalEnabled() {
        return purchaseOrderRetrievalEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the Contacts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContacts() {
        return contacts != null && !(contacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Updated list of contact information for portal administrators and technical contacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContacts} method.
     * </p>
     * 
     * @return Updated list of contact information for portal administrators and technical contacts.
     */
    public final List<Contact> contacts() {
        return contacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(procurementPortalPreferenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(selector());
        hashCode = 31 * hashCode + Objects.hashCode(procurementPortalSharedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(procurementPortalInstanceEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(testEnvPreference());
        hashCode = 31 * hashCode + Objects.hashCode(einvoiceDeliveryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(einvoiceDeliveryPreference());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseOrderRetrievalEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasContacts() ? contacts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProcurementPortalPreferenceRequest)) {
            return false;
        }
        PutProcurementPortalPreferenceRequest other = (PutProcurementPortalPreferenceRequest) obj;
        return Objects.equals(procurementPortalPreferenceArn(), other.procurementPortalPreferenceArn())
                && Objects.equals(selector(), other.selector())
                && Objects.equals(procurementPortalSharedSecret(), other.procurementPortalSharedSecret())
                && Objects.equals(procurementPortalInstanceEndpoint(), other.procurementPortalInstanceEndpoint())
                && Objects.equals(testEnvPreference(), other.testEnvPreference())
                && Objects.equals(einvoiceDeliveryEnabled(), other.einvoiceDeliveryEnabled())
                && Objects.equals(einvoiceDeliveryPreference(), other.einvoiceDeliveryPreference())
                && Objects.equals(purchaseOrderRetrievalEnabled(), other.purchaseOrderRetrievalEnabled())
                && hasContacts() == other.hasContacts() && Objects.equals(contacts(), other.contacts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PutProcurementPortalPreferenceRequest")
                .add("ProcurementPortalPreferenceArn", procurementPortalPreferenceArn())
                .add("Selector", selector())
                .add("ProcurementPortalSharedSecret",
                        procurementPortalSharedSecret() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProcurementPortalInstanceEndpoint", procurementPortalInstanceEndpoint())
                .add("TestEnvPreference", testEnvPreference()).add("EinvoiceDeliveryEnabled", einvoiceDeliveryEnabled())
                .add("EinvoiceDeliveryPreference", einvoiceDeliveryPreference())
                .add("PurchaseOrderRetrievalEnabled", purchaseOrderRetrievalEnabled())
                .add("Contacts", contacts() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcurementPortalPreferenceArn":
            return Optional.ofNullable(clazz.cast(procurementPortalPreferenceArn()));
        case "Selector":
            return Optional.ofNullable(clazz.cast(selector()));
        case "ProcurementPortalSharedSecret":
            return Optional.ofNullable(clazz.cast(procurementPortalSharedSecret()));
        case "ProcurementPortalInstanceEndpoint":
            return Optional.ofNullable(clazz.cast(procurementPortalInstanceEndpoint()));
        case "TestEnvPreference":
            return Optional.ofNullable(clazz.cast(testEnvPreference()));
        case "EinvoiceDeliveryEnabled":
            return Optional.ofNullable(clazz.cast(einvoiceDeliveryEnabled()));
        case "EinvoiceDeliveryPreference":
            return Optional.ofNullable(clazz.cast(einvoiceDeliveryPreference()));
        case "PurchaseOrderRetrievalEnabled":
            return Optional.ofNullable(clazz.cast(purchaseOrderRetrievalEnabled()));
        case "Contacts":
            return Optional.ofNullable(clazz.cast(contacts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProcurementPortalPreferenceArn", PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD);
        map.put("Selector", SELECTOR_FIELD);
        map.put("ProcurementPortalSharedSecret", PROCUREMENT_PORTAL_SHARED_SECRET_FIELD);
        map.put("ProcurementPortalInstanceEndpoint", PROCUREMENT_PORTAL_INSTANCE_ENDPOINT_FIELD);
        map.put("TestEnvPreference", TEST_ENV_PREFERENCE_FIELD);
        map.put("EinvoiceDeliveryEnabled", EINVOICE_DELIVERY_ENABLED_FIELD);
        map.put("EinvoiceDeliveryPreference", EINVOICE_DELIVERY_PREFERENCE_FIELD);
        map.put("PurchaseOrderRetrievalEnabled", PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD);
        map.put("Contacts", CONTACTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutProcurementPortalPreferenceRequest, T> g) {
        return obj -> g.apply((PutProcurementPortalPreferenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends InvoicingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutProcurementPortalPreferenceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the procurement portal preference to update.
         * </p>
         * 
         * @param procurementPortalPreferenceArn
         *        The Amazon Resource Name (ARN) of the procurement portal preference to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder procurementPortalPreferenceArn(String procurementPortalPreferenceArn);

        /**
         * Sets the value of the Selector property for this object.
         *
         * @param selector
         *        The new value for the Selector property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selector(ProcurementPortalPreferenceSelector selector);

        /**
         * Sets the value of the Selector property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link ProcurementPortalPreferenceSelector.Builder} avoiding the need to create one manually via
         * {@link ProcurementPortalPreferenceSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcurementPortalPreferenceSelector.Builder#build()} is called
         * immediately and its result is passed to {@link #selector(ProcurementPortalPreferenceSelector)}.
         * 
         * @param selector
         *        a consumer that will call methods on {@link ProcurementPortalPreferenceSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selector(ProcurementPortalPreferenceSelector)
         */
        default Builder selector(Consumer<ProcurementPortalPreferenceSelector.Builder> selector) {
            return selector(ProcurementPortalPreferenceSelector.builder().applyMutation(selector).build());
        }

        /**
         * <p>
         * The updated shared secret or authentication credential for the procurement portal. This value must be
         * encrypted at rest.
         * </p>
         * 
         * @param procurementPortalSharedSecret
         *        The updated shared secret or authentication credential for the procurement portal. This value must be
         *        encrypted at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder procurementPortalSharedSecret(String procurementPortalSharedSecret);

        /**
         * <p>
         * The updated endpoint URL where e-invoices will be delivered to the procurement portal. Must be a valid HTTPS
         * URL.
         * </p>
         * 
         * @param procurementPortalInstanceEndpoint
         *        The updated endpoint URL where e-invoices will be delivered to the procurement portal. Must be a valid
         *        HTTPS URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder procurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint);

        /**
         * <p>
         * Updated configuration settings for the test environment of the procurement portal.
         * </p>
         * 
         * @param testEnvPreference
         *        Updated configuration settings for the test environment of the procurement portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testEnvPreference(TestEnvPreferenceInput testEnvPreference);

        /**
         * <p>
         * Updated configuration settings for the test environment of the procurement portal.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestEnvPreferenceInput.Builder} avoiding
         * the need to create one manually via {@link TestEnvPreferenceInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestEnvPreferenceInput.Builder#build()} is called immediately and
         * its result is passed to {@link #testEnvPreference(TestEnvPreferenceInput)}.
         * 
         * @param testEnvPreference
         *        a consumer that will call methods on {@link TestEnvPreferenceInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testEnvPreference(TestEnvPreferenceInput)
         */
        default Builder testEnvPreference(Consumer<TestEnvPreferenceInput.Builder> testEnvPreference) {
            return testEnvPreference(TestEnvPreferenceInput.builder().applyMutation(testEnvPreference).build());
        }

        /**
         * <p>
         * Updated flag indicating whether e-invoice delivery is enabled for this procurement portal preference.
         * </p>
         * 
         * @param einvoiceDeliveryEnabled
         *        Updated flag indicating whether e-invoice delivery is enabled for this procurement portal preference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled);

        /**
         * <p>
         * Updated e-invoice delivery configuration including document types, attachment types, and customization
         * settings for the portal.
         * </p>
         * 
         * @param einvoiceDeliveryPreference
         *        Updated e-invoice delivery configuration including document types, attachment types, and customization
         *        settings for the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryPreference(EinvoiceDeliveryPreference einvoiceDeliveryPreference);

        /**
         * <p>
         * Updated e-invoice delivery configuration including document types, attachment types, and customization
         * settings for the portal.
         * </p>
         * This is a convenience method that creates an instance of the {@link EinvoiceDeliveryPreference.Builder}
         * avoiding the need to create one manually via {@link EinvoiceDeliveryPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EinvoiceDeliveryPreference.Builder#build()} is called immediately
         * and its result is passed to {@link #einvoiceDeliveryPreference(EinvoiceDeliveryPreference)}.
         * 
         * @param einvoiceDeliveryPreference
         *        a consumer that will call methods on {@link EinvoiceDeliveryPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #einvoiceDeliveryPreference(EinvoiceDeliveryPreference)
         */
        default Builder einvoiceDeliveryPreference(Consumer<EinvoiceDeliveryPreference.Builder> einvoiceDeliveryPreference) {
            return einvoiceDeliveryPreference(EinvoiceDeliveryPreference.builder().applyMutation(einvoiceDeliveryPreference)
                    .build());
        }

        /**
         * <p>
         * Updated flag indicating whether purchase order retrieval is enabled for this procurement portal preference.
         * </p>
         * 
         * @param purchaseOrderRetrievalEnabled
         *        Updated flag indicating whether purchase order retrieval is enabled for this procurement portal
         *        preference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled);

        /**
         * <p>
         * Updated list of contact information for portal administrators and technical contacts.
         * </p>
         * 
         * @param contacts
         *        Updated list of contact information for portal administrators and technical contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(Collection<Contact> contacts);

        /**
         * <p>
         * Updated list of contact information for portal administrators and technical contacts.
         * </p>
         * 
         * @param contacts
         *        Updated list of contact information for portal administrators and technical contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(Contact... contacts);

        /**
         * <p>
         * Updated list of contact information for portal administrators and technical contacts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.invoicing.model.Contact.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.invoicing.model.Contact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.invoicing.model.Contact.Builder#build()} is called immediately and its
         * result is passed to {@link #contacts(List<Contact>)}.
         * 
         * @param contacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.invoicing.model.Contact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contacts(java.util.Collection<Contact>)
         */
        Builder contacts(Consumer<Contact.Builder>... contacts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InvoicingRequest.BuilderImpl implements Builder {
        private String procurementPortalPreferenceArn;

        private ProcurementPortalPreferenceSelector selector;

        private String procurementPortalSharedSecret;

        private String procurementPortalInstanceEndpoint;

        private TestEnvPreferenceInput testEnvPreference;

        private Boolean einvoiceDeliveryEnabled;

        private EinvoiceDeliveryPreference einvoiceDeliveryPreference;

        private Boolean purchaseOrderRetrievalEnabled;

        private List<Contact> contacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutProcurementPortalPreferenceRequest model) {
            super(model);
            procurementPortalPreferenceArn(model.procurementPortalPreferenceArn);
            selector(model.selector);
            procurementPortalSharedSecret(model.procurementPortalSharedSecret);
            procurementPortalInstanceEndpoint(model.procurementPortalInstanceEndpoint);
            testEnvPreference(model.testEnvPreference);
            einvoiceDeliveryEnabled(model.einvoiceDeliveryEnabled);
            einvoiceDeliveryPreference(model.einvoiceDeliveryPreference);
            purchaseOrderRetrievalEnabled(model.purchaseOrderRetrievalEnabled);
            contacts(model.contacts);
        }

        public final String getProcurementPortalPreferenceArn() {
            return procurementPortalPreferenceArn;
        }

        public final void setProcurementPortalPreferenceArn(String procurementPortalPreferenceArn) {
            this.procurementPortalPreferenceArn = procurementPortalPreferenceArn;
        }

        @Override
        public final Builder procurementPortalPreferenceArn(String procurementPortalPreferenceArn) {
            this.procurementPortalPreferenceArn = procurementPortalPreferenceArn;
            return this;
        }

        public final ProcurementPortalPreferenceSelector.Builder getSelector() {
            return selector != null ? selector.toBuilder() : null;
        }

        public final void setSelector(ProcurementPortalPreferenceSelector.BuilderImpl selector) {
            this.selector = selector != null ? selector.build() : null;
        }

        @Override
        public final Builder selector(ProcurementPortalPreferenceSelector selector) {
            this.selector = selector;
            return this;
        }

        public final String getProcurementPortalSharedSecret() {
            return procurementPortalSharedSecret;
        }

        public final void setProcurementPortalSharedSecret(String procurementPortalSharedSecret) {
            this.procurementPortalSharedSecret = procurementPortalSharedSecret;
        }

        @Override
        public final Builder procurementPortalSharedSecret(String procurementPortalSharedSecret) {
            this.procurementPortalSharedSecret = procurementPortalSharedSecret;
            return this;
        }

        public final String getProcurementPortalInstanceEndpoint() {
            return procurementPortalInstanceEndpoint;
        }

        public final void setProcurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint) {
            this.procurementPortalInstanceEndpoint = procurementPortalInstanceEndpoint;
        }

        @Override
        public final Builder procurementPortalInstanceEndpoint(String procurementPortalInstanceEndpoint) {
            this.procurementPortalInstanceEndpoint = procurementPortalInstanceEndpoint;
            return this;
        }

        public final TestEnvPreferenceInput.Builder getTestEnvPreference() {
            return testEnvPreference != null ? testEnvPreference.toBuilder() : null;
        }

        public final void setTestEnvPreference(TestEnvPreferenceInput.BuilderImpl testEnvPreference) {
            this.testEnvPreference = testEnvPreference != null ? testEnvPreference.build() : null;
        }

        @Override
        public final Builder testEnvPreference(TestEnvPreferenceInput testEnvPreference) {
            this.testEnvPreference = testEnvPreference;
            return this;
        }

        public final Boolean getEinvoiceDeliveryEnabled() {
            return einvoiceDeliveryEnabled;
        }

        public final void setEinvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled) {
            this.einvoiceDeliveryEnabled = einvoiceDeliveryEnabled;
        }

        @Override
        public final Builder einvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled) {
            this.einvoiceDeliveryEnabled = einvoiceDeliveryEnabled;
            return this;
        }

        public final EinvoiceDeliveryPreference.Builder getEinvoiceDeliveryPreference() {
            return einvoiceDeliveryPreference != null ? einvoiceDeliveryPreference.toBuilder() : null;
        }

        public final void setEinvoiceDeliveryPreference(EinvoiceDeliveryPreference.BuilderImpl einvoiceDeliveryPreference) {
            this.einvoiceDeliveryPreference = einvoiceDeliveryPreference != null ? einvoiceDeliveryPreference.build() : null;
        }

        @Override
        public final Builder einvoiceDeliveryPreference(EinvoiceDeliveryPreference einvoiceDeliveryPreference) {
            this.einvoiceDeliveryPreference = einvoiceDeliveryPreference;
            return this;
        }

        public final Boolean getPurchaseOrderRetrievalEnabled() {
            return purchaseOrderRetrievalEnabled;
        }

        public final void setPurchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled) {
            this.purchaseOrderRetrievalEnabled = purchaseOrderRetrievalEnabled;
        }

        @Override
        public final Builder purchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled) {
            this.purchaseOrderRetrievalEnabled = purchaseOrderRetrievalEnabled;
            return this;
        }

        public final List<Contact.Builder> getContacts() {
            List<Contact.Builder> result = ContactsCopier.copyToBuilder(this.contacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContacts(Collection<Contact.BuilderImpl> contacts) {
            this.contacts = ContactsCopier.copyFromBuilder(contacts);
        }

        @Override
        public final Builder contacts(Collection<Contact> contacts) {
            this.contacts = ContactsCopier.copy(contacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Contact... contacts) {
            contacts(Arrays.asList(contacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Consumer<Contact.Builder>... contacts) {
            contacts(Stream.of(contacts).map(c -> Contact.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutProcurementPortalPreferenceRequest build() {
            return new PutProcurementPortalPreferenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
