/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the source configuration for retrieving purchase order data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseOrderDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<PurchaseOrderDataSource.Builder, PurchaseOrderDataSource> {
    private static final SdkField<String> EINVOICE_DELIVERY_DOCUMENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EinvoiceDeliveryDocumentType")
            .getter(getter(PurchaseOrderDataSource::einvoiceDeliveryDocumentTypeAsString))
            .setter(setter(Builder::einvoiceDeliveryDocumentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryDocumentType")
                    .build()).build();

    private static final SdkField<String> PURCHASE_ORDER_DATA_SOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PurchaseOrderDataSourceType")
            .getter(getter(PurchaseOrderDataSource::purchaseOrderDataSourceTypeAsString))
            .setter(setter(Builder::purchaseOrderDataSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderDataSourceType")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EINVOICE_DELIVERY_DOCUMENT_TYPE_FIELD, PURCHASE_ORDER_DATA_SOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String einvoiceDeliveryDocumentType;

    private final String purchaseOrderDataSourceType;

    private PurchaseOrderDataSource(BuilderImpl builder) {
        this.einvoiceDeliveryDocumentType = builder.einvoiceDeliveryDocumentType;
        this.purchaseOrderDataSourceType = builder.purchaseOrderDataSourceType;
    }

    /**
     * <p>
     * The type of e-invoice document that requires purchase order data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #einvoiceDeliveryDocumentType} will return {@link EinvoiceDeliveryDocumentType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #einvoiceDeliveryDocumentTypeAsString}.
     * </p>
     * 
     * @return The type of e-invoice document that requires purchase order data.
     * @see EinvoiceDeliveryDocumentType
     */
    public final EinvoiceDeliveryDocumentType einvoiceDeliveryDocumentType() {
        return EinvoiceDeliveryDocumentType.fromValue(einvoiceDeliveryDocumentType);
    }

    /**
     * <p>
     * The type of e-invoice document that requires purchase order data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #einvoiceDeliveryDocumentType} will return {@link EinvoiceDeliveryDocumentType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #einvoiceDeliveryDocumentTypeAsString}.
     * </p>
     * 
     * @return The type of e-invoice document that requires purchase order data.
     * @see EinvoiceDeliveryDocumentType
     */
    public final String einvoiceDeliveryDocumentTypeAsString() {
        return einvoiceDeliveryDocumentType;
    }

    /**
     * <p>
     * The type of source for purchase order data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #purchaseOrderDataSourceType} will return {@link PurchaseOrderDataSourceType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #purchaseOrderDataSourceTypeAsString}.
     * </p>
     * 
     * @return The type of source for purchase order data.
     * @see PurchaseOrderDataSourceType
     */
    public final PurchaseOrderDataSourceType purchaseOrderDataSourceType() {
        return PurchaseOrderDataSourceType.fromValue(purchaseOrderDataSourceType);
    }

    /**
     * <p>
     * The type of source for purchase order data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #purchaseOrderDataSourceType} will return {@link PurchaseOrderDataSourceType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #purchaseOrderDataSourceTypeAsString}.
     * </p>
     * 
     * @return The type of source for purchase order data.
     * @see PurchaseOrderDataSourceType
     */
    public final String purchaseOrderDataSourceTypeAsString() {
        return purchaseOrderDataSourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(einvoiceDeliveryDocumentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseOrderDataSourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseOrderDataSource)) {
            return false;
        }
        PurchaseOrderDataSource other = (PurchaseOrderDataSource) obj;
        return Objects.equals(einvoiceDeliveryDocumentTypeAsString(), other.einvoiceDeliveryDocumentTypeAsString())
                && Objects.equals(purchaseOrderDataSourceTypeAsString(), other.purchaseOrderDataSourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PurchaseOrderDataSource")
                .add("EinvoiceDeliveryDocumentType", einvoiceDeliveryDocumentTypeAsString())
                .add("PurchaseOrderDataSourceType", purchaseOrderDataSourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EinvoiceDeliveryDocumentType":
            return Optional.ofNullable(clazz.cast(einvoiceDeliveryDocumentTypeAsString()));
        case "PurchaseOrderDataSourceType":
            return Optional.ofNullable(clazz.cast(purchaseOrderDataSourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EinvoiceDeliveryDocumentType", EINVOICE_DELIVERY_DOCUMENT_TYPE_FIELD);
        map.put("PurchaseOrderDataSourceType", PURCHASE_ORDER_DATA_SOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PurchaseOrderDataSource, T> g) {
        return obj -> g.apply((PurchaseOrderDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PurchaseOrderDataSource> {
        /**
         * <p>
         * The type of e-invoice document that requires purchase order data.
         * </p>
         * 
         * @param einvoiceDeliveryDocumentType
         *        The type of e-invoice document that requires purchase order data.
         * @see EinvoiceDeliveryDocumentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EinvoiceDeliveryDocumentType
         */
        Builder einvoiceDeliveryDocumentType(String einvoiceDeliveryDocumentType);

        /**
         * <p>
         * The type of e-invoice document that requires purchase order data.
         * </p>
         * 
         * @param einvoiceDeliveryDocumentType
         *        The type of e-invoice document that requires purchase order data.
         * @see EinvoiceDeliveryDocumentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EinvoiceDeliveryDocumentType
         */
        Builder einvoiceDeliveryDocumentType(EinvoiceDeliveryDocumentType einvoiceDeliveryDocumentType);

        /**
         * <p>
         * The type of source for purchase order data.
         * </p>
         * 
         * @param purchaseOrderDataSourceType
         *        The type of source for purchase order data.
         * @see PurchaseOrderDataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PurchaseOrderDataSourceType
         */
        Builder purchaseOrderDataSourceType(String purchaseOrderDataSourceType);

        /**
         * <p>
         * The type of source for purchase order data.
         * </p>
         * 
         * @param purchaseOrderDataSourceType
         *        The type of source for purchase order data.
         * @see PurchaseOrderDataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PurchaseOrderDataSourceType
         */
        Builder purchaseOrderDataSourceType(PurchaseOrderDataSourceType purchaseOrderDataSourceType);
    }

    static final class BuilderImpl implements Builder {
        private String einvoiceDeliveryDocumentType;

        private String purchaseOrderDataSourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseOrderDataSource model) {
            einvoiceDeliveryDocumentType(model.einvoiceDeliveryDocumentType);
            purchaseOrderDataSourceType(model.purchaseOrderDataSourceType);
        }

        public final String getEinvoiceDeliveryDocumentType() {
            return einvoiceDeliveryDocumentType;
        }

        public final void setEinvoiceDeliveryDocumentType(String einvoiceDeliveryDocumentType) {
            this.einvoiceDeliveryDocumentType = einvoiceDeliveryDocumentType;
        }

        @Override
        public final Builder einvoiceDeliveryDocumentType(String einvoiceDeliveryDocumentType) {
            this.einvoiceDeliveryDocumentType = einvoiceDeliveryDocumentType;
            return this;
        }

        @Override
        public final Builder einvoiceDeliveryDocumentType(EinvoiceDeliveryDocumentType einvoiceDeliveryDocumentType) {
            this.einvoiceDeliveryDocumentType(einvoiceDeliveryDocumentType == null ? null : einvoiceDeliveryDocumentType
                    .toString());
            return this;
        }

        public final String getPurchaseOrderDataSourceType() {
            return purchaseOrderDataSourceType;
        }

        public final void setPurchaseOrderDataSourceType(String purchaseOrderDataSourceType) {
            this.purchaseOrderDataSourceType = purchaseOrderDataSourceType;
        }

        @Override
        public final Builder purchaseOrderDataSourceType(String purchaseOrderDataSourceType) {
            this.purchaseOrderDataSourceType = purchaseOrderDataSourceType;
            return this;
        }

        @Override
        public final Builder purchaseOrderDataSourceType(PurchaseOrderDataSourceType purchaseOrderDataSourceType) {
            this.purchaseOrderDataSourceType(purchaseOrderDataSourceType == null ? null : purchaseOrderDataSourceType.toString());
            return this;
        }

        @Override
        public PurchaseOrderDataSource build() {
            return new PurchaseOrderDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
