/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of a procurement portal preference, including key identifiers and status information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcurementPortalPreferenceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProcurementPortalPreferenceSummary.Builder, ProcurementPortalPreferenceSummary> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(ProcurementPortalPreferenceSummary::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProcurementPortalPreferenceArn")
            .getter(getter(ProcurementPortalPreferenceSummary::procurementPortalPreferenceArn))
            .setter(setter(Builder::procurementPortalPreferenceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalPreferenceArn")
                    .build()).build();

    private static final SdkField<String> PROCUREMENT_PORTAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProcurementPortalName")
            .getter(getter(ProcurementPortalPreferenceSummary::procurementPortalNameAsString))
            .setter(setter(Builder::procurementPortalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalName").build())
            .build();

    private static final SdkField<String> BUYER_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BuyerDomain").getter(getter(ProcurementPortalPreferenceSummary::buyerDomainAsString))
            .setter(setter(Builder::buyerDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerDomain").build()).build();

    private static final SdkField<String> BUYER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BuyerIdentifier").getter(getter(ProcurementPortalPreferenceSummary::buyerIdentifier))
            .setter(setter(Builder::buyerIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuyerIdentifier").build()).build();

    private static final SdkField<String> SUPPLIER_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupplierDomain").getter(getter(ProcurementPortalPreferenceSummary::supplierDomainAsString))
            .setter(setter(Builder::supplierDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplierDomain").build()).build();

    private static final SdkField<String> SUPPLIER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupplierIdentifier").getter(getter(ProcurementPortalPreferenceSummary::supplierIdentifier))
            .setter(setter(Builder::supplierIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplierIdentifier").build())
            .build();

    private static final SdkField<ProcurementPortalPreferenceSelector> SELECTOR_FIELD = SdkField
            .<ProcurementPortalPreferenceSelector> builder(MarshallingType.SDK_POJO).memberName("Selector")
            .getter(getter(ProcurementPortalPreferenceSummary::selector)).setter(setter(Builder::selector))
            .constructor(ProcurementPortalPreferenceSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Selector").build()).build();

    private static final SdkField<Boolean> EINVOICE_DELIVERY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EinvoiceDeliveryEnabled").getter(getter(ProcurementPortalPreferenceSummary::einvoiceDeliveryEnabled))
            .setter(setter(Builder::einvoiceDeliveryEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryEnabled").build())
            .build();

    private static final SdkField<Boolean> PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PurchaseOrderRetrievalEnabled")
            .getter(getter(ProcurementPortalPreferenceSummary::purchaseOrderRetrievalEnabled))
            .setter(setter(Builder::purchaseOrderRetrievalEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderRetrievalEnabled")
                    .build()).build();

    private static final SdkField<String> EINVOICE_DELIVERY_PREFERENCE_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EinvoiceDeliveryPreferenceStatus")
            .getter(getter(ProcurementPortalPreferenceSummary::einvoiceDeliveryPreferenceStatusAsString))
            .setter(setter(Builder::einvoiceDeliveryPreferenceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryPreferenceStatus")
                    .build()).build();

    private static final SdkField<String> EINVOICE_DELIVERY_PREFERENCE_STATUS_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EinvoiceDeliveryPreferenceStatusReason")
            .getter(getter(ProcurementPortalPreferenceSummary::einvoiceDeliveryPreferenceStatusReason))
            .setter(setter(Builder::einvoiceDeliveryPreferenceStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EinvoiceDeliveryPreferenceStatusReason").build()).build();

    private static final SdkField<String> PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PurchaseOrderRetrievalPreferenceStatus")
            .getter(getter(ProcurementPortalPreferenceSummary::purchaseOrderRetrievalPreferenceStatusAsString))
            .setter(setter(Builder::purchaseOrderRetrievalPreferenceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PurchaseOrderRetrievalPreferenceStatus").build()).build();

    private static final SdkField<String> PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PurchaseOrderRetrievalPreferenceStatusReason")
            .getter(getter(ProcurementPortalPreferenceSummary::purchaseOrderRetrievalPreferenceStatusReason))
            .setter(setter(Builder::purchaseOrderRetrievalPreferenceStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PurchaseOrderRetrievalPreferenceStatusReason").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Version")
            .getter(getter(ProcurementPortalPreferenceSummary::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(ProcurementPortalPreferenceSummary::createDate))
            .setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateDate").getter(getter(ProcurementPortalPreferenceSummary::lastUpdateDate))
            .setter(setter(Builder::lastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD, PROCUREMENT_PORTAL_NAME_FIELD, BUYER_DOMAIN_FIELD, BUYER_IDENTIFIER_FIELD,
            SUPPLIER_DOMAIN_FIELD, SUPPLIER_IDENTIFIER_FIELD, SELECTOR_FIELD, EINVOICE_DELIVERY_ENABLED_FIELD,
            PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD, EINVOICE_DELIVERY_PREFERENCE_STATUS_FIELD,
            EINVOICE_DELIVERY_PREFERENCE_STATUS_REASON_FIELD, PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_FIELD,
            PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_REASON_FIELD, VERSION_FIELD, CREATE_DATE_FIELD, LAST_UPDATE_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final String procurementPortalPreferenceArn;

    private final String procurementPortalName;

    private final String buyerDomain;

    private final String buyerIdentifier;

    private final String supplierDomain;

    private final String supplierIdentifier;

    private final ProcurementPortalPreferenceSelector selector;

    private final Boolean einvoiceDeliveryEnabled;

    private final Boolean purchaseOrderRetrievalEnabled;

    private final String einvoiceDeliveryPreferenceStatus;

    private final String einvoiceDeliveryPreferenceStatusReason;

    private final String purchaseOrderRetrievalPreferenceStatus;

    private final String purchaseOrderRetrievalPreferenceStatusReason;

    private final Long version;

    private final Instant createDate;

    private final Instant lastUpdateDate;

    private ProcurementPortalPreferenceSummary(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.procurementPortalPreferenceArn = builder.procurementPortalPreferenceArn;
        this.procurementPortalName = builder.procurementPortalName;
        this.buyerDomain = builder.buyerDomain;
        this.buyerIdentifier = builder.buyerIdentifier;
        this.supplierDomain = builder.supplierDomain;
        this.supplierIdentifier = builder.supplierIdentifier;
        this.selector = builder.selector;
        this.einvoiceDeliveryEnabled = builder.einvoiceDeliveryEnabled;
        this.purchaseOrderRetrievalEnabled = builder.purchaseOrderRetrievalEnabled;
        this.einvoiceDeliveryPreferenceStatus = builder.einvoiceDeliveryPreferenceStatus;
        this.einvoiceDeliveryPreferenceStatusReason = builder.einvoiceDeliveryPreferenceStatusReason;
        this.purchaseOrderRetrievalPreferenceStatus = builder.purchaseOrderRetrievalPreferenceStatus;
        this.purchaseOrderRetrievalPreferenceStatusReason = builder.purchaseOrderRetrievalPreferenceStatusReason;
        this.version = builder.version;
        this.createDate = builder.createDate;
        this.lastUpdateDate = builder.lastUpdateDate;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with this procurement portal preference summary.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with this procurement portal preference summary.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the procurement portal preference.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the procurement portal preference.
     */
    public final String procurementPortalPreferenceArn() {
        return procurementPortalPreferenceArn;
    }

    /**
     * <p>
     * The name of the procurement portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #procurementPortalName} will return {@link ProcurementPortalName#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #procurementPortalNameAsString}.
     * </p>
     * 
     * @return The name of the procurement portal.
     * @see ProcurementPortalName
     */
    public final ProcurementPortalName procurementPortalName() {
        return ProcurementPortalName.fromValue(procurementPortalName);
    }

    /**
     * <p>
     * The name of the procurement portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #procurementPortalName} will return {@link ProcurementPortalName#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #procurementPortalNameAsString}.
     * </p>
     * 
     * @return The name of the procurement portal.
     * @see ProcurementPortalName
     */
    public final String procurementPortalNameAsString() {
        return procurementPortalName;
    }

    /**
     * <p>
     * The domain identifier for the buyer in the procurement portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buyerDomain} will
     * return {@link BuyerDomain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #buyerDomainAsString}.
     * </p>
     * 
     * @return The domain identifier for the buyer in the procurement portal.
     * @see BuyerDomain
     */
    public final BuyerDomain buyerDomain() {
        return BuyerDomain.fromValue(buyerDomain);
    }

    /**
     * <p>
     * The domain identifier for the buyer in the procurement portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buyerDomain} will
     * return {@link BuyerDomain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #buyerDomainAsString}.
     * </p>
     * 
     * @return The domain identifier for the buyer in the procurement portal.
     * @see BuyerDomain
     */
    public final String buyerDomainAsString() {
        return buyerDomain;
    }

    /**
     * <p>
     * The unique identifier for the buyer in the procurement portal.
     * </p>
     * 
     * @return The unique identifier for the buyer in the procurement portal.
     */
    public final String buyerIdentifier() {
        return buyerIdentifier;
    }

    /**
     * <p>
     * The domain identifier for the supplier in the procurement portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #supplierDomain}
     * will return {@link SupplierDomain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #supplierDomainAsString}.
     * </p>
     * 
     * @return The domain identifier for the supplier in the procurement portal.
     * @see SupplierDomain
     */
    public final SupplierDomain supplierDomain() {
        return SupplierDomain.fromValue(supplierDomain);
    }

    /**
     * <p>
     * The domain identifier for the supplier in the procurement portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #supplierDomain}
     * will return {@link SupplierDomain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #supplierDomainAsString}.
     * </p>
     * 
     * @return The domain identifier for the supplier in the procurement portal.
     * @see SupplierDomain
     */
    public final String supplierDomainAsString() {
        return supplierDomain;
    }

    /**
     * <p>
     * The unique identifier for the supplier in the procurement portal.
     * </p>
     * 
     * @return The unique identifier for the supplier in the procurement portal.
     */
    public final String supplierIdentifier() {
        return supplierIdentifier;
    }

    /**
     * Returns the value of the Selector property for this object.
     * 
     * @return The value of the Selector property for this object.
     */
    public final ProcurementPortalPreferenceSelector selector() {
        return selector;
    }

    /**
     * <p>
     * Indicates whether e-invoice delivery is enabled for this procurement portal preference.
     * </p>
     * 
     * @return Indicates whether e-invoice delivery is enabled for this procurement portal preference.
     */
    public final Boolean einvoiceDeliveryEnabled() {
        return einvoiceDeliveryEnabled;
    }

    /**
     * <p>
     * Indicates whether purchase order retrieval is enabled for this procurement portal preference.
     * </p>
     * 
     * @return Indicates whether purchase order retrieval is enabled for this procurement portal preference.
     */
    public final Boolean purchaseOrderRetrievalEnabled() {
        return purchaseOrderRetrievalEnabled;
    }

    /**
     * <p>
     * The current status of the e-invoice delivery preference in this summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #einvoiceDeliveryPreferenceStatus} will return
     * {@link ProcurementPortalPreferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #einvoiceDeliveryPreferenceStatusAsString}.
     * </p>
     * 
     * @return The current status of the e-invoice delivery preference in this summary.
     * @see ProcurementPortalPreferenceStatus
     */
    public final ProcurementPortalPreferenceStatus einvoiceDeliveryPreferenceStatus() {
        return ProcurementPortalPreferenceStatus.fromValue(einvoiceDeliveryPreferenceStatus);
    }

    /**
     * <p>
     * The current status of the e-invoice delivery preference in this summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #einvoiceDeliveryPreferenceStatus} will return
     * {@link ProcurementPortalPreferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #einvoiceDeliveryPreferenceStatusAsString}.
     * </p>
     * 
     * @return The current status of the e-invoice delivery preference in this summary.
     * @see ProcurementPortalPreferenceStatus
     */
    public final String einvoiceDeliveryPreferenceStatusAsString() {
        return einvoiceDeliveryPreferenceStatus;
    }

    /**
     * <p>
     * The reason for the current e-invoice delivery preference status in this summary.
     * </p>
     * 
     * @return The reason for the current e-invoice delivery preference status in this summary.
     */
    public final String einvoiceDeliveryPreferenceStatusReason() {
        return einvoiceDeliveryPreferenceStatusReason;
    }

    /**
     * <p>
     * The current status of the purchase order retrieval preference in this summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #purchaseOrderRetrievalPreferenceStatus} will return
     * {@link ProcurementPortalPreferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #purchaseOrderRetrievalPreferenceStatusAsString}.
     * </p>
     * 
     * @return The current status of the purchase order retrieval preference in this summary.
     * @see ProcurementPortalPreferenceStatus
     */
    public final ProcurementPortalPreferenceStatus purchaseOrderRetrievalPreferenceStatus() {
        return ProcurementPortalPreferenceStatus.fromValue(purchaseOrderRetrievalPreferenceStatus);
    }

    /**
     * <p>
     * The current status of the purchase order retrieval preference in this summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #purchaseOrderRetrievalPreferenceStatus} will return
     * {@link ProcurementPortalPreferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #purchaseOrderRetrievalPreferenceStatusAsString}.
     * </p>
     * 
     * @return The current status of the purchase order retrieval preference in this summary.
     * @see ProcurementPortalPreferenceStatus
     */
    public final String purchaseOrderRetrievalPreferenceStatusAsString() {
        return purchaseOrderRetrievalPreferenceStatus;
    }

    /**
     * <p>
     * The reason for the current purchase order retrieval preference status in this summary.
     * </p>
     * 
     * @return The reason for the current purchase order retrieval preference status in this summary.
     */
    public final String purchaseOrderRetrievalPreferenceStatusReason() {
        return purchaseOrderRetrievalPreferenceStatusReason;
    }

    /**
     * <p>
     * The version number of the procurement portal preference configuration in this summary.
     * </p>
     * 
     * @return The version number of the procurement portal preference configuration in this summary.
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * The date and time when the procurement portal preference was created.
     * </p>
     * 
     * @return The date and time when the procurement portal preference was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The date and time when the procurement portal preference was last updated.
     * </p>
     * 
     * @return The date and time when the procurement portal preference was last updated.
     */
    public final Instant lastUpdateDate() {
        return lastUpdateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(procurementPortalPreferenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(procurementPortalNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(buyerDomainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(buyerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(supplierDomainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(supplierIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(selector());
        hashCode = 31 * hashCode + Objects.hashCode(einvoiceDeliveryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseOrderRetrievalEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(einvoiceDeliveryPreferenceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(einvoiceDeliveryPreferenceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseOrderRetrievalPreferenceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseOrderRetrievalPreferenceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcurementPortalPreferenceSummary)) {
            return false;
        }
        ProcurementPortalPreferenceSummary other = (ProcurementPortalPreferenceSummary) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(procurementPortalPreferenceArn(), other.procurementPortalPreferenceArn())
                && Objects.equals(procurementPortalNameAsString(), other.procurementPortalNameAsString())
                && Objects.equals(buyerDomainAsString(), other.buyerDomainAsString())
                && Objects.equals(buyerIdentifier(), other.buyerIdentifier())
                && Objects.equals(supplierDomainAsString(), other.supplierDomainAsString())
                && Objects.equals(supplierIdentifier(), other.supplierIdentifier())
                && Objects.equals(selector(), other.selector())
                && Objects.equals(einvoiceDeliveryEnabled(), other.einvoiceDeliveryEnabled())
                && Objects.equals(purchaseOrderRetrievalEnabled(), other.purchaseOrderRetrievalEnabled())
                && Objects.equals(einvoiceDeliveryPreferenceStatusAsString(), other.einvoiceDeliveryPreferenceStatusAsString())
                && Objects.equals(einvoiceDeliveryPreferenceStatusReason(), other.einvoiceDeliveryPreferenceStatusReason())
                && Objects.equals(purchaseOrderRetrievalPreferenceStatusAsString(),
                        other.purchaseOrderRetrievalPreferenceStatusAsString())
                && Objects.equals(purchaseOrderRetrievalPreferenceStatusReason(),
                        other.purchaseOrderRetrievalPreferenceStatusReason()) && Objects.equals(version(), other.version())
                && Objects.equals(createDate(), other.createDate()) && Objects.equals(lastUpdateDate(), other.lastUpdateDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProcurementPortalPreferenceSummary").add("AwsAccountId", awsAccountId())
                .add("ProcurementPortalPreferenceArn", procurementPortalPreferenceArn())
                .add("ProcurementPortalName", procurementPortalNameAsString()).add("BuyerDomain", buyerDomainAsString())
                .add("BuyerIdentifier", buyerIdentifier()).add("SupplierDomain", supplierDomainAsString())
                .add("SupplierIdentifier", supplierIdentifier()).add("Selector", selector())
                .add("EinvoiceDeliveryEnabled", einvoiceDeliveryEnabled())
                .add("PurchaseOrderRetrievalEnabled", purchaseOrderRetrievalEnabled())
                .add("EinvoiceDeliveryPreferenceStatus", einvoiceDeliveryPreferenceStatusAsString())
                .add("EinvoiceDeliveryPreferenceStatusReason", einvoiceDeliveryPreferenceStatusReason())
                .add("PurchaseOrderRetrievalPreferenceStatus", purchaseOrderRetrievalPreferenceStatusAsString())
                .add("PurchaseOrderRetrievalPreferenceStatusReason", purchaseOrderRetrievalPreferenceStatusReason())
                .add("Version", version()).add("CreateDate", createDate()).add("LastUpdateDate", lastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "ProcurementPortalPreferenceArn":
            return Optional.ofNullable(clazz.cast(procurementPortalPreferenceArn()));
        case "ProcurementPortalName":
            return Optional.ofNullable(clazz.cast(procurementPortalNameAsString()));
        case "BuyerDomain":
            return Optional.ofNullable(clazz.cast(buyerDomainAsString()));
        case "BuyerIdentifier":
            return Optional.ofNullable(clazz.cast(buyerIdentifier()));
        case "SupplierDomain":
            return Optional.ofNullable(clazz.cast(supplierDomainAsString()));
        case "SupplierIdentifier":
            return Optional.ofNullable(clazz.cast(supplierIdentifier()));
        case "Selector":
            return Optional.ofNullable(clazz.cast(selector()));
        case "EinvoiceDeliveryEnabled":
            return Optional.ofNullable(clazz.cast(einvoiceDeliveryEnabled()));
        case "PurchaseOrderRetrievalEnabled":
            return Optional.ofNullable(clazz.cast(purchaseOrderRetrievalEnabled()));
        case "EinvoiceDeliveryPreferenceStatus":
            return Optional.ofNullable(clazz.cast(einvoiceDeliveryPreferenceStatusAsString()));
        case "EinvoiceDeliveryPreferenceStatusReason":
            return Optional.ofNullable(clazz.cast(einvoiceDeliveryPreferenceStatusReason()));
        case "PurchaseOrderRetrievalPreferenceStatus":
            return Optional.ofNullable(clazz.cast(purchaseOrderRetrievalPreferenceStatusAsString()));
        case "PurchaseOrderRetrievalPreferenceStatusReason":
            return Optional.ofNullable(clazz.cast(purchaseOrderRetrievalPreferenceStatusReason()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "LastUpdateDate":
            return Optional.ofNullable(clazz.cast(lastUpdateDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("ProcurementPortalPreferenceArn", PROCUREMENT_PORTAL_PREFERENCE_ARN_FIELD);
        map.put("ProcurementPortalName", PROCUREMENT_PORTAL_NAME_FIELD);
        map.put("BuyerDomain", BUYER_DOMAIN_FIELD);
        map.put("BuyerIdentifier", BUYER_IDENTIFIER_FIELD);
        map.put("SupplierDomain", SUPPLIER_DOMAIN_FIELD);
        map.put("SupplierIdentifier", SUPPLIER_IDENTIFIER_FIELD);
        map.put("Selector", SELECTOR_FIELD);
        map.put("EinvoiceDeliveryEnabled", EINVOICE_DELIVERY_ENABLED_FIELD);
        map.put("PurchaseOrderRetrievalEnabled", PURCHASE_ORDER_RETRIEVAL_ENABLED_FIELD);
        map.put("EinvoiceDeliveryPreferenceStatus", EINVOICE_DELIVERY_PREFERENCE_STATUS_FIELD);
        map.put("EinvoiceDeliveryPreferenceStatusReason", EINVOICE_DELIVERY_PREFERENCE_STATUS_REASON_FIELD);
        map.put("PurchaseOrderRetrievalPreferenceStatus", PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_FIELD);
        map.put("PurchaseOrderRetrievalPreferenceStatusReason", PURCHASE_ORDER_RETRIEVAL_PREFERENCE_STATUS_REASON_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("LastUpdateDate", LAST_UPDATE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProcurementPortalPreferenceSummary, T> g) {
        return obj -> g.apply((ProcurementPortalPreferenceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcurementPortalPreferenceSummary> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with this procurement portal preference summary.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID associated with this procurement portal preference summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the procurement portal preference.
         * </p>
         * 
         * @param procurementPortalPreferenceArn
         *        The Amazon Resource Name (ARN) of the procurement portal preference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder procurementPortalPreferenceArn(String procurementPortalPreferenceArn);

        /**
         * <p>
         * The name of the procurement portal.
         * </p>
         * 
         * @param procurementPortalName
         *        The name of the procurement portal.
         * @see ProcurementPortalName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcurementPortalName
         */
        Builder procurementPortalName(String procurementPortalName);

        /**
         * <p>
         * The name of the procurement portal.
         * </p>
         * 
         * @param procurementPortalName
         *        The name of the procurement portal.
         * @see ProcurementPortalName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcurementPortalName
         */
        Builder procurementPortalName(ProcurementPortalName procurementPortalName);

        /**
         * <p>
         * The domain identifier for the buyer in the procurement portal.
         * </p>
         * 
         * @param buyerDomain
         *        The domain identifier for the buyer in the procurement portal.
         * @see BuyerDomain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BuyerDomain
         */
        Builder buyerDomain(String buyerDomain);

        /**
         * <p>
         * The domain identifier for the buyer in the procurement portal.
         * </p>
         * 
         * @param buyerDomain
         *        The domain identifier for the buyer in the procurement portal.
         * @see BuyerDomain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BuyerDomain
         */
        Builder buyerDomain(BuyerDomain buyerDomain);

        /**
         * <p>
         * The unique identifier for the buyer in the procurement portal.
         * </p>
         * 
         * @param buyerIdentifier
         *        The unique identifier for the buyer in the procurement portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buyerIdentifier(String buyerIdentifier);

        /**
         * <p>
         * The domain identifier for the supplier in the procurement portal.
         * </p>
         * 
         * @param supplierDomain
         *        The domain identifier for the supplier in the procurement portal.
         * @see SupplierDomain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupplierDomain
         */
        Builder supplierDomain(String supplierDomain);

        /**
         * <p>
         * The domain identifier for the supplier in the procurement portal.
         * </p>
         * 
         * @param supplierDomain
         *        The domain identifier for the supplier in the procurement portal.
         * @see SupplierDomain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupplierDomain
         */
        Builder supplierDomain(SupplierDomain supplierDomain);

        /**
         * <p>
         * The unique identifier for the supplier in the procurement portal.
         * </p>
         * 
         * @param supplierIdentifier
         *        The unique identifier for the supplier in the procurement portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplierIdentifier(String supplierIdentifier);

        /**
         * Sets the value of the Selector property for this object.
         *
         * @param selector
         *        The new value for the Selector property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selector(ProcurementPortalPreferenceSelector selector);

        /**
         * Sets the value of the Selector property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link ProcurementPortalPreferenceSelector.Builder} avoiding the need to create one manually via
         * {@link ProcurementPortalPreferenceSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcurementPortalPreferenceSelector.Builder#build()} is called
         * immediately and its result is passed to {@link #selector(ProcurementPortalPreferenceSelector)}.
         * 
         * @param selector
         *        a consumer that will call methods on {@link ProcurementPortalPreferenceSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selector(ProcurementPortalPreferenceSelector)
         */
        default Builder selector(Consumer<ProcurementPortalPreferenceSelector.Builder> selector) {
            return selector(ProcurementPortalPreferenceSelector.builder().applyMutation(selector).build());
        }

        /**
         * <p>
         * Indicates whether e-invoice delivery is enabled for this procurement portal preference.
         * </p>
         * 
         * @param einvoiceDeliveryEnabled
         *        Indicates whether e-invoice delivery is enabled for this procurement portal preference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled);

        /**
         * <p>
         * Indicates whether purchase order retrieval is enabled for this procurement portal preference.
         * </p>
         * 
         * @param purchaseOrderRetrievalEnabled
         *        Indicates whether purchase order retrieval is enabled for this procurement portal preference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled);

        /**
         * <p>
         * The current status of the e-invoice delivery preference in this summary.
         * </p>
         * 
         * @param einvoiceDeliveryPreferenceStatus
         *        The current status of the e-invoice delivery preference in this summary.
         * @see ProcurementPortalPreferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcurementPortalPreferenceStatus
         */
        Builder einvoiceDeliveryPreferenceStatus(String einvoiceDeliveryPreferenceStatus);

        /**
         * <p>
         * The current status of the e-invoice delivery preference in this summary.
         * </p>
         * 
         * @param einvoiceDeliveryPreferenceStatus
         *        The current status of the e-invoice delivery preference in this summary.
         * @see ProcurementPortalPreferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcurementPortalPreferenceStatus
         */
        Builder einvoiceDeliveryPreferenceStatus(ProcurementPortalPreferenceStatus einvoiceDeliveryPreferenceStatus);

        /**
         * <p>
         * The reason for the current e-invoice delivery preference status in this summary.
         * </p>
         * 
         * @param einvoiceDeliveryPreferenceStatusReason
         *        The reason for the current e-invoice delivery preference status in this summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryPreferenceStatusReason(String einvoiceDeliveryPreferenceStatusReason);

        /**
         * <p>
         * The current status of the purchase order retrieval preference in this summary.
         * </p>
         * 
         * @param purchaseOrderRetrievalPreferenceStatus
         *        The current status of the purchase order retrieval preference in this summary.
         * @see ProcurementPortalPreferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcurementPortalPreferenceStatus
         */
        Builder purchaseOrderRetrievalPreferenceStatus(String purchaseOrderRetrievalPreferenceStatus);

        /**
         * <p>
         * The current status of the purchase order retrieval preference in this summary.
         * </p>
         * 
         * @param purchaseOrderRetrievalPreferenceStatus
         *        The current status of the purchase order retrieval preference in this summary.
         * @see ProcurementPortalPreferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcurementPortalPreferenceStatus
         */
        Builder purchaseOrderRetrievalPreferenceStatus(ProcurementPortalPreferenceStatus purchaseOrderRetrievalPreferenceStatus);

        /**
         * <p>
         * The reason for the current purchase order retrieval preference status in this summary.
         * </p>
         * 
         * @param purchaseOrderRetrievalPreferenceStatusReason
         *        The reason for the current purchase order retrieval preference status in this summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseOrderRetrievalPreferenceStatusReason(String purchaseOrderRetrievalPreferenceStatusReason);

        /**
         * <p>
         * The version number of the procurement portal preference configuration in this summary.
         * </p>
         * 
         * @param version
         *        The version number of the procurement portal preference configuration in this summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The date and time when the procurement portal preference was created.
         * </p>
         * 
         * @param createDate
         *        The date and time when the procurement portal preference was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The date and time when the procurement portal preference was last updated.
         * </p>
         * 
         * @param lastUpdateDate
         *        The date and time when the procurement portal preference was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDate(Instant lastUpdateDate);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private String procurementPortalPreferenceArn;

        private String procurementPortalName;

        private String buyerDomain;

        private String buyerIdentifier;

        private String supplierDomain;

        private String supplierIdentifier;

        private ProcurementPortalPreferenceSelector selector;

        private Boolean einvoiceDeliveryEnabled;

        private Boolean purchaseOrderRetrievalEnabled;

        private String einvoiceDeliveryPreferenceStatus;

        private String einvoiceDeliveryPreferenceStatusReason;

        private String purchaseOrderRetrievalPreferenceStatus;

        private String purchaseOrderRetrievalPreferenceStatusReason;

        private Long version;

        private Instant createDate;

        private Instant lastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcurementPortalPreferenceSummary model) {
            awsAccountId(model.awsAccountId);
            procurementPortalPreferenceArn(model.procurementPortalPreferenceArn);
            procurementPortalName(model.procurementPortalName);
            buyerDomain(model.buyerDomain);
            buyerIdentifier(model.buyerIdentifier);
            supplierDomain(model.supplierDomain);
            supplierIdentifier(model.supplierIdentifier);
            selector(model.selector);
            einvoiceDeliveryEnabled(model.einvoiceDeliveryEnabled);
            purchaseOrderRetrievalEnabled(model.purchaseOrderRetrievalEnabled);
            einvoiceDeliveryPreferenceStatus(model.einvoiceDeliveryPreferenceStatus);
            einvoiceDeliveryPreferenceStatusReason(model.einvoiceDeliveryPreferenceStatusReason);
            purchaseOrderRetrievalPreferenceStatus(model.purchaseOrderRetrievalPreferenceStatus);
            purchaseOrderRetrievalPreferenceStatusReason(model.purchaseOrderRetrievalPreferenceStatusReason);
            version(model.version);
            createDate(model.createDate);
            lastUpdateDate(model.lastUpdateDate);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getProcurementPortalPreferenceArn() {
            return procurementPortalPreferenceArn;
        }

        public final void setProcurementPortalPreferenceArn(String procurementPortalPreferenceArn) {
            this.procurementPortalPreferenceArn = procurementPortalPreferenceArn;
        }

        @Override
        public final Builder procurementPortalPreferenceArn(String procurementPortalPreferenceArn) {
            this.procurementPortalPreferenceArn = procurementPortalPreferenceArn;
            return this;
        }

        public final String getProcurementPortalName() {
            return procurementPortalName;
        }

        public final void setProcurementPortalName(String procurementPortalName) {
            this.procurementPortalName = procurementPortalName;
        }

        @Override
        public final Builder procurementPortalName(String procurementPortalName) {
            this.procurementPortalName = procurementPortalName;
            return this;
        }

        @Override
        public final Builder procurementPortalName(ProcurementPortalName procurementPortalName) {
            this.procurementPortalName(procurementPortalName == null ? null : procurementPortalName.toString());
            return this;
        }

        public final String getBuyerDomain() {
            return buyerDomain;
        }

        public final void setBuyerDomain(String buyerDomain) {
            this.buyerDomain = buyerDomain;
        }

        @Override
        public final Builder buyerDomain(String buyerDomain) {
            this.buyerDomain = buyerDomain;
            return this;
        }

        @Override
        public final Builder buyerDomain(BuyerDomain buyerDomain) {
            this.buyerDomain(buyerDomain == null ? null : buyerDomain.toString());
            return this;
        }

        public final String getBuyerIdentifier() {
            return buyerIdentifier;
        }

        public final void setBuyerIdentifier(String buyerIdentifier) {
            this.buyerIdentifier = buyerIdentifier;
        }

        @Override
        public final Builder buyerIdentifier(String buyerIdentifier) {
            this.buyerIdentifier = buyerIdentifier;
            return this;
        }

        public final String getSupplierDomain() {
            return supplierDomain;
        }

        public final void setSupplierDomain(String supplierDomain) {
            this.supplierDomain = supplierDomain;
        }

        @Override
        public final Builder supplierDomain(String supplierDomain) {
            this.supplierDomain = supplierDomain;
            return this;
        }

        @Override
        public final Builder supplierDomain(SupplierDomain supplierDomain) {
            this.supplierDomain(supplierDomain == null ? null : supplierDomain.toString());
            return this;
        }

        public final String getSupplierIdentifier() {
            return supplierIdentifier;
        }

        public final void setSupplierIdentifier(String supplierIdentifier) {
            this.supplierIdentifier = supplierIdentifier;
        }

        @Override
        public final Builder supplierIdentifier(String supplierIdentifier) {
            this.supplierIdentifier = supplierIdentifier;
            return this;
        }

        public final ProcurementPortalPreferenceSelector.Builder getSelector() {
            return selector != null ? selector.toBuilder() : null;
        }

        public final void setSelector(ProcurementPortalPreferenceSelector.BuilderImpl selector) {
            this.selector = selector != null ? selector.build() : null;
        }

        @Override
        public final Builder selector(ProcurementPortalPreferenceSelector selector) {
            this.selector = selector;
            return this;
        }

        public final Boolean getEinvoiceDeliveryEnabled() {
            return einvoiceDeliveryEnabled;
        }

        public final void setEinvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled) {
            this.einvoiceDeliveryEnabled = einvoiceDeliveryEnabled;
        }

        @Override
        public final Builder einvoiceDeliveryEnabled(Boolean einvoiceDeliveryEnabled) {
            this.einvoiceDeliveryEnabled = einvoiceDeliveryEnabled;
            return this;
        }

        public final Boolean getPurchaseOrderRetrievalEnabled() {
            return purchaseOrderRetrievalEnabled;
        }

        public final void setPurchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled) {
            this.purchaseOrderRetrievalEnabled = purchaseOrderRetrievalEnabled;
        }

        @Override
        public final Builder purchaseOrderRetrievalEnabled(Boolean purchaseOrderRetrievalEnabled) {
            this.purchaseOrderRetrievalEnabled = purchaseOrderRetrievalEnabled;
            return this;
        }

        public final String getEinvoiceDeliveryPreferenceStatus() {
            return einvoiceDeliveryPreferenceStatus;
        }

        public final void setEinvoiceDeliveryPreferenceStatus(String einvoiceDeliveryPreferenceStatus) {
            this.einvoiceDeliveryPreferenceStatus = einvoiceDeliveryPreferenceStatus;
        }

        @Override
        public final Builder einvoiceDeliveryPreferenceStatus(String einvoiceDeliveryPreferenceStatus) {
            this.einvoiceDeliveryPreferenceStatus = einvoiceDeliveryPreferenceStatus;
            return this;
        }

        @Override
        public final Builder einvoiceDeliveryPreferenceStatus(ProcurementPortalPreferenceStatus einvoiceDeliveryPreferenceStatus) {
            this.einvoiceDeliveryPreferenceStatus(einvoiceDeliveryPreferenceStatus == null ? null
                    : einvoiceDeliveryPreferenceStatus.toString());
            return this;
        }

        public final String getEinvoiceDeliveryPreferenceStatusReason() {
            return einvoiceDeliveryPreferenceStatusReason;
        }

        public final void setEinvoiceDeliveryPreferenceStatusReason(String einvoiceDeliveryPreferenceStatusReason) {
            this.einvoiceDeliveryPreferenceStatusReason = einvoiceDeliveryPreferenceStatusReason;
        }

        @Override
        public final Builder einvoiceDeliveryPreferenceStatusReason(String einvoiceDeliveryPreferenceStatusReason) {
            this.einvoiceDeliveryPreferenceStatusReason = einvoiceDeliveryPreferenceStatusReason;
            return this;
        }

        public final String getPurchaseOrderRetrievalPreferenceStatus() {
            return purchaseOrderRetrievalPreferenceStatus;
        }

        public final void setPurchaseOrderRetrievalPreferenceStatus(String purchaseOrderRetrievalPreferenceStatus) {
            this.purchaseOrderRetrievalPreferenceStatus = purchaseOrderRetrievalPreferenceStatus;
        }

        @Override
        public final Builder purchaseOrderRetrievalPreferenceStatus(String purchaseOrderRetrievalPreferenceStatus) {
            this.purchaseOrderRetrievalPreferenceStatus = purchaseOrderRetrievalPreferenceStatus;
            return this;
        }

        @Override
        public final Builder purchaseOrderRetrievalPreferenceStatus(
                ProcurementPortalPreferenceStatus purchaseOrderRetrievalPreferenceStatus) {
            this.purchaseOrderRetrievalPreferenceStatus(purchaseOrderRetrievalPreferenceStatus == null ? null
                    : purchaseOrderRetrievalPreferenceStatus.toString());
            return this;
        }

        public final String getPurchaseOrderRetrievalPreferenceStatusReason() {
            return purchaseOrderRetrievalPreferenceStatusReason;
        }

        public final void setPurchaseOrderRetrievalPreferenceStatusReason(String purchaseOrderRetrievalPreferenceStatusReason) {
            this.purchaseOrderRetrievalPreferenceStatusReason = purchaseOrderRetrievalPreferenceStatusReason;
        }

        @Override
        public final Builder purchaseOrderRetrievalPreferenceStatusReason(String purchaseOrderRetrievalPreferenceStatusReason) {
            this.purchaseOrderRetrievalPreferenceStatusReason = purchaseOrderRetrievalPreferenceStatusReason;
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        @Override
        public ProcurementPortalPreferenceSummary build() {
            return new ProcurementPortalPreferenceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
