/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInvoiceSummariesResponse extends InvoicingResponse implements
        ToCopyableBuilder<ListInvoiceSummariesResponse.Builder, ListInvoiceSummariesResponse> {
    private static final SdkField<List<InvoiceSummary>> INVOICE_SUMMARIES_FIELD = SdkField
            .<List<InvoiceSummary>> builder(MarshallingType.LIST)
            .memberName("InvoiceSummaries")
            .getter(getter(ListInvoiceSummariesResponse::invoiceSummaries))
            .setter(setter(Builder::invoiceSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvoiceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvoiceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInvoiceSummariesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOICE_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InvoiceSummary> invoiceSummaries;

    private final String nextToken;

    private ListInvoiceSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.invoiceSummaries = builder.invoiceSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvoiceSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvoiceSummaries() {
        return invoiceSummaries != null && !(invoiceSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of key (summary level) invoice details without line item details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvoiceSummaries} method.
     * </p>
     * 
     * @return List of key (summary level) invoice details without line item details.
     */
    public final List<InvoiceSummary> invoiceSummaries() {
        return invoiceSummaries;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInvoiceSummaries() ? invoiceSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvoiceSummariesResponse)) {
            return false;
        }
        ListInvoiceSummariesResponse other = (ListInvoiceSummariesResponse) obj;
        return hasInvoiceSummaries() == other.hasInvoiceSummaries()
                && Objects.equals(invoiceSummaries(), other.invoiceSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInvoiceSummariesResponse")
                .add("InvoiceSummaries", hasInvoiceSummaries() ? invoiceSummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvoiceSummaries":
            return Optional.ofNullable(clazz.cast(invoiceSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InvoiceSummaries", INVOICE_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvoiceSummariesResponse, T> g) {
        return obj -> g.apply((ListInvoiceSummariesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends InvoicingResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInvoiceSummariesResponse> {
        /**
         * <p>
         * List of key (summary level) invoice details without line item details.
         * </p>
         * 
         * @param invoiceSummaries
         *        List of key (summary level) invoice details without line item details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceSummaries(Collection<InvoiceSummary> invoiceSummaries);

        /**
         * <p>
         * List of key (summary level) invoice details without line item details.
         * </p>
         * 
         * @param invoiceSummaries
         *        List of key (summary level) invoice details without line item details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceSummaries(InvoiceSummary... invoiceSummaries);

        /**
         * <p>
         * List of key (summary level) invoice details without line item details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.invoicing.model.InvoiceSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.invoicing.model.InvoiceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.invoicing.model.InvoiceSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #invoiceSummaries(List<InvoiceSummary>)}.
         * 
         * @param invoiceSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.invoicing.model.InvoiceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invoiceSummaries(java.util.Collection<InvoiceSummary>)
         */
        Builder invoiceSummaries(Consumer<InvoiceSummary.Builder>... invoiceSummaries);

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends InvoicingResponse.BuilderImpl implements Builder {
        private List<InvoiceSummary> invoiceSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvoiceSummariesResponse model) {
            super(model);
            invoiceSummaries(model.invoiceSummaries);
            nextToken(model.nextToken);
        }

        public final List<InvoiceSummary.Builder> getInvoiceSummaries() {
            List<InvoiceSummary.Builder> result = InvoiceSummariesCopier.copyToBuilder(this.invoiceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvoiceSummaries(Collection<InvoiceSummary.BuilderImpl> invoiceSummaries) {
            this.invoiceSummaries = InvoiceSummariesCopier.copyFromBuilder(invoiceSummaries);
        }

        @Override
        public final Builder invoiceSummaries(Collection<InvoiceSummary> invoiceSummaries) {
            this.invoiceSummaries = InvoiceSummariesCopier.copy(invoiceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invoiceSummaries(InvoiceSummary... invoiceSummaries) {
            invoiceSummaries(Arrays.asList(invoiceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invoiceSummaries(Consumer<InvoiceSummary.Builder>... invoiceSummaries) {
            invoiceSummaries(Stream.of(invoiceSummaries).map(c -> InvoiceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInvoiceSummariesResponse build() {
            return new ListInvoiceSummariesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
