/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInvoiceSummariesRequest extends InvoicingRequest implements
        ToCopyableBuilder<ListInvoiceSummariesRequest.Builder, ListInvoiceSummariesRequest> {
    private static final SdkField<InvoiceSummariesSelector> SELECTOR_FIELD = SdkField
            .<InvoiceSummariesSelector> builder(MarshallingType.SDK_POJO).memberName("Selector")
            .getter(getter(ListInvoiceSummariesRequest::selector)).setter(setter(Builder::selector))
            .constructor(InvoiceSummariesSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Selector").build()).build();

    private static final SdkField<InvoiceSummariesFilter> FILTER_FIELD = SdkField
            .<InvoiceSummariesFilter> builder(MarshallingType.SDK_POJO).memberName("Filter")
            .getter(getter(ListInvoiceSummariesRequest::filter)).setter(setter(Builder::filter))
            .constructor(InvoiceSummariesFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInvoiceSummariesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListInvoiceSummariesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTOR_FIELD, FILTER_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final InvoiceSummariesSelector selector;

    private final InvoiceSummariesFilter filter;

    private final String nextToken;

    private final Integer maxResults;

    private ListInvoiceSummariesRequest(BuilderImpl builder) {
        super(builder);
        this.selector = builder.selector;
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The option to retrieve details for a specific invoice by providing its unique ID. Alternatively, access
     * information for all invoices linked to the account by providing an account ID.
     * </p>
     * 
     * @return The option to retrieve details for a specific invoice by providing its unique ID. Alternatively, access
     *         information for all invoices linked to the account by providing an account ID.
     */
    public final InvoiceSummariesSelector selector() {
        return selector;
    }

    /**
     * <p>
     * Filters you can use to customize your invoice summary.
     * </p>
     * 
     * @return Filters you can use to customize your invoice summary.
     */
    public final InvoiceSummariesFilter filter() {
        return filter;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of invoice summaries a paginated response can contain.
     * </p>
     * 
     * @return The maximum number of invoice summaries a paginated response can contain.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(selector());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvoiceSummariesRequest)) {
            return false;
        }
        ListInvoiceSummariesRequest other = (ListInvoiceSummariesRequest) obj;
        return Objects.equals(selector(), other.selector()) && Objects.equals(filter(), other.filter())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInvoiceSummariesRequest").add("Selector", selector()).add("Filter", filter())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Selector":
            return Optional.ofNullable(clazz.cast(selector()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Selector", SELECTOR_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvoiceSummariesRequest, T> g) {
        return obj -> g.apply((ListInvoiceSummariesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends InvoicingRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListInvoiceSummariesRequest> {
        /**
         * <p>
         * The option to retrieve details for a specific invoice by providing its unique ID. Alternatively, access
         * information for all invoices linked to the account by providing an account ID.
         * </p>
         * 
         * @param selector
         *        The option to retrieve details for a specific invoice by providing its unique ID. Alternatively,
         *        access information for all invoices linked to the account by providing an account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selector(InvoiceSummariesSelector selector);

        /**
         * <p>
         * The option to retrieve details for a specific invoice by providing its unique ID. Alternatively, access
         * information for all invoices linked to the account by providing an account ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvoiceSummariesSelector.Builder}
         * avoiding the need to create one manually via {@link InvoiceSummariesSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvoiceSummariesSelector.Builder#build()} is called immediately
         * and its result is passed to {@link #selector(InvoiceSummariesSelector)}.
         * 
         * @param selector
         *        a consumer that will call methods on {@link InvoiceSummariesSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selector(InvoiceSummariesSelector)
         */
        default Builder selector(Consumer<InvoiceSummariesSelector.Builder> selector) {
            return selector(InvoiceSummariesSelector.builder().applyMutation(selector).build());
        }

        /**
         * <p>
         * Filters you can use to customize your invoice summary.
         * </p>
         * 
         * @param filter
         *        Filters you can use to customize your invoice summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(InvoiceSummariesFilter filter);

        /**
         * <p>
         * Filters you can use to customize your invoice summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvoiceSummariesFilter.Builder} avoiding
         * the need to create one manually via {@link InvoiceSummariesFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvoiceSummariesFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #filter(InvoiceSummariesFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link InvoiceSummariesFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(InvoiceSummariesFilter)
         */
        default Builder filter(Consumer<InvoiceSummariesFilter.Builder> filter) {
            return filter(InvoiceSummariesFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of invoice summaries a paginated response can contain.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of invoice summaries a paginated response can contain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InvoicingRequest.BuilderImpl implements Builder {
        private InvoiceSummariesSelector selector;

        private InvoiceSummariesFilter filter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvoiceSummariesRequest model) {
            super(model);
            selector(model.selector);
            filter(model.filter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final InvoiceSummariesSelector.Builder getSelector() {
            return selector != null ? selector.toBuilder() : null;
        }

        public final void setSelector(InvoiceSummariesSelector.BuilderImpl selector) {
            this.selector = selector != null ? selector.build() : null;
        }

        @Override
        public final Builder selector(InvoiceSummariesSelector selector) {
            this.selector = selector;
            return this;
        }

        public final InvoiceSummariesFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(InvoiceSummariesFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(InvoiceSummariesFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInvoiceSummariesRequest build() {
            return new ListInvoiceSummariesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
