/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The invoice that the API retrieved.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvoiceSummary implements SdkPojo, Serializable, ToCopyableBuilder<InvoiceSummary.Builder, InvoiceSummary> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(InvoiceSummary::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> INVOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvoiceId").getter(getter(InvoiceSummary::invoiceId)).setter(setter(Builder::invoiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceId").build()).build();

    private static final SdkField<Instant> ISSUED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("IssuedDate").getter(getter(InvoiceSummary::issuedDate)).setter(setter(Builder::issuedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedDate").build()).build();

    private static final SdkField<Instant> DUE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DueDate").getter(getter(InvoiceSummary::dueDate)).setter(setter(Builder::dueDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DueDate").build()).build();

    private static final SdkField<Entity> ENTITY_FIELD = SdkField.<Entity> builder(MarshallingType.SDK_POJO).memberName("Entity")
            .getter(getter(InvoiceSummary::entity)).setter(setter(Builder::entity)).constructor(Entity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entity").build()).build();

    private static final SdkField<BillingPeriod> BILLING_PERIOD_FIELD = SdkField
            .<BillingPeriod> builder(MarshallingType.SDK_POJO).memberName("BillingPeriod")
            .getter(getter(InvoiceSummary::billingPeriod)).setter(setter(Builder::billingPeriod))
            .constructor(BillingPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriod").build()).build();

    private static final SdkField<String> INVOICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvoiceType").getter(getter(InvoiceSummary::invoiceTypeAsString)).setter(setter(Builder::invoiceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceType").build()).build();

    private static final SdkField<String> ORIGINAL_INVOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginalInvoiceId").getter(getter(InvoiceSummary::originalInvoiceId))
            .setter(setter(Builder::originalInvoiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalInvoiceId").build()).build();

    private static final SdkField<String> PURCHASE_ORDER_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PurchaseOrderNumber").getter(getter(InvoiceSummary::purchaseOrderNumber))
            .setter(setter(Builder::purchaseOrderNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderNumber").build())
            .build();

    private static final SdkField<InvoiceCurrencyAmount> BASE_CURRENCY_AMOUNT_FIELD = SdkField
            .<InvoiceCurrencyAmount> builder(MarshallingType.SDK_POJO).memberName("BaseCurrencyAmount")
            .getter(getter(InvoiceSummary::baseCurrencyAmount)).setter(setter(Builder::baseCurrencyAmount))
            .constructor(InvoiceCurrencyAmount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseCurrencyAmount").build())
            .build();

    private static final SdkField<InvoiceCurrencyAmount> TAX_CURRENCY_AMOUNT_FIELD = SdkField
            .<InvoiceCurrencyAmount> builder(MarshallingType.SDK_POJO).memberName("TaxCurrencyAmount")
            .getter(getter(InvoiceSummary::taxCurrencyAmount)).setter(setter(Builder::taxCurrencyAmount))
            .constructor(InvoiceCurrencyAmount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaxCurrencyAmount").build()).build();

    private static final SdkField<InvoiceCurrencyAmount> PAYMENT_CURRENCY_AMOUNT_FIELD = SdkField
            .<InvoiceCurrencyAmount> builder(MarshallingType.SDK_POJO).memberName("PaymentCurrencyAmount")
            .getter(getter(InvoiceSummary::paymentCurrencyAmount)).setter(setter(Builder::paymentCurrencyAmount))
            .constructor(InvoiceCurrencyAmount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentCurrencyAmount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            INVOICE_ID_FIELD, ISSUED_DATE_FIELD, DUE_DATE_FIELD, ENTITY_FIELD, BILLING_PERIOD_FIELD, INVOICE_TYPE_FIELD,
            ORIGINAL_INVOICE_ID_FIELD, PURCHASE_ORDER_NUMBER_FIELD, BASE_CURRENCY_AMOUNT_FIELD, TAX_CURRENCY_AMOUNT_FIELD,
            PAYMENT_CURRENCY_AMOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String invoiceId;

    private final Instant issuedDate;

    private final Instant dueDate;

    private final Entity entity;

    private final BillingPeriod billingPeriod;

    private final String invoiceType;

    private final String originalInvoiceId;

    private final String purchaseOrderNumber;

    private final InvoiceCurrencyAmount baseCurrencyAmount;

    private final InvoiceCurrencyAmount taxCurrencyAmount;

    private final InvoiceCurrencyAmount paymentCurrencyAmount;

    private InvoiceSummary(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.invoiceId = builder.invoiceId;
        this.issuedDate = builder.issuedDate;
        this.dueDate = builder.dueDate;
        this.entity = builder.entity;
        this.billingPeriod = builder.billingPeriod;
        this.invoiceType = builder.invoiceType;
        this.originalInvoiceId = builder.originalInvoiceId;
        this.purchaseOrderNumber = builder.purchaseOrderNumber;
        this.baseCurrencyAmount = builder.baseCurrencyAmount;
        this.taxCurrencyAmount = builder.taxCurrencyAmount;
        this.paymentCurrencyAmount = builder.paymentCurrencyAmount;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The invoice ID.
     * </p>
     * 
     * @return The invoice ID.
     */
    public final String invoiceId() {
        return invoiceId;
    }

    /**
     * <p>
     * The issued date of the invoice.
     * </p>
     * 
     * @return The issued date of the invoice.
     */
    public final Instant issuedDate() {
        return issuedDate;
    }

    /**
     * <p>
     * The invoice due date.
     * </p>
     * 
     * @return The invoice due date.
     */
    public final Instant dueDate() {
        return dueDate;
    }

    /**
     * <p>
     * The organization name providing Amazon Web Services services.
     * </p>
     * 
     * @return The organization name providing Amazon Web Services services.
     */
    public final Entity entity() {
        return entity;
    }

    /**
     * <p>
     * The billing period of the invoice-related document.
     * </p>
     * 
     * @return The billing period of the invoice-related document.
     */
    public final BillingPeriod billingPeriod() {
        return billingPeriod;
    }

    /**
     * <p>
     * The type of invoice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invoiceType} will
     * return {@link InvoiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #invoiceTypeAsString}.
     * </p>
     * 
     * @return The type of invoice.
     * @see InvoiceType
     */
    public final InvoiceType invoiceType() {
        return InvoiceType.fromValue(invoiceType);
    }

    /**
     * <p>
     * The type of invoice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invoiceType} will
     * return {@link InvoiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #invoiceTypeAsString}.
     * </p>
     * 
     * @return The type of invoice.
     * @see InvoiceType
     */
    public final String invoiceTypeAsString() {
        return invoiceType;
    }

    /**
     * <p>
     * The initial or original invoice ID.
     * </p>
     * 
     * @return The initial or original invoice ID.
     */
    public final String originalInvoiceId() {
        return originalInvoiceId;
    }

    /**
     * <p>
     * The purchase order number associated to the invoice.
     * </p>
     * 
     * @return The purchase order number associated to the invoice.
     */
    public final String purchaseOrderNumber() {
        return purchaseOrderNumber;
    }

    /**
     * <p>
     * The summary with the product and service currency.
     * </p>
     * 
     * @return The summary with the product and service currency.
     */
    public final InvoiceCurrencyAmount baseCurrencyAmount() {
        return baseCurrencyAmount;
    }

    /**
     * <p>
     * The summary with the tax currency.
     * </p>
     * 
     * @return The summary with the tax currency.
     */
    public final InvoiceCurrencyAmount taxCurrencyAmount() {
        return taxCurrencyAmount;
    }

    /**
     * <p>
     * The summary with the customer configured currency.
     * </p>
     * 
     * @return The summary with the customer configured currency.
     */
    public final InvoiceCurrencyAmount paymentCurrencyAmount() {
        return paymentCurrencyAmount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(invoiceId());
        hashCode = 31 * hashCode + Objects.hashCode(issuedDate());
        hashCode = 31 * hashCode + Objects.hashCode(dueDate());
        hashCode = 31 * hashCode + Objects.hashCode(entity());
        hashCode = 31 * hashCode + Objects.hashCode(billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(invoiceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(originalInvoiceId());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseOrderNumber());
        hashCode = 31 * hashCode + Objects.hashCode(baseCurrencyAmount());
        hashCode = 31 * hashCode + Objects.hashCode(taxCurrencyAmount());
        hashCode = 31 * hashCode + Objects.hashCode(paymentCurrencyAmount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvoiceSummary)) {
            return false;
        }
        InvoiceSummary other = (InvoiceSummary) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(invoiceId(), other.invoiceId())
                && Objects.equals(issuedDate(), other.issuedDate()) && Objects.equals(dueDate(), other.dueDate())
                && Objects.equals(entity(), other.entity()) && Objects.equals(billingPeriod(), other.billingPeriod())
                && Objects.equals(invoiceTypeAsString(), other.invoiceTypeAsString())
                && Objects.equals(originalInvoiceId(), other.originalInvoiceId())
                && Objects.equals(purchaseOrderNumber(), other.purchaseOrderNumber())
                && Objects.equals(baseCurrencyAmount(), other.baseCurrencyAmount())
                && Objects.equals(taxCurrencyAmount(), other.taxCurrencyAmount())
                && Objects.equals(paymentCurrencyAmount(), other.paymentCurrencyAmount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvoiceSummary").add("AccountId", accountId()).add("InvoiceId", invoiceId())
                .add("IssuedDate", issuedDate()).add("DueDate", dueDate()).add("Entity", entity())
                .add("BillingPeriod", billingPeriod()).add("InvoiceType", invoiceTypeAsString())
                .add("OriginalInvoiceId", originalInvoiceId()).add("PurchaseOrderNumber", purchaseOrderNumber())
                .add("BaseCurrencyAmount", baseCurrencyAmount()).add("TaxCurrencyAmount", taxCurrencyAmount())
                .add("PaymentCurrencyAmount", paymentCurrencyAmount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "InvoiceId":
            return Optional.ofNullable(clazz.cast(invoiceId()));
        case "IssuedDate":
            return Optional.ofNullable(clazz.cast(issuedDate()));
        case "DueDate":
            return Optional.ofNullable(clazz.cast(dueDate()));
        case "Entity":
            return Optional.ofNullable(clazz.cast(entity()));
        case "BillingPeriod":
            return Optional.ofNullable(clazz.cast(billingPeriod()));
        case "InvoiceType":
            return Optional.ofNullable(clazz.cast(invoiceTypeAsString()));
        case "OriginalInvoiceId":
            return Optional.ofNullable(clazz.cast(originalInvoiceId()));
        case "PurchaseOrderNumber":
            return Optional.ofNullable(clazz.cast(purchaseOrderNumber()));
        case "BaseCurrencyAmount":
            return Optional.ofNullable(clazz.cast(baseCurrencyAmount()));
        case "TaxCurrencyAmount":
            return Optional.ofNullable(clazz.cast(taxCurrencyAmount()));
        case "PaymentCurrencyAmount":
            return Optional.ofNullable(clazz.cast(paymentCurrencyAmount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("InvoiceId", INVOICE_ID_FIELD);
        map.put("IssuedDate", ISSUED_DATE_FIELD);
        map.put("DueDate", DUE_DATE_FIELD);
        map.put("Entity", ENTITY_FIELD);
        map.put("BillingPeriod", BILLING_PERIOD_FIELD);
        map.put("InvoiceType", INVOICE_TYPE_FIELD);
        map.put("OriginalInvoiceId", ORIGINAL_INVOICE_ID_FIELD);
        map.put("PurchaseOrderNumber", PURCHASE_ORDER_NUMBER_FIELD);
        map.put("BaseCurrencyAmount", BASE_CURRENCY_AMOUNT_FIELD);
        map.put("TaxCurrencyAmount", TAX_CURRENCY_AMOUNT_FIELD);
        map.put("PaymentCurrencyAmount", PAYMENT_CURRENCY_AMOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvoiceSummary, T> g) {
        return obj -> g.apply((InvoiceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvoiceSummary> {
        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The invoice ID.
         * </p>
         * 
         * @param invoiceId
         *        The invoice ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceId(String invoiceId);

        /**
         * <p>
         * The issued date of the invoice.
         * </p>
         * 
         * @param issuedDate
         *        The issued date of the invoice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuedDate(Instant issuedDate);

        /**
         * <p>
         * The invoice due date.
         * </p>
         * 
         * @param dueDate
         *        The invoice due date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dueDate(Instant dueDate);

        /**
         * <p>
         * The organization name providing Amazon Web Services services.
         * </p>
         * 
         * @param entity
         *        The organization name providing Amazon Web Services services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entity(Entity entity);

        /**
         * <p>
         * The organization name providing Amazon Web Services services.
         * </p>
         * This is a convenience method that creates an instance of the {@link Entity.Builder} avoiding the need to
         * create one manually via {@link Entity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Entity.Builder#build()} is called immediately and its result is
         * passed to {@link #entity(Entity)}.
         * 
         * @param entity
         *        a consumer that will call methods on {@link Entity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entity(Entity)
         */
        default Builder entity(Consumer<Entity.Builder> entity) {
            return entity(Entity.builder().applyMutation(entity).build());
        }

        /**
         * <p>
         * The billing period of the invoice-related document.
         * </p>
         * 
         * @param billingPeriod
         *        The billing period of the invoice-related document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingPeriod(BillingPeriod billingPeriod);

        /**
         * <p>
         * The billing period of the invoice-related document.
         * </p>
         * This is a convenience method that creates an instance of the {@link BillingPeriod.Builder} avoiding the need
         * to create one manually via {@link BillingPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BillingPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #billingPeriod(BillingPeriod)}.
         * 
         * @param billingPeriod
         *        a consumer that will call methods on {@link BillingPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingPeriod(BillingPeriod)
         */
        default Builder billingPeriod(Consumer<BillingPeriod.Builder> billingPeriod) {
            return billingPeriod(BillingPeriod.builder().applyMutation(billingPeriod).build());
        }

        /**
         * <p>
         * The type of invoice.
         * </p>
         * 
         * @param invoiceType
         *        The type of invoice.
         * @see InvoiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvoiceType
         */
        Builder invoiceType(String invoiceType);

        /**
         * <p>
         * The type of invoice.
         * </p>
         * 
         * @param invoiceType
         *        The type of invoice.
         * @see InvoiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvoiceType
         */
        Builder invoiceType(InvoiceType invoiceType);

        /**
         * <p>
         * The initial or original invoice ID.
         * </p>
         * 
         * @param originalInvoiceId
         *        The initial or original invoice ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalInvoiceId(String originalInvoiceId);

        /**
         * <p>
         * The purchase order number associated to the invoice.
         * </p>
         * 
         * @param purchaseOrderNumber
         *        The purchase order number associated to the invoice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseOrderNumber(String purchaseOrderNumber);

        /**
         * <p>
         * The summary with the product and service currency.
         * </p>
         * 
         * @param baseCurrencyAmount
         *        The summary with the product and service currency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseCurrencyAmount(InvoiceCurrencyAmount baseCurrencyAmount);

        /**
         * <p>
         * The summary with the product and service currency.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvoiceCurrencyAmount.Builder} avoiding
         * the need to create one manually via {@link InvoiceCurrencyAmount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvoiceCurrencyAmount.Builder#build()} is called immediately and
         * its result is passed to {@link #baseCurrencyAmount(InvoiceCurrencyAmount)}.
         * 
         * @param baseCurrencyAmount
         *        a consumer that will call methods on {@link InvoiceCurrencyAmount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baseCurrencyAmount(InvoiceCurrencyAmount)
         */
        default Builder baseCurrencyAmount(Consumer<InvoiceCurrencyAmount.Builder> baseCurrencyAmount) {
            return baseCurrencyAmount(InvoiceCurrencyAmount.builder().applyMutation(baseCurrencyAmount).build());
        }

        /**
         * <p>
         * The summary with the tax currency.
         * </p>
         * 
         * @param taxCurrencyAmount
         *        The summary with the tax currency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxCurrencyAmount(InvoiceCurrencyAmount taxCurrencyAmount);

        /**
         * <p>
         * The summary with the tax currency.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvoiceCurrencyAmount.Builder} avoiding
         * the need to create one manually via {@link InvoiceCurrencyAmount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvoiceCurrencyAmount.Builder#build()} is called immediately and
         * its result is passed to {@link #taxCurrencyAmount(InvoiceCurrencyAmount)}.
         * 
         * @param taxCurrencyAmount
         *        a consumer that will call methods on {@link InvoiceCurrencyAmount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxCurrencyAmount(InvoiceCurrencyAmount)
         */
        default Builder taxCurrencyAmount(Consumer<InvoiceCurrencyAmount.Builder> taxCurrencyAmount) {
            return taxCurrencyAmount(InvoiceCurrencyAmount.builder().applyMutation(taxCurrencyAmount).build());
        }

        /**
         * <p>
         * The summary with the customer configured currency.
         * </p>
         * 
         * @param paymentCurrencyAmount
         *        The summary with the customer configured currency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentCurrencyAmount(InvoiceCurrencyAmount paymentCurrencyAmount);

        /**
         * <p>
         * The summary with the customer configured currency.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvoiceCurrencyAmount.Builder} avoiding
         * the need to create one manually via {@link InvoiceCurrencyAmount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvoiceCurrencyAmount.Builder#build()} is called immediately and
         * its result is passed to {@link #paymentCurrencyAmount(InvoiceCurrencyAmount)}.
         * 
         * @param paymentCurrencyAmount
         *        a consumer that will call methods on {@link InvoiceCurrencyAmount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paymentCurrencyAmount(InvoiceCurrencyAmount)
         */
        default Builder paymentCurrencyAmount(Consumer<InvoiceCurrencyAmount.Builder> paymentCurrencyAmount) {
            return paymentCurrencyAmount(InvoiceCurrencyAmount.builder().applyMutation(paymentCurrencyAmount).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String invoiceId;

        private Instant issuedDate;

        private Instant dueDate;

        private Entity entity;

        private BillingPeriod billingPeriod;

        private String invoiceType;

        private String originalInvoiceId;

        private String purchaseOrderNumber;

        private InvoiceCurrencyAmount baseCurrencyAmount;

        private InvoiceCurrencyAmount taxCurrencyAmount;

        private InvoiceCurrencyAmount paymentCurrencyAmount;

        private BuilderImpl() {
        }

        private BuilderImpl(InvoiceSummary model) {
            accountId(model.accountId);
            invoiceId(model.invoiceId);
            issuedDate(model.issuedDate);
            dueDate(model.dueDate);
            entity(model.entity);
            billingPeriod(model.billingPeriod);
            invoiceType(model.invoiceType);
            originalInvoiceId(model.originalInvoiceId);
            purchaseOrderNumber(model.purchaseOrderNumber);
            baseCurrencyAmount(model.baseCurrencyAmount);
            taxCurrencyAmount(model.taxCurrencyAmount);
            paymentCurrencyAmount(model.paymentCurrencyAmount);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getInvoiceId() {
            return invoiceId;
        }

        public final void setInvoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        @Override
        public final Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public final Instant getIssuedDate() {
            return issuedDate;
        }

        public final void setIssuedDate(Instant issuedDate) {
            this.issuedDate = issuedDate;
        }

        @Override
        public final Builder issuedDate(Instant issuedDate) {
            this.issuedDate = issuedDate;
            return this;
        }

        public final Instant getDueDate() {
            return dueDate;
        }

        public final void setDueDate(Instant dueDate) {
            this.dueDate = dueDate;
        }

        @Override
        public final Builder dueDate(Instant dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public final Entity.Builder getEntity() {
            return entity != null ? entity.toBuilder() : null;
        }

        public final void setEntity(Entity.BuilderImpl entity) {
            this.entity = entity != null ? entity.build() : null;
        }

        @Override
        public final Builder entity(Entity entity) {
            this.entity = entity;
            return this;
        }

        public final BillingPeriod.Builder getBillingPeriod() {
            return billingPeriod != null ? billingPeriod.toBuilder() : null;
        }

        public final void setBillingPeriod(BillingPeriod.BuilderImpl billingPeriod) {
            this.billingPeriod = billingPeriod != null ? billingPeriod.build() : null;
        }

        @Override
        public final Builder billingPeriod(BillingPeriod billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final String getInvoiceType() {
            return invoiceType;
        }

        public final void setInvoiceType(String invoiceType) {
            this.invoiceType = invoiceType;
        }

        @Override
        public final Builder invoiceType(String invoiceType) {
            this.invoiceType = invoiceType;
            return this;
        }

        @Override
        public final Builder invoiceType(InvoiceType invoiceType) {
            this.invoiceType(invoiceType == null ? null : invoiceType.toString());
            return this;
        }

        public final String getOriginalInvoiceId() {
            return originalInvoiceId;
        }

        public final void setOriginalInvoiceId(String originalInvoiceId) {
            this.originalInvoiceId = originalInvoiceId;
        }

        @Override
        public final Builder originalInvoiceId(String originalInvoiceId) {
            this.originalInvoiceId = originalInvoiceId;
            return this;
        }

        public final String getPurchaseOrderNumber() {
            return purchaseOrderNumber;
        }

        public final void setPurchaseOrderNumber(String purchaseOrderNumber) {
            this.purchaseOrderNumber = purchaseOrderNumber;
        }

        @Override
        public final Builder purchaseOrderNumber(String purchaseOrderNumber) {
            this.purchaseOrderNumber = purchaseOrderNumber;
            return this;
        }

        public final InvoiceCurrencyAmount.Builder getBaseCurrencyAmount() {
            return baseCurrencyAmount != null ? baseCurrencyAmount.toBuilder() : null;
        }

        public final void setBaseCurrencyAmount(InvoiceCurrencyAmount.BuilderImpl baseCurrencyAmount) {
            this.baseCurrencyAmount = baseCurrencyAmount != null ? baseCurrencyAmount.build() : null;
        }

        @Override
        public final Builder baseCurrencyAmount(InvoiceCurrencyAmount baseCurrencyAmount) {
            this.baseCurrencyAmount = baseCurrencyAmount;
            return this;
        }

        public final InvoiceCurrencyAmount.Builder getTaxCurrencyAmount() {
            return taxCurrencyAmount != null ? taxCurrencyAmount.toBuilder() : null;
        }

        public final void setTaxCurrencyAmount(InvoiceCurrencyAmount.BuilderImpl taxCurrencyAmount) {
            this.taxCurrencyAmount = taxCurrencyAmount != null ? taxCurrencyAmount.build() : null;
        }

        @Override
        public final Builder taxCurrencyAmount(InvoiceCurrencyAmount taxCurrencyAmount) {
            this.taxCurrencyAmount = taxCurrencyAmount;
            return this;
        }

        public final InvoiceCurrencyAmount.Builder getPaymentCurrencyAmount() {
            return paymentCurrencyAmount != null ? paymentCurrencyAmount.toBuilder() : null;
        }

        public final void setPaymentCurrencyAmount(InvoiceCurrencyAmount.BuilderImpl paymentCurrencyAmount) {
            this.paymentCurrencyAmount = paymentCurrencyAmount != null ? paymentCurrencyAmount.build() : null;
        }

        @Override
        public final Builder paymentCurrencyAmount(InvoiceCurrencyAmount paymentCurrencyAmount) {
            this.paymentCurrencyAmount = paymentCurrencyAmount;
            return this;
        }

        @Override
        public InvoiceSummary build() {
            return new InvoiceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
