/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProcurementPortalPreferenceResponse extends InvoicingResponse implements
        ToCopyableBuilder<GetProcurementPortalPreferenceResponse.Builder, GetProcurementPortalPreferenceResponse> {
    private static final SdkField<ProcurementPortalPreference> PROCUREMENT_PORTAL_PREFERENCE_FIELD = SdkField
            .<ProcurementPortalPreference> builder(MarshallingType.SDK_POJO)
            .memberName("ProcurementPortalPreference")
            .getter(getter(GetProcurementPortalPreferenceResponse::procurementPortalPreference))
            .setter(setter(Builder::procurementPortalPreference))
            .constructor(ProcurementPortalPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcurementPortalPreference")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PROCUREMENT_PORTAL_PREFERENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ProcurementPortalPreference procurementPortalPreference;

    private GetProcurementPortalPreferenceResponse(BuilderImpl builder) {
        super(builder);
        this.procurementPortalPreference = builder.procurementPortalPreference;
    }

    /**
     * <p>
     * The detailed configuration of the requested procurement portal preference.
     * </p>
     * 
     * @return The detailed configuration of the requested procurement portal preference.
     */
    public final ProcurementPortalPreference procurementPortalPreference() {
        return procurementPortalPreference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(procurementPortalPreference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProcurementPortalPreferenceResponse)) {
            return false;
        }
        GetProcurementPortalPreferenceResponse other = (GetProcurementPortalPreferenceResponse) obj;
        return Objects.equals(procurementPortalPreference(), other.procurementPortalPreference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProcurementPortalPreferenceResponse")
                .add("ProcurementPortalPreference", procurementPortalPreference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcurementPortalPreference":
            return Optional.ofNullable(clazz.cast(procurementPortalPreference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProcurementPortalPreference", PROCUREMENT_PORTAL_PREFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProcurementPortalPreferenceResponse, T> g) {
        return obj -> g.apply((GetProcurementPortalPreferenceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends InvoicingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProcurementPortalPreferenceResponse> {
        /**
         * <p>
         * The detailed configuration of the requested procurement portal preference.
         * </p>
         * 
         * @param procurementPortalPreference
         *        The detailed configuration of the requested procurement portal preference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder procurementPortalPreference(ProcurementPortalPreference procurementPortalPreference);

        /**
         * <p>
         * The detailed configuration of the requested procurement portal preference.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProcurementPortalPreference.Builder}
         * avoiding the need to create one manually via {@link ProcurementPortalPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcurementPortalPreference.Builder#build()} is called
         * immediately and its result is passed to {@link #procurementPortalPreference(ProcurementPortalPreference)}.
         * 
         * @param procurementPortalPreference
         *        a consumer that will call methods on {@link ProcurementPortalPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #procurementPortalPreference(ProcurementPortalPreference)
         */
        default Builder procurementPortalPreference(Consumer<ProcurementPortalPreference.Builder> procurementPortalPreference) {
            return procurementPortalPreference(ProcurementPortalPreference.builder().applyMutation(procurementPortalPreference)
                    .build());
        }
    }

    static final class BuilderImpl extends InvoicingResponse.BuilderImpl implements Builder {
        private ProcurementPortalPreference procurementPortalPreference;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProcurementPortalPreferenceResponse model) {
            super(model);
            procurementPortalPreference(model.procurementPortalPreference);
        }

        public final ProcurementPortalPreference.Builder getProcurementPortalPreference() {
            return procurementPortalPreference != null ? procurementPortalPreference.toBuilder() : null;
        }

        public final void setProcurementPortalPreference(ProcurementPortalPreference.BuilderImpl procurementPortalPreference) {
            this.procurementPortalPreference = procurementPortalPreference != null ? procurementPortalPreference.build() : null;
        }

        @Override
        public final Builder procurementPortalPreference(ProcurementPortalPreference procurementPortalPreference) {
            this.procurementPortalPreference = procurementPortalPreference;
            return this;
        }

        @Override
        public GetProcurementPortalPreferenceResponse build() {
            return new GetProcurementPortalPreferenceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
