/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInvoiceUnitRequest extends InvoicingRequest implements
        ToCopyableBuilder<GetInvoiceUnitRequest.Builder, GetInvoiceUnitRequest> {
    private static final SdkField<String> INVOICE_UNIT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvoiceUnitArn").getter(getter(GetInvoiceUnitRequest::invoiceUnitArn))
            .setter(setter(Builder::invoiceUnitArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceUnitArn").build()).build();

    private static final SdkField<Instant> AS_OF_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("AsOf")
            .getter(getter(GetInvoiceUnitRequest::asOf)).setter(setter(Builder::asOf))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsOf").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOICE_UNIT_ARN_FIELD,
            AS_OF_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String invoiceUnitArn;

    private final Instant asOf;

    private GetInvoiceUnitRequest(BuilderImpl builder) {
        super(builder);
        this.invoiceUnitArn = builder.invoiceUnitArn;
        this.asOf = builder.asOf;
    }

    /**
     * <p>
     * The ARN to identify an invoice unit. This information can't be modified or deleted.
     * </p>
     * 
     * @return The ARN to identify an invoice unit. This information can't be modified or deleted.
     */
    public final String invoiceUnitArn() {
        return invoiceUnitArn;
    }

    /**
     * <p>
     * The state of an invoice unit at a specified time. You can see legacy invoice units that are currently deleted if
     * the <code>AsOf</code> time is set to before it was deleted. If an <code>AsOf</code> is not provided, the default
     * value is the current time.
     * </p>
     * 
     * @return The state of an invoice unit at a specified time. You can see legacy invoice units that are currently
     *         deleted if the <code>AsOf</code> time is set to before it was deleted. If an <code>AsOf</code> is not
     *         provided, the default value is the current time.
     */
    public final Instant asOf() {
        return asOf;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(invoiceUnitArn());
        hashCode = 31 * hashCode + Objects.hashCode(asOf());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInvoiceUnitRequest)) {
            return false;
        }
        GetInvoiceUnitRequest other = (GetInvoiceUnitRequest) obj;
        return Objects.equals(invoiceUnitArn(), other.invoiceUnitArn()) && Objects.equals(asOf(), other.asOf());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInvoiceUnitRequest").add("InvoiceUnitArn", invoiceUnitArn()).add("AsOf", asOf()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvoiceUnitArn":
            return Optional.ofNullable(clazz.cast(invoiceUnitArn()));
        case "AsOf":
            return Optional.ofNullable(clazz.cast(asOf()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InvoiceUnitArn", INVOICE_UNIT_ARN_FIELD);
        map.put("AsOf", AS_OF_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInvoiceUnitRequest, T> g) {
        return obj -> g.apply((GetInvoiceUnitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends InvoicingRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetInvoiceUnitRequest> {
        /**
         * <p>
         * The ARN to identify an invoice unit. This information can't be modified or deleted.
         * </p>
         * 
         * @param invoiceUnitArn
         *        The ARN to identify an invoice unit. This information can't be modified or deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invoiceUnitArn(String invoiceUnitArn);

        /**
         * <p>
         * The state of an invoice unit at a specified time. You can see legacy invoice units that are currently deleted
         * if the <code>AsOf</code> time is set to before it was deleted. If an <code>AsOf</code> is not provided, the
         * default value is the current time.
         * </p>
         * 
         * @param asOf
         *        The state of an invoice unit at a specified time. You can see legacy invoice units that are currently
         *        deleted if the <code>AsOf</code> time is set to before it was deleted. If an <code>AsOf</code> is not
         *        provided, the default value is the current time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asOf(Instant asOf);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InvoicingRequest.BuilderImpl implements Builder {
        private String invoiceUnitArn;

        private Instant asOf;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInvoiceUnitRequest model) {
            super(model);
            invoiceUnitArn(model.invoiceUnitArn);
            asOf(model.asOf);
        }

        public final String getInvoiceUnitArn() {
            return invoiceUnitArn;
        }

        public final void setInvoiceUnitArn(String invoiceUnitArn) {
            this.invoiceUnitArn = invoiceUnitArn;
        }

        @Override
        public final Builder invoiceUnitArn(String invoiceUnitArn) {
            this.invoiceUnitArn = invoiceUnitArn;
            return this;
        }

        public final Instant getAsOf() {
            return asOf;
        }

        public final void setAsOf(Instant asOf) {
            this.asOf = asOf;
        }

        @Override
        public final Builder asOf(Instant asOf) {
            this.asOf = asOf;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInvoiceUnitRequest build() {
            return new GetInvoiceUnitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
