/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of fees.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FeesBreakdown implements SdkPojo, Serializable, ToCopyableBuilder<FeesBreakdown.Builder, FeesBreakdown> {
    private static final SdkField<List<FeesBreakdownAmount>> BREAKDOWN_FIELD = SdkField
            .<List<FeesBreakdownAmount>> builder(MarshallingType.LIST)
            .memberName("Breakdown")
            .getter(getter(FeesBreakdown::breakdown))
            .setter(setter(Builder::breakdown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Breakdown").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeesBreakdownAmount> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeesBreakdownAmount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TOTAL_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TotalAmount").getter(getter(FeesBreakdown::totalAmount)).setter(setter(Builder::totalAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAmount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BREAKDOWN_FIELD,
            TOTAL_AMOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FeesBreakdownAmount> breakdown;

    private final String totalAmount;

    private FeesBreakdown(BuilderImpl builder) {
        this.breakdown = builder.breakdown;
        this.totalAmount = builder.totalAmount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Breakdown property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBreakdown() {
        return breakdown != null && !(breakdown instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of fees information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBreakdown} method.
     * </p>
     * 
     * @return The list of fees information.
     */
    public final List<FeesBreakdownAmount> breakdown() {
        return breakdown;
    }

    /**
     * <p>
     * The total amount of fees.
     * </p>
     * 
     * @return The total amount of fees.
     */
    public final String totalAmount() {
        return totalAmount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBreakdown() ? breakdown() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalAmount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeesBreakdown)) {
            return false;
        }
        FeesBreakdown other = (FeesBreakdown) obj;
        return hasBreakdown() == other.hasBreakdown() && Objects.equals(breakdown(), other.breakdown())
                && Objects.equals(totalAmount(), other.totalAmount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FeesBreakdown").add("Breakdown", hasBreakdown() ? breakdown() : null)
                .add("TotalAmount", totalAmount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Breakdown":
            return Optional.ofNullable(clazz.cast(breakdown()));
        case "TotalAmount":
            return Optional.ofNullable(clazz.cast(totalAmount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Breakdown", BREAKDOWN_FIELD);
        map.put("TotalAmount", TOTAL_AMOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FeesBreakdown, T> g) {
        return obj -> g.apply((FeesBreakdown) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FeesBreakdown> {
        /**
         * <p>
         * The list of fees information.
         * </p>
         * 
         * @param breakdown
         *        The list of fees information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder breakdown(Collection<FeesBreakdownAmount> breakdown);

        /**
         * <p>
         * The list of fees information.
         * </p>
         * 
         * @param breakdown
         *        The list of fees information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder breakdown(FeesBreakdownAmount... breakdown);

        /**
         * <p>
         * The list of fees information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.invoicing.model.FeesBreakdownAmount.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.invoicing.model.FeesBreakdownAmount#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.invoicing.model.FeesBreakdownAmount.Builder#build()} is called
         * immediately and its result is passed to {@link #breakdown(List<FeesBreakdownAmount>)}.
         * 
         * @param breakdown
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.invoicing.model.FeesBreakdownAmount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #breakdown(java.util.Collection<FeesBreakdownAmount>)
         */
        Builder breakdown(Consumer<FeesBreakdownAmount.Builder>... breakdown);

        /**
         * <p>
         * The total amount of fees.
         * </p>
         * 
         * @param totalAmount
         *        The total amount of fees.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAmount(String totalAmount);
    }

    static final class BuilderImpl implements Builder {
        private List<FeesBreakdownAmount> breakdown = DefaultSdkAutoConstructList.getInstance();

        private String totalAmount;

        private BuilderImpl() {
        }

        private BuilderImpl(FeesBreakdown model) {
            breakdown(model.breakdown);
            totalAmount(model.totalAmount);
        }

        public final List<FeesBreakdownAmount.Builder> getBreakdown() {
            List<FeesBreakdownAmount.Builder> result = FeesBreakdownAmountListCopier.copyToBuilder(this.breakdown);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBreakdown(Collection<FeesBreakdownAmount.BuilderImpl> breakdown) {
            this.breakdown = FeesBreakdownAmountListCopier.copyFromBuilder(breakdown);
        }

        @Override
        public final Builder breakdown(Collection<FeesBreakdownAmount> breakdown) {
            this.breakdown = FeesBreakdownAmountListCopier.copy(breakdown);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder breakdown(FeesBreakdownAmount... breakdown) {
            breakdown(Arrays.asList(breakdown));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder breakdown(Consumer<FeesBreakdownAmount.Builder>... breakdown) {
            breakdown(Stream.of(breakdown).map(c -> FeesBreakdownAmount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTotalAmount() {
            return totalAmount;
        }

        public final void setTotalAmount(String totalAmount) {
            this.totalAmount = totalAmount;
        }

        @Override
        public final Builder totalAmount(String totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        @Override
        public FeesBreakdown build() {
            return new FeesBreakdown(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
