/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the preferences for e-invoice delivery, including document types, attachment types, and customization
 * settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EinvoiceDeliveryPreference implements SdkPojo, Serializable,
        ToCopyableBuilder<EinvoiceDeliveryPreference.Builder, EinvoiceDeliveryPreference> {
    private static final SdkField<List<String>> EINVOICE_DELIVERY_DOCUMENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EinvoiceDeliveryDocumentTypes")
            .getter(getter(EinvoiceDeliveryPreference::einvoiceDeliveryDocumentTypesAsStrings))
            .setter(setter(Builder::einvoiceDeliveryDocumentTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryDocumentTypes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EINVOICE_DELIVERY_ATTACHMENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EinvoiceDeliveryAttachmentTypes")
            .getter(getter(EinvoiceDeliveryPreference::einvoiceDeliveryAttachmentTypesAsStrings))
            .setter(setter(Builder::einvoiceDeliveryAttachmentTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryAttachmentTypes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(EinvoiceDeliveryPreference::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<List<PurchaseOrderDataSource>> PURCHASE_ORDER_DATA_SOURCES_FIELD = SdkField
            .<List<PurchaseOrderDataSource>> builder(MarshallingType.LIST)
            .memberName("PurchaseOrderDataSources")
            .getter(getter(EinvoiceDeliveryPreference::purchaseOrderDataSources))
            .setter(setter(Builder::purchaseOrderDataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseOrderDataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PurchaseOrderDataSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(PurchaseOrderDataSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECTION_TESTING_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionTestingMethod").getter(getter(EinvoiceDeliveryPreference::connectionTestingMethodAsString))
            .setter(setter(Builder::connectionTestingMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTestingMethod").build())
            .build();

    private static final SdkField<Instant> EINVOICE_DELIVERY_ACTIVATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EinvoiceDeliveryActivationDate")
            .getter(getter(EinvoiceDeliveryPreference::einvoiceDeliveryActivationDate))
            .setter(setter(Builder::einvoiceDeliveryActivationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EinvoiceDeliveryActivationDate")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EINVOICE_DELIVERY_DOCUMENT_TYPES_FIELD, EINVOICE_DELIVERY_ATTACHMENT_TYPES_FIELD, PROTOCOL_FIELD,
            PURCHASE_ORDER_DATA_SOURCES_FIELD, CONNECTION_TESTING_METHOD_FIELD, EINVOICE_DELIVERY_ACTIVATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> einvoiceDeliveryDocumentTypes;

    private final List<String> einvoiceDeliveryAttachmentTypes;

    private final String protocol;

    private final List<PurchaseOrderDataSource> purchaseOrderDataSources;

    private final String connectionTestingMethod;

    private final Instant einvoiceDeliveryActivationDate;

    private EinvoiceDeliveryPreference(BuilderImpl builder) {
        this.einvoiceDeliveryDocumentTypes = builder.einvoiceDeliveryDocumentTypes;
        this.einvoiceDeliveryAttachmentTypes = builder.einvoiceDeliveryAttachmentTypes;
        this.protocol = builder.protocol;
        this.purchaseOrderDataSources = builder.purchaseOrderDataSources;
        this.connectionTestingMethod = builder.connectionTestingMethod;
        this.einvoiceDeliveryActivationDate = builder.einvoiceDeliveryActivationDate;
    }

    /**
     * <p>
     * The types of e-invoice documents to be delivered.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEinvoiceDeliveryDocumentTypes} method.
     * </p>
     * 
     * @return The types of e-invoice documents to be delivered.
     */
    public final List<EinvoiceDeliveryDocumentType> einvoiceDeliveryDocumentTypes() {
        return EinvoiceDeliveryDocumentTypesCopier.copyStringToEnum(einvoiceDeliveryDocumentTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the EinvoiceDeliveryDocumentTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEinvoiceDeliveryDocumentTypes() {
        return einvoiceDeliveryDocumentTypes != null && !(einvoiceDeliveryDocumentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of e-invoice documents to be delivered.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEinvoiceDeliveryDocumentTypes} method.
     * </p>
     * 
     * @return The types of e-invoice documents to be delivered.
     */
    public final List<String> einvoiceDeliveryDocumentTypesAsStrings() {
        return einvoiceDeliveryDocumentTypes;
    }

    /**
     * <p>
     * The types of attachments to include with the e-invoice delivery.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEinvoiceDeliveryAttachmentTypes}
     * method.
     * </p>
     * 
     * @return The types of attachments to include with the e-invoice delivery.
     */
    public final List<EinvoiceDeliveryAttachmentType> einvoiceDeliveryAttachmentTypes() {
        return EinvoiceDeliveryAttachmentTypesCopier.copyStringToEnum(einvoiceDeliveryAttachmentTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the EinvoiceDeliveryAttachmentTypes
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasEinvoiceDeliveryAttachmentTypes() {
        return einvoiceDeliveryAttachmentTypes != null && !(einvoiceDeliveryAttachmentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of attachments to include with the e-invoice delivery.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEinvoiceDeliveryAttachmentTypes}
     * method.
     * </p>
     * 
     * @return The types of attachments to include with the e-invoice delivery.
     */
    public final List<String> einvoiceDeliveryAttachmentTypesAsStrings() {
        return einvoiceDeliveryAttachmentTypes;
    }

    /**
     * <p>
     * The communication protocol to use for e-invoice delivery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The communication protocol to use for e-invoice delivery.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * <p>
     * The communication protocol to use for e-invoice delivery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The communication protocol to use for e-invoice delivery.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * For responses, this returns true if the service returned a value for the PurchaseOrderDataSources property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPurchaseOrderDataSources() {
        return purchaseOrderDataSources != null && !(purchaseOrderDataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sources of purchase order data to use for e-invoice generation and delivery.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPurchaseOrderDataSources} method.
     * </p>
     * 
     * @return The sources of purchase order data to use for e-invoice generation and delivery.
     */
    public final List<PurchaseOrderDataSource> purchaseOrderDataSources() {
        return purchaseOrderDataSources;
    }

    /**
     * <p>
     * The method to use for testing the connection to the procurement portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectionTestingMethod} will return {@link ConnectionTestingMethod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #connectionTestingMethodAsString}.
     * </p>
     * 
     * @return The method to use for testing the connection to the procurement portal.
     * @see ConnectionTestingMethod
     */
    public final ConnectionTestingMethod connectionTestingMethod() {
        return ConnectionTestingMethod.fromValue(connectionTestingMethod);
    }

    /**
     * <p>
     * The method to use for testing the connection to the procurement portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectionTestingMethod} will return {@link ConnectionTestingMethod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #connectionTestingMethodAsString}.
     * </p>
     * 
     * @return The method to use for testing the connection to the procurement portal.
     * @see ConnectionTestingMethod
     */
    public final String connectionTestingMethodAsString() {
        return connectionTestingMethod;
    }

    /**
     * <p>
     * The date when e-invoice delivery should be activated for this preference.
     * </p>
     * 
     * @return The date when e-invoice delivery should be activated for this preference.
     */
    public final Instant einvoiceDeliveryActivationDate() {
        return einvoiceDeliveryActivationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasEinvoiceDeliveryDocumentTypes() ? einvoiceDeliveryDocumentTypesAsStrings() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasEinvoiceDeliveryAttachmentTypes() ? einvoiceDeliveryAttachmentTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPurchaseOrderDataSources() ? purchaseOrderDataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionTestingMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(einvoiceDeliveryActivationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EinvoiceDeliveryPreference)) {
            return false;
        }
        EinvoiceDeliveryPreference other = (EinvoiceDeliveryPreference) obj;
        return hasEinvoiceDeliveryDocumentTypes() == other.hasEinvoiceDeliveryDocumentTypes()
                && Objects.equals(einvoiceDeliveryDocumentTypesAsStrings(), other.einvoiceDeliveryDocumentTypesAsStrings())
                && hasEinvoiceDeliveryAttachmentTypes() == other.hasEinvoiceDeliveryAttachmentTypes()
                && Objects.equals(einvoiceDeliveryAttachmentTypesAsStrings(), other.einvoiceDeliveryAttachmentTypesAsStrings())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && hasPurchaseOrderDataSources() == other.hasPurchaseOrderDataSources()
                && Objects.equals(purchaseOrderDataSources(), other.purchaseOrderDataSources())
                && Objects.equals(connectionTestingMethodAsString(), other.connectionTestingMethodAsString())
                && Objects.equals(einvoiceDeliveryActivationDate(), other.einvoiceDeliveryActivationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("EinvoiceDeliveryPreference")
                .add("EinvoiceDeliveryDocumentTypes",
                        hasEinvoiceDeliveryDocumentTypes() ? einvoiceDeliveryDocumentTypesAsStrings() : null)
                .add("EinvoiceDeliveryAttachmentTypes",
                        hasEinvoiceDeliveryAttachmentTypes() ? einvoiceDeliveryAttachmentTypesAsStrings() : null)
                .add("Protocol", protocolAsString())
                .add("PurchaseOrderDataSources", hasPurchaseOrderDataSources() ? purchaseOrderDataSources() : null)
                .add("ConnectionTestingMethod", connectionTestingMethodAsString())
                .add("EinvoiceDeliveryActivationDate", einvoiceDeliveryActivationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EinvoiceDeliveryDocumentTypes":
            return Optional.ofNullable(clazz.cast(einvoiceDeliveryDocumentTypesAsStrings()));
        case "EinvoiceDeliveryAttachmentTypes":
            return Optional.ofNullable(clazz.cast(einvoiceDeliveryAttachmentTypesAsStrings()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "PurchaseOrderDataSources":
            return Optional.ofNullable(clazz.cast(purchaseOrderDataSources()));
        case "ConnectionTestingMethod":
            return Optional.ofNullable(clazz.cast(connectionTestingMethodAsString()));
        case "EinvoiceDeliveryActivationDate":
            return Optional.ofNullable(clazz.cast(einvoiceDeliveryActivationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EinvoiceDeliveryDocumentTypes", EINVOICE_DELIVERY_DOCUMENT_TYPES_FIELD);
        map.put("EinvoiceDeliveryAttachmentTypes", EINVOICE_DELIVERY_ATTACHMENT_TYPES_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("PurchaseOrderDataSources", PURCHASE_ORDER_DATA_SOURCES_FIELD);
        map.put("ConnectionTestingMethod", CONNECTION_TESTING_METHOD_FIELD);
        map.put("EinvoiceDeliveryActivationDate", EINVOICE_DELIVERY_ACTIVATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EinvoiceDeliveryPreference, T> g) {
        return obj -> g.apply((EinvoiceDeliveryPreference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EinvoiceDeliveryPreference> {
        /**
         * <p>
         * The types of e-invoice documents to be delivered.
         * </p>
         * 
         * @param einvoiceDeliveryDocumentTypes
         *        The types of e-invoice documents to be delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryDocumentTypesWithStrings(Collection<String> einvoiceDeliveryDocumentTypes);

        /**
         * <p>
         * The types of e-invoice documents to be delivered.
         * </p>
         * 
         * @param einvoiceDeliveryDocumentTypes
         *        The types of e-invoice documents to be delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryDocumentTypesWithStrings(String... einvoiceDeliveryDocumentTypes);

        /**
         * <p>
         * The types of e-invoice documents to be delivered.
         * </p>
         * 
         * @param einvoiceDeliveryDocumentTypes
         *        The types of e-invoice documents to be delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryDocumentTypes(Collection<EinvoiceDeliveryDocumentType> einvoiceDeliveryDocumentTypes);

        /**
         * <p>
         * The types of e-invoice documents to be delivered.
         * </p>
         * 
         * @param einvoiceDeliveryDocumentTypes
         *        The types of e-invoice documents to be delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryDocumentTypes(EinvoiceDeliveryDocumentType... einvoiceDeliveryDocumentTypes);

        /**
         * <p>
         * The types of attachments to include with the e-invoice delivery.
         * </p>
         * 
         * @param einvoiceDeliveryAttachmentTypes
         *        The types of attachments to include with the e-invoice delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryAttachmentTypesWithStrings(Collection<String> einvoiceDeliveryAttachmentTypes);

        /**
         * <p>
         * The types of attachments to include with the e-invoice delivery.
         * </p>
         * 
         * @param einvoiceDeliveryAttachmentTypes
         *        The types of attachments to include with the e-invoice delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryAttachmentTypesWithStrings(String... einvoiceDeliveryAttachmentTypes);

        /**
         * <p>
         * The types of attachments to include with the e-invoice delivery.
         * </p>
         * 
         * @param einvoiceDeliveryAttachmentTypes
         *        The types of attachments to include with the e-invoice delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryAttachmentTypes(Collection<EinvoiceDeliveryAttachmentType> einvoiceDeliveryAttachmentTypes);

        /**
         * <p>
         * The types of attachments to include with the e-invoice delivery.
         * </p>
         * 
         * @param einvoiceDeliveryAttachmentTypes
         *        The types of attachments to include with the e-invoice delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryAttachmentTypes(EinvoiceDeliveryAttachmentType... einvoiceDeliveryAttachmentTypes);

        /**
         * <p>
         * The communication protocol to use for e-invoice delivery.
         * </p>
         * 
         * @param protocol
         *        The communication protocol to use for e-invoice delivery.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The communication protocol to use for e-invoice delivery.
         * </p>
         * 
         * @param protocol
         *        The communication protocol to use for e-invoice delivery.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * <p>
         * The sources of purchase order data to use for e-invoice generation and delivery.
         * </p>
         * 
         * @param purchaseOrderDataSources
         *        The sources of purchase order data to use for e-invoice generation and delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseOrderDataSources(Collection<PurchaseOrderDataSource> purchaseOrderDataSources);

        /**
         * <p>
         * The sources of purchase order data to use for e-invoice generation and delivery.
         * </p>
         * 
         * @param purchaseOrderDataSources
         *        The sources of purchase order data to use for e-invoice generation and delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseOrderDataSources(PurchaseOrderDataSource... purchaseOrderDataSources);

        /**
         * <p>
         * The sources of purchase order data to use for e-invoice generation and delivery.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.invoicing.model.PurchaseOrderDataSource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.invoicing.model.PurchaseOrderDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.invoicing.model.PurchaseOrderDataSource.Builder#build()} is called
         * immediately and its result is passed to {@link #purchaseOrderDataSources(List<PurchaseOrderDataSource>)}.
         * 
         * @param purchaseOrderDataSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.invoicing.model.PurchaseOrderDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #purchaseOrderDataSources(java.util.Collection<PurchaseOrderDataSource>)
         */
        Builder purchaseOrderDataSources(Consumer<PurchaseOrderDataSource.Builder>... purchaseOrderDataSources);

        /**
         * <p>
         * The method to use for testing the connection to the procurement portal.
         * </p>
         * 
         * @param connectionTestingMethod
         *        The method to use for testing the connection to the procurement portal.
         * @see ConnectionTestingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionTestingMethod
         */
        Builder connectionTestingMethod(String connectionTestingMethod);

        /**
         * <p>
         * The method to use for testing the connection to the procurement portal.
         * </p>
         * 
         * @param connectionTestingMethod
         *        The method to use for testing the connection to the procurement portal.
         * @see ConnectionTestingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionTestingMethod
         */
        Builder connectionTestingMethod(ConnectionTestingMethod connectionTestingMethod);

        /**
         * <p>
         * The date when e-invoice delivery should be activated for this preference.
         * </p>
         * 
         * @param einvoiceDeliveryActivationDate
         *        The date when e-invoice delivery should be activated for this preference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder einvoiceDeliveryActivationDate(Instant einvoiceDeliveryActivationDate);
    }

    static final class BuilderImpl implements Builder {
        private List<String> einvoiceDeliveryDocumentTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> einvoiceDeliveryAttachmentTypes = DefaultSdkAutoConstructList.getInstance();

        private String protocol;

        private List<PurchaseOrderDataSource> purchaseOrderDataSources = DefaultSdkAutoConstructList.getInstance();

        private String connectionTestingMethod;

        private Instant einvoiceDeliveryActivationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(EinvoiceDeliveryPreference model) {
            einvoiceDeliveryDocumentTypesWithStrings(model.einvoiceDeliveryDocumentTypes);
            einvoiceDeliveryAttachmentTypesWithStrings(model.einvoiceDeliveryAttachmentTypes);
            protocol(model.protocol);
            purchaseOrderDataSources(model.purchaseOrderDataSources);
            connectionTestingMethod(model.connectionTestingMethod);
            einvoiceDeliveryActivationDate(model.einvoiceDeliveryActivationDate);
        }

        public final Collection<String> getEinvoiceDeliveryDocumentTypes() {
            if (einvoiceDeliveryDocumentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return einvoiceDeliveryDocumentTypes;
        }

        public final void setEinvoiceDeliveryDocumentTypes(Collection<String> einvoiceDeliveryDocumentTypes) {
            this.einvoiceDeliveryDocumentTypes = EinvoiceDeliveryDocumentTypesCopier.copy(einvoiceDeliveryDocumentTypes);
        }

        @Override
        public final Builder einvoiceDeliveryDocumentTypesWithStrings(Collection<String> einvoiceDeliveryDocumentTypes) {
            this.einvoiceDeliveryDocumentTypes = EinvoiceDeliveryDocumentTypesCopier.copy(einvoiceDeliveryDocumentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder einvoiceDeliveryDocumentTypesWithStrings(String... einvoiceDeliveryDocumentTypes) {
            einvoiceDeliveryDocumentTypesWithStrings(Arrays.asList(einvoiceDeliveryDocumentTypes));
            return this;
        }

        @Override
        public final Builder einvoiceDeliveryDocumentTypes(Collection<EinvoiceDeliveryDocumentType> einvoiceDeliveryDocumentTypes) {
            this.einvoiceDeliveryDocumentTypes = EinvoiceDeliveryDocumentTypesCopier
                    .copyEnumToString(einvoiceDeliveryDocumentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder einvoiceDeliveryDocumentTypes(EinvoiceDeliveryDocumentType... einvoiceDeliveryDocumentTypes) {
            einvoiceDeliveryDocumentTypes(Arrays.asList(einvoiceDeliveryDocumentTypes));
            return this;
        }

        public final Collection<String> getEinvoiceDeliveryAttachmentTypes() {
            if (einvoiceDeliveryAttachmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return einvoiceDeliveryAttachmentTypes;
        }

        public final void setEinvoiceDeliveryAttachmentTypes(Collection<String> einvoiceDeliveryAttachmentTypes) {
            this.einvoiceDeliveryAttachmentTypes = EinvoiceDeliveryAttachmentTypesCopier.copy(einvoiceDeliveryAttachmentTypes);
        }

        @Override
        public final Builder einvoiceDeliveryAttachmentTypesWithStrings(Collection<String> einvoiceDeliveryAttachmentTypes) {
            this.einvoiceDeliveryAttachmentTypes = EinvoiceDeliveryAttachmentTypesCopier.copy(einvoiceDeliveryAttachmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder einvoiceDeliveryAttachmentTypesWithStrings(String... einvoiceDeliveryAttachmentTypes) {
            einvoiceDeliveryAttachmentTypesWithStrings(Arrays.asList(einvoiceDeliveryAttachmentTypes));
            return this;
        }

        @Override
        public final Builder einvoiceDeliveryAttachmentTypes(
                Collection<EinvoiceDeliveryAttachmentType> einvoiceDeliveryAttachmentTypes) {
            this.einvoiceDeliveryAttachmentTypes = EinvoiceDeliveryAttachmentTypesCopier
                    .copyEnumToString(einvoiceDeliveryAttachmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder einvoiceDeliveryAttachmentTypes(EinvoiceDeliveryAttachmentType... einvoiceDeliveryAttachmentTypes) {
            einvoiceDeliveryAttachmentTypes(Arrays.asList(einvoiceDeliveryAttachmentTypes));
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final List<PurchaseOrderDataSource.Builder> getPurchaseOrderDataSources() {
            List<PurchaseOrderDataSource.Builder> result = PurchaseOrderDataSourcesCopier
                    .copyToBuilder(this.purchaseOrderDataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPurchaseOrderDataSources(Collection<PurchaseOrderDataSource.BuilderImpl> purchaseOrderDataSources) {
            this.purchaseOrderDataSources = PurchaseOrderDataSourcesCopier.copyFromBuilder(purchaseOrderDataSources);
        }

        @Override
        public final Builder purchaseOrderDataSources(Collection<PurchaseOrderDataSource> purchaseOrderDataSources) {
            this.purchaseOrderDataSources = PurchaseOrderDataSourcesCopier.copy(purchaseOrderDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseOrderDataSources(PurchaseOrderDataSource... purchaseOrderDataSources) {
            purchaseOrderDataSources(Arrays.asList(purchaseOrderDataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseOrderDataSources(Consumer<PurchaseOrderDataSource.Builder>... purchaseOrderDataSources) {
            purchaseOrderDataSources(Stream.of(purchaseOrderDataSources)
                    .map(c -> PurchaseOrderDataSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConnectionTestingMethod() {
            return connectionTestingMethod;
        }

        public final void setConnectionTestingMethod(String connectionTestingMethod) {
            this.connectionTestingMethod = connectionTestingMethod;
        }

        @Override
        public final Builder connectionTestingMethod(String connectionTestingMethod) {
            this.connectionTestingMethod = connectionTestingMethod;
            return this;
        }

        @Override
        public final Builder connectionTestingMethod(ConnectionTestingMethod connectionTestingMethod) {
            this.connectionTestingMethod(connectionTestingMethod == null ? null : connectionTestingMethod.toString());
            return this;
        }

        public final Instant getEinvoiceDeliveryActivationDate() {
            return einvoiceDeliveryActivationDate;
        }

        public final void setEinvoiceDeliveryActivationDate(Instant einvoiceDeliveryActivationDate) {
            this.einvoiceDeliveryActivationDate = einvoiceDeliveryActivationDate;
        }

        @Override
        public final Builder einvoiceDeliveryActivationDate(Instant einvoiceDeliveryActivationDate) {
            this.einvoiceDeliveryActivationDate = einvoiceDeliveryActivationDate;
            return this;
        }

        @Override
        public EinvoiceDeliveryPreference build() {
            return new EinvoiceDeliveryPreference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
