/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The time period that you want invoice-related documents for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateInterval implements SdkPojo, Serializable, ToCopyableBuilder<DateInterval.Builder, DateInterval> {
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate").getter(getter(DateInterval::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate").getter(getter(DateInterval::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_DATE_FIELD,
            END_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant startDate;

    private final Instant endDate;

    private DateInterval(BuilderImpl builder) {
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
    }

    /**
     * <p>
     * The beginning of the time period that you want invoice-related documents for. The start date is inclusive. For
     * example, if <code>start</code> is <code>2019-01-01</code>, AWS retrieves invoices starting at
     * <code>2019-01-01</code> up to the end date.
     * </p>
     * 
     * @return The beginning of the time period that you want invoice-related documents for. The start date is
     *         inclusive. For example, if <code>start</code> is <code>2019-01-01</code>, AWS retrieves invoices starting
     *         at <code>2019-01-01</code> up to the end date.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The end of the time period that you want invoice-related documents for. The end date is exclusive. For example,
     * if <code>end</code> is <code>2019-01-10</code>, Amazon Web Services retrieves invoice-related documents from the
     * start date up to, but not including, <code>2018-01-10</code>.
     * </p>
     * 
     * @return The end of the time period that you want invoice-related documents for. The end date is exclusive. For
     *         example, if <code>end</code> is <code>2019-01-10</code>, Amazon Web Services retrieves invoice-related
     *         documents from the start date up to, but not including, <code>2018-01-10</code>.
     */
    public final Instant endDate() {
        return endDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateInterval)) {
            return false;
        }
        DateInterval other = (DateInterval) obj;
        return Objects.equals(startDate(), other.startDate()) && Objects.equals(endDate(), other.endDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateInterval").add("StartDate", startDate()).add("EndDate", endDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartDate", START_DATE_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DateInterval, T> g) {
        return obj -> g.apply((DateInterval) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateInterval> {
        /**
         * <p>
         * The beginning of the time period that you want invoice-related documents for. The start date is inclusive.
         * For example, if <code>start</code> is <code>2019-01-01</code>, AWS retrieves invoices starting at
         * <code>2019-01-01</code> up to the end date.
         * </p>
         * 
         * @param startDate
         *        The beginning of the time period that you want invoice-related documents for. The start date is
         *        inclusive. For example, if <code>start</code> is <code>2019-01-01</code>, AWS retrieves invoices
         *        starting at <code>2019-01-01</code> up to the end date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The end of the time period that you want invoice-related documents for. The end date is exclusive. For
         * example, if <code>end</code> is <code>2019-01-10</code>, Amazon Web Services retrieves invoice-related
         * documents from the start date up to, but not including, <code>2018-01-10</code>.
         * </p>
         * 
         * @param endDate
         *        The end of the time period that you want invoice-related documents for. The end date is exclusive. For
         *        example, if <code>end</code> is <code>2019-01-10</code>, Amazon Web Services retrieves invoice-related
         *        documents from the start date up to, but not including, <code>2018-01-10</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);
    }

    static final class BuilderImpl implements Builder {
        private Instant startDate;

        private Instant endDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DateInterval model) {
            startDate(model.startDate);
            endDate(model.endDate);
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        @Override
        public DateInterval build() {
            return new DateInterval(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
