/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InvoiceType {
    INVOICE("INVOICE"),
    CREDIT_MEMO("CREDIT_MEMO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InvoiceType> VALUE_MAP;
    private final String value;

    private InvoiceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InvoiceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InvoiceType> knownValues() {
        EnumSet<InvoiceType> knownValues = EnumSet.allOf(InvoiceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InvoiceType.class, InvoiceType::toString);
    }
}

