/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.invoicing.model.BillingPeriod;
import software.amazon.awssdk.services.invoicing.model.DateInterval;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvoiceSummariesFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvoiceSummariesFilter> {
    private static final SdkField<DateInterval> TIME_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeInterval").getter(InvoiceSummariesFilter.getter(InvoiceSummariesFilter::timeInterval)).setter(InvoiceSummariesFilter.setter(Builder::timeInterval)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeInterval").build()}).build();
    private static final SdkField<BillingPeriod> BILLING_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BillingPeriod").getter(InvoiceSummariesFilter.getter(InvoiceSummariesFilter::billingPeriod)).setter(InvoiceSummariesFilter.setter(Builder::billingPeriod)).constructor(BillingPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriod").build()}).build();
    private static final SdkField<String> INVOICING_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvoicingEntity").getter(InvoiceSummariesFilter.getter(InvoiceSummariesFilter::invoicingEntity)).setter(InvoiceSummariesFilter.setter(Builder::invoicingEntity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoicingEntity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_INTERVAL_FIELD, BILLING_PERIOD_FIELD, INVOICING_ENTITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvoiceSummariesFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DateInterval timeInterval;
    private final BillingPeriod billingPeriod;
    private final String invoicingEntity;

    private InvoiceSummariesFilter(BuilderImpl builder) {
        this.timeInterval = builder.timeInterval;
        this.billingPeriod = builder.billingPeriod;
        this.invoicingEntity = builder.invoicingEntity;
    }

    public final DateInterval timeInterval() {
        return this.timeInterval;
    }

    public final BillingPeriod billingPeriod() {
        return this.billingPeriod;
    }

    public final String invoicingEntity() {
        return this.invoicingEntity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.invoicingEntity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvoiceSummariesFilter)) {
            return false;
        }
        InvoiceSummariesFilter other = (InvoiceSummariesFilter)obj;
        return Objects.equals(this.timeInterval(), other.timeInterval()) && Objects.equals(this.billingPeriod(), other.billingPeriod()) && Objects.equals(this.invoicingEntity(), other.invoicingEntity());
    }

    public final String toString() {
        return ToString.builder((String)"InvoiceSummariesFilter").add("TimeInterval", (Object)this.timeInterval()).add("BillingPeriod", (Object)this.billingPeriod()).add("InvoicingEntity", (Object)this.invoicingEntity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeInterval": {
                return Optional.ofNullable(clazz.cast(this.timeInterval()));
            }
            case "BillingPeriod": {
                return Optional.ofNullable(clazz.cast(this.billingPeriod()));
            }
            case "InvoicingEntity": {
                return Optional.ofNullable(clazz.cast(this.invoicingEntity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TimeInterval", TIME_INTERVAL_FIELD);
        map.put("BillingPeriod", BILLING_PERIOD_FIELD);
        map.put("InvoicingEntity", INVOICING_ENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvoiceSummariesFilter, T> g) {
        return obj -> g.apply((InvoiceSummariesFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DateInterval timeInterval;
        private BillingPeriod billingPeriod;
        private String invoicingEntity;

        private BuilderImpl() {
        }

        private BuilderImpl(InvoiceSummariesFilter model) {
            this.timeInterval(model.timeInterval);
            this.billingPeriod(model.billingPeriod);
            this.invoicingEntity(model.invoicingEntity);
        }

        public final DateInterval.Builder getTimeInterval() {
            return this.timeInterval != null ? this.timeInterval.toBuilder() : null;
        }

        public final void setTimeInterval(DateInterval.BuilderImpl timeInterval) {
            this.timeInterval = timeInterval != null ? timeInterval.build() : null;
        }

        @Override
        public final Builder timeInterval(DateInterval timeInterval) {
            this.timeInterval = timeInterval;
            return this;
        }

        public final BillingPeriod.Builder getBillingPeriod() {
            return this.billingPeriod != null ? this.billingPeriod.toBuilder() : null;
        }

        public final void setBillingPeriod(BillingPeriod.BuilderImpl billingPeriod) {
            this.billingPeriod = billingPeriod != null ? billingPeriod.build() : null;
        }

        @Override
        public final Builder billingPeriod(BillingPeriod billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final String getInvoicingEntity() {
            return this.invoicingEntity;
        }

        public final void setInvoicingEntity(String invoicingEntity) {
            this.invoicingEntity = invoicingEntity;
        }

        @Override
        public final Builder invoicingEntity(String invoicingEntity) {
            this.invoicingEntity = invoicingEntity;
            return this;
        }

        public InvoiceSummariesFilter build() {
            return new InvoiceSummariesFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvoiceSummariesFilter> {
        public Builder timeInterval(DateInterval var1);

        default public Builder timeInterval(Consumer<DateInterval.Builder> timeInterval) {
            return this.timeInterval((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timeInterval)).build());
        }

        public Builder billingPeriod(BillingPeriod var1);

        default public Builder billingPeriod(Consumer<BillingPeriod.Builder> billingPeriod) {
            return this.billingPeriod((BillingPeriod)((BillingPeriod.Builder)BillingPeriod.builder().applyMutation(billingPeriod)).build());
        }

        public Builder invoicingEntity(String var1);
    }
}

