/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.invoicing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.invoicing.model.AccountIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvoiceUnitRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvoiceUnitRule> {
    private static final SdkField<List<String>> LINKED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LinkedAccounts").getter(InvoiceUnitRule.getter(InvoiceUnitRule::linkedAccounts)).setter(InvoiceUnitRule.setter(Builder::linkedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINKED_ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LinkedAccounts", LINKED_ACCOUNTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> linkedAccounts;

    private InvoiceUnitRule(BuilderImpl builder) {
        this.linkedAccounts = builder.linkedAccounts;
    }

    public final boolean hasLinkedAccounts() {
        return this.linkedAccounts != null && !(this.linkedAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> linkedAccounts() {
        return this.linkedAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkedAccounts() ? this.linkedAccounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvoiceUnitRule)) {
            return false;
        }
        InvoiceUnitRule other = (InvoiceUnitRule)obj;
        return this.hasLinkedAccounts() == other.hasLinkedAccounts() && Objects.equals(this.linkedAccounts(), other.linkedAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"InvoiceUnitRule").add("LinkedAccounts", this.hasLinkedAccounts() ? this.linkedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LinkedAccounts": {
                return Optional.ofNullable(clazz.cast(this.linkedAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InvoiceUnitRule, T> g) {
        return obj -> g.apply((InvoiceUnitRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> linkedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvoiceUnitRule model) {
            this.linkedAccounts(model.linkedAccounts);
        }

        public final Collection<String> getLinkedAccounts() {
            if (this.linkedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.linkedAccounts;
        }

        public final void setLinkedAccounts(Collection<String> linkedAccounts) {
            this.linkedAccounts = AccountIdListCopier.copy(linkedAccounts);
        }

        @Override
        public final Builder linkedAccounts(Collection<String> linkedAccounts) {
            this.linkedAccounts = AccountIdListCopier.copy(linkedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedAccounts(String ... linkedAccounts) {
            this.linkedAccounts(Arrays.asList(linkedAccounts));
            return this;
        }

        public InvoiceUnitRule build() {
            return new InvoiceUnitRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvoiceUnitRule> {
        public Builder linkedAccounts(Collection<String> var1);

        public Builder linkedAccounts(String ... var1);
    }
}

