/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InternetEventType {
    AVAILABILITY("AVAILABILITY"),
    PERFORMANCE("PERFORMANCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InternetEventType> VALUE_MAP;
    private final String value;

    private InternetEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InternetEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InternetEventType> knownValues() {
        EnumSet<InternetEventType> knownValues = EnumSet.allOf(InternetEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InternetEventType.class, InternetEventType::toString);
    }
}

