/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.internetmonitor.model.FilterParameter;
import software.amazon.awssdk.services.internetmonitor.model.FilterParametersCopier;
import software.amazon.awssdk.services.internetmonitor.model.InternetMonitorRequest;
import software.amazon.awssdk.services.internetmonitor.model.QueryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartQueryRequest
extends InternetMonitorRequest
implements ToCopyableBuilder<Builder, StartQueryRequest> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorName").getter(StartQueryRequest.getter(StartQueryRequest::monitorName)).setter(StartQueryRequest.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MonitorName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(StartQueryRequest.getter(StartQueryRequest::startTime)).setter(StartQueryRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(StartQueryRequest.getter(StartQueryRequest::endTime)).setter(StartQueryRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> QUERY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryType").getter(StartQueryRequest.getter(StartQueryRequest::queryTypeAsString)).setter(StartQueryRequest.setter(Builder::queryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryType").build()}).build();
    private static final SdkField<List<FilterParameter>> FILTER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterParameters").getter(StartQueryRequest.getter(StartQueryRequest::filterParameters)).setter(StartQueryRequest.setter(Builder::filterParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LINKED_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkedAccountId").getter(StartQueryRequest.getter(StartQueryRequest::linkedAccountId)).setter(StartQueryRequest.setter(Builder::linkedAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkedAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, QUERY_TYPE_FIELD, FILTER_PARAMETERS_FIELD, LINKED_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartQueryRequest.memberNameToFieldInitializer();
    private final String monitorName;
    private final Instant startTime;
    private final Instant endTime;
    private final String queryType;
    private final List<FilterParameter> filterParameters;
    private final String linkedAccountId;

    private StartQueryRequest(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.queryType = builder.queryType;
        this.filterParameters = builder.filterParameters;
        this.linkedAccountId = builder.linkedAccountId;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final QueryType queryType() {
        return QueryType.fromValue(this.queryType);
    }

    public final String queryTypeAsString() {
        return this.queryType;
    }

    public final boolean hasFilterParameters() {
        return this.filterParameters != null && !(this.filterParameters instanceof SdkAutoConstructList);
    }

    public final List<FilterParameter> filterParameters() {
        return this.filterParameters;
    }

    public final String linkedAccountId() {
        return this.linkedAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterParameters() ? this.filterParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.linkedAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryRequest)) {
            return false;
        }
        StartQueryRequest other = (StartQueryRequest)((Object)obj);
        return Objects.equals(this.monitorName(), other.monitorName()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.queryTypeAsString(), other.queryTypeAsString()) && this.hasFilterParameters() == other.hasFilterParameters() && Objects.equals(this.filterParameters(), other.filterParameters()) && Objects.equals(this.linkedAccountId(), other.linkedAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"StartQueryRequest").add("MonitorName", (Object)this.monitorName()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("QueryType", (Object)this.queryTypeAsString()).add("FilterParameters", this.hasFilterParameters() ? this.filterParameters() : null).add("LinkedAccountId", (Object)this.linkedAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "QueryType": {
                return Optional.ofNullable(clazz.cast(this.queryTypeAsString()));
            }
            case "FilterParameters": {
                return Optional.ofNullable(clazz.cast(this.filterParameters()));
            }
            case "LinkedAccountId": {
                return Optional.ofNullable(clazz.cast(this.linkedAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MonitorName", MONITOR_NAME_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("QueryType", QUERY_TYPE_FIELD);
        map.put("FilterParameters", FILTER_PARAMETERS_FIELD);
        map.put("LinkedAccountId", LINKED_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartQueryRequest, T> g) {
        return obj -> g.apply((StartQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InternetMonitorRequest.BuilderImpl
    implements Builder {
        private String monitorName;
        private Instant startTime;
        private Instant endTime;
        private String queryType;
        private List<FilterParameter> filterParameters = DefaultSdkAutoConstructList.getInstance();
        private String linkedAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartQueryRequest model) {
            super(model);
            this.monitorName(model.monitorName);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.queryType(model.queryType);
            this.filterParameters(model.filterParameters);
            this.linkedAccountId(model.linkedAccountId);
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getQueryType() {
            return this.queryType;
        }

        public final void setQueryType(String queryType) {
            this.queryType = queryType;
        }

        @Override
        public final Builder queryType(String queryType) {
            this.queryType = queryType;
            return this;
        }

        @Override
        public final Builder queryType(QueryType queryType) {
            this.queryType(queryType == null ? null : queryType.toString());
            return this;
        }

        public final List<FilterParameter.Builder> getFilterParameters() {
            List<FilterParameter.Builder> result = FilterParametersCopier.copyToBuilder(this.filterParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterParameters(Collection<FilterParameter.BuilderImpl> filterParameters) {
            this.filterParameters = FilterParametersCopier.copyFromBuilder(filterParameters);
        }

        @Override
        public final Builder filterParameters(Collection<FilterParameter> filterParameters) {
            this.filterParameters = FilterParametersCopier.copy(filterParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterParameters(FilterParameter ... filterParameters) {
            this.filterParameters(Arrays.asList(filterParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterParameters(Consumer<FilterParameter.Builder> ... filterParameters) {
            this.filterParameters(Stream.of(filterParameters).map(c -> (FilterParameter)((FilterParameter.Builder)FilterParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLinkedAccountId() {
            return this.linkedAccountId;
        }

        public final void setLinkedAccountId(String linkedAccountId) {
            this.linkedAccountId = linkedAccountId;
        }

        @Override
        public final Builder linkedAccountId(String linkedAccountId) {
            this.linkedAccountId = linkedAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartQueryRequest build() {
            return new StartQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends InternetMonitorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartQueryRequest> {
        public Builder monitorName(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder queryType(String var1);

        public Builder queryType(QueryType var1);

        public Builder filterParameters(Collection<FilterParameter> var1);

        public Builder filterParameters(FilterParameter ... var1);

        public Builder filterParameters(Consumer<FilterParameter.Builder> ... var1);

        public Builder linkedAccountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

