/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.internetmonitor.model.InternetMonitorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMonitorRequest
extends InternetMonitorRequest
implements ToCopyableBuilder<Builder, GetMonitorRequest> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorName").getter(GetMonitorRequest.getter(GetMonitorRequest::monitorName)).setter(GetMonitorRequest.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MonitorName").build()}).build();
    private static final SdkField<String> LINKED_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkedAccountId").getter(GetMonitorRequest.getter(GetMonitorRequest::linkedAccountId)).setter(GetMonitorRequest.setter(Builder::linkedAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LinkedAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD, LINKED_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMonitorRequest.memberNameToFieldInitializer();
    private final String monitorName;
    private final String linkedAccountId;

    private GetMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.linkedAccountId = builder.linkedAccountId;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final String linkedAccountId() {
        return this.linkedAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkedAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMonitorRequest)) {
            return false;
        }
        GetMonitorRequest other = (GetMonitorRequest)((Object)obj);
        return Objects.equals(this.monitorName(), other.monitorName()) && Objects.equals(this.linkedAccountId(), other.linkedAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"GetMonitorRequest").add("MonitorName", (Object)this.monitorName()).add("LinkedAccountId", (Object)this.linkedAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "LinkedAccountId": {
                return Optional.ofNullable(clazz.cast(this.linkedAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MonitorName", MONITOR_NAME_FIELD);
        map.put("LinkedAccountId", LINKED_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMonitorRequest, T> g) {
        return obj -> g.apply((GetMonitorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InternetMonitorRequest.BuilderImpl
    implements Builder {
        private String monitorName;
        private String linkedAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMonitorRequest model) {
            super(model);
            this.monitorName(model.monitorName);
            this.linkedAccountId(model.linkedAccountId);
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getLinkedAccountId() {
            return this.linkedAccountId;
        }

        public final void setLinkedAccountId(String linkedAccountId) {
            this.linkedAccountId = linkedAccountId;
        }

        @Override
        public final Builder linkedAccountId(String linkedAccountId) {
            this.linkedAccountId = linkedAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMonitorRequest build() {
            return new GetMonitorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends InternetMonitorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMonitorRequest> {
        public Builder monitorName(String var1);

        public Builder linkedAccountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

