/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.internetmonitor.DefaultInternetMonitorAsyncClientBuilder;
import software.amazon.awssdk.services.internetmonitor.InternetMonitorAsyncClientBuilder;
import software.amazon.awssdk.services.internetmonitor.InternetMonitorServiceClientConfiguration;
import software.amazon.awssdk.services.internetmonitor.model.CreateMonitorRequest;
import software.amazon.awssdk.services.internetmonitor.model.CreateMonitorResponse;
import software.amazon.awssdk.services.internetmonitor.model.DeleteMonitorRequest;
import software.amazon.awssdk.services.internetmonitor.model.DeleteMonitorResponse;
import software.amazon.awssdk.services.internetmonitor.model.GetHealthEventRequest;
import software.amazon.awssdk.services.internetmonitor.model.GetHealthEventResponse;
import software.amazon.awssdk.services.internetmonitor.model.GetMonitorRequest;
import software.amazon.awssdk.services.internetmonitor.model.GetMonitorResponse;
import software.amazon.awssdk.services.internetmonitor.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.internetmonitor.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.internetmonitor.model.GetQueryStatusRequest;
import software.amazon.awssdk.services.internetmonitor.model.GetQueryStatusResponse;
import software.amazon.awssdk.services.internetmonitor.model.ListHealthEventsRequest;
import software.amazon.awssdk.services.internetmonitor.model.ListHealthEventsResponse;
import software.amazon.awssdk.services.internetmonitor.model.ListMonitorsRequest;
import software.amazon.awssdk.services.internetmonitor.model.ListMonitorsResponse;
import software.amazon.awssdk.services.internetmonitor.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.internetmonitor.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.internetmonitor.model.StartQueryRequest;
import software.amazon.awssdk.services.internetmonitor.model.StartQueryResponse;
import software.amazon.awssdk.services.internetmonitor.model.StopQueryRequest;
import software.amazon.awssdk.services.internetmonitor.model.StopQueryResponse;
import software.amazon.awssdk.services.internetmonitor.model.TagResourceRequest;
import software.amazon.awssdk.services.internetmonitor.model.TagResourceResponse;
import software.amazon.awssdk.services.internetmonitor.model.UntagResourceRequest;
import software.amazon.awssdk.services.internetmonitor.model.UntagResourceResponse;
import software.amazon.awssdk.services.internetmonitor.model.UpdateMonitorRequest;
import software.amazon.awssdk.services.internetmonitor.model.UpdateMonitorResponse;
import software.amazon.awssdk.services.internetmonitor.paginators.GetQueryResultsPublisher;
import software.amazon.awssdk.services.internetmonitor.paginators.ListHealthEventsPublisher;
import software.amazon.awssdk.services.internetmonitor.paginators.ListMonitorsPublisher;

@SdkPublicApi
@ThreadSafe
public interface InternetMonitorAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "internetmonitor";
    public static final String SERVICE_METADATA_ID = "internetmonitor";

    default public CompletableFuture<CreateMonitorResponse> createMonitor(CreateMonitorRequest createMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateMonitorResponse> createMonitor(Consumer<CreateMonitorRequest.Builder> createMonitorRequest) {
        return this.createMonitor((CreateMonitorRequest)((Object)((CreateMonitorRequest.Builder)CreateMonitorRequest.builder().applyMutation(createMonitorRequest)).build()));
    }

    default public CompletableFuture<DeleteMonitorResponse> deleteMonitor(DeleteMonitorRequest deleteMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteMonitorResponse> deleteMonitor(Consumer<DeleteMonitorRequest.Builder> deleteMonitorRequest) {
        return this.deleteMonitor((DeleteMonitorRequest)((Object)((DeleteMonitorRequest.Builder)DeleteMonitorRequest.builder().applyMutation(deleteMonitorRequest)).build()));
    }

    default public CompletableFuture<GetHealthEventResponse> getHealthEvent(GetHealthEventRequest getHealthEventRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetHealthEventResponse> getHealthEvent(Consumer<GetHealthEventRequest.Builder> getHealthEventRequest) {
        return this.getHealthEvent((GetHealthEventRequest)((Object)((GetHealthEventRequest.Builder)GetHealthEventRequest.builder().applyMutation(getHealthEventRequest)).build()));
    }

    default public CompletableFuture<GetMonitorResponse> getMonitor(GetMonitorRequest getMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetMonitorResponse> getMonitor(Consumer<GetMonitorRequest.Builder> getMonitorRequest) {
        return this.getMonitor((GetMonitorRequest)((Object)((GetMonitorRequest.Builder)GetMonitorRequest.builder().applyMutation(getMonitorRequest)).build()));
    }

    default public CompletableFuture<GetQueryResultsResponse> getQueryResults(GetQueryResultsRequest getQueryResultsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetQueryResultsResponse> getQueryResults(Consumer<GetQueryResultsRequest.Builder> getQueryResultsRequest) {
        return this.getQueryResults((GetQueryResultsRequest)((Object)((GetQueryResultsRequest.Builder)GetQueryResultsRequest.builder().applyMutation(getQueryResultsRequest)).build()));
    }

    default public GetQueryResultsPublisher getQueryResultsPaginator(GetQueryResultsRequest getQueryResultsRequest) {
        return new GetQueryResultsPublisher(this, getQueryResultsRequest);
    }

    default public GetQueryResultsPublisher getQueryResultsPaginator(Consumer<GetQueryResultsRequest.Builder> getQueryResultsRequest) {
        return this.getQueryResultsPaginator((GetQueryResultsRequest)((Object)((GetQueryResultsRequest.Builder)GetQueryResultsRequest.builder().applyMutation(getQueryResultsRequest)).build()));
    }

    default public CompletableFuture<GetQueryStatusResponse> getQueryStatus(GetQueryStatusRequest getQueryStatusRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetQueryStatusResponse> getQueryStatus(Consumer<GetQueryStatusRequest.Builder> getQueryStatusRequest) {
        return this.getQueryStatus((GetQueryStatusRequest)((Object)((GetQueryStatusRequest.Builder)GetQueryStatusRequest.builder().applyMutation(getQueryStatusRequest)).build()));
    }

    default public CompletableFuture<ListHealthEventsResponse> listHealthEvents(ListHealthEventsRequest listHealthEventsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListHealthEventsResponse> listHealthEvents(Consumer<ListHealthEventsRequest.Builder> listHealthEventsRequest) {
        return this.listHealthEvents((ListHealthEventsRequest)((Object)((ListHealthEventsRequest.Builder)ListHealthEventsRequest.builder().applyMutation(listHealthEventsRequest)).build()));
    }

    default public ListHealthEventsPublisher listHealthEventsPaginator(ListHealthEventsRequest listHealthEventsRequest) {
        return new ListHealthEventsPublisher(this, listHealthEventsRequest);
    }

    default public ListHealthEventsPublisher listHealthEventsPaginator(Consumer<ListHealthEventsRequest.Builder> listHealthEventsRequest) {
        return this.listHealthEventsPaginator((ListHealthEventsRequest)((Object)((ListHealthEventsRequest.Builder)ListHealthEventsRequest.builder().applyMutation(listHealthEventsRequest)).build()));
    }

    default public CompletableFuture<ListMonitorsResponse> listMonitors(ListMonitorsRequest listMonitorsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListMonitorsResponse> listMonitors(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest) {
        return this.listMonitors((ListMonitorsRequest)((Object)((ListMonitorsRequest.Builder)ListMonitorsRequest.builder().applyMutation(listMonitorsRequest)).build()));
    }

    default public ListMonitorsPublisher listMonitorsPaginator(ListMonitorsRequest listMonitorsRequest) {
        return new ListMonitorsPublisher(this, listMonitorsRequest);
    }

    default public ListMonitorsPublisher listMonitorsPaginator(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest) {
        return this.listMonitorsPaginator((ListMonitorsRequest)((Object)((ListMonitorsRequest.Builder)ListMonitorsRequest.builder().applyMutation(listMonitorsRequest)).build()));
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public CompletableFuture<StartQueryResponse> startQuery(StartQueryRequest startQueryRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartQueryResponse> startQuery(Consumer<StartQueryRequest.Builder> startQueryRequest) {
        return this.startQuery((StartQueryRequest)((Object)((StartQueryRequest.Builder)StartQueryRequest.builder().applyMutation(startQueryRequest)).build()));
    }

    default public CompletableFuture<StopQueryResponse> stopQuery(StopQueryRequest stopQueryRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StopQueryResponse> stopQuery(Consumer<StopQueryRequest.Builder> stopQueryRequest) {
        return this.stopQuery((StopQueryRequest)((Object)((StopQueryRequest.Builder)StopQueryRequest.builder().applyMutation(stopQueryRequest)).build()));
    }

    default public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public CompletableFuture<UpdateMonitorResponse> updateMonitor(UpdateMonitorRequest updateMonitorRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpdateMonitorResponse> updateMonitor(Consumer<UpdateMonitorRequest.Builder> updateMonitorRequest) {
        return this.updateMonitor((UpdateMonitorRequest)((Object)((UpdateMonitorRequest.Builder)UpdateMonitorRequest.builder().applyMutation(updateMonitorRequest)).build()));
    }

    default public InternetMonitorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static InternetMonitorAsyncClient create() {
        return (InternetMonitorAsyncClient)InternetMonitorAsyncClient.builder().build();
    }

    public static InternetMonitorAsyncClientBuilder builder() {
        return new DefaultInternetMonitorAsyncClientBuilder();
    }
}

