/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.internetmonitor.DefaultInternetMonitorBaseClientBuilder;
import software.amazon.awssdk.services.internetmonitor.DefaultInternetMonitorClient;
import software.amazon.awssdk.services.internetmonitor.InternetMonitorClient;
import software.amazon.awssdk.services.internetmonitor.InternetMonitorClientBuilder;
import software.amazon.awssdk.services.internetmonitor.InternetMonitorServiceClientConfiguration;
import software.amazon.awssdk.services.internetmonitor.endpoints.InternetMonitorEndpointProvider;

@SdkInternalApi
final class DefaultInternetMonitorClientBuilder
extends DefaultInternetMonitorBaseClientBuilder<InternetMonitorClientBuilder, InternetMonitorClient>
implements InternetMonitorClientBuilder {
    DefaultInternetMonitorClientBuilder() {
    }

    @Override
    public DefaultInternetMonitorClientBuilder endpointProvider(InternetMonitorEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final InternetMonitorClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultInternetMonitorClientBuilder.validateClientOptions(clientConfiguration);
        InternetMonitorServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultInternetMonitorClient client = new DefaultInternetMonitorClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private InternetMonitorServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return InternetMonitorServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

