/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.internetmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.internetmonitor.model.Network;
import software.amazon.awssdk.services.internetmonitor.model.NetworkListCopier;
import software.amazon.awssdk.services.internetmonitor.model.TriangulationEventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkImpairment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkImpairment> {
    private static final SdkField<List<Network>> NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Networks").getter(NetworkImpairment.getter(NetworkImpairment::networks)).setter(NetworkImpairment.setter(Builder::networks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Networks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Network::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Network>> AS_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AsPath").getter(NetworkImpairment.getter(NetworkImpairment::asPath)).setter(NetworkImpairment.setter(Builder::asPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsPath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Network::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkEventType").getter(NetworkImpairment.getter(NetworkImpairment::networkEventTypeAsString)).setter(NetworkImpairment.setter(Builder::networkEventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkEventType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORKS_FIELD, AS_PATH_FIELD, NETWORK_EVENT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Network> networks;
    private final List<Network> asPath;
    private final String networkEventType;

    private NetworkImpairment(BuilderImpl builder) {
        this.networks = builder.networks;
        this.asPath = builder.asPath;
        this.networkEventType = builder.networkEventType;
    }

    public final boolean hasNetworks() {
        return this.networks != null && !(this.networks instanceof SdkAutoConstructList);
    }

    public final List<Network> networks() {
        return this.networks;
    }

    public final boolean hasAsPath() {
        return this.asPath != null && !(this.asPath instanceof SdkAutoConstructList);
    }

    public final List<Network> asPath() {
        return this.asPath;
    }

    public final TriangulationEventType networkEventType() {
        return TriangulationEventType.fromValue(this.networkEventType);
    }

    public final String networkEventTypeAsString() {
        return this.networkEventType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworks() ? this.networks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAsPath() ? this.asPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkEventTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkImpairment)) {
            return false;
        }
        NetworkImpairment other = (NetworkImpairment)obj;
        return this.hasNetworks() == other.hasNetworks() && Objects.equals(this.networks(), other.networks()) && this.hasAsPath() == other.hasAsPath() && Objects.equals(this.asPath(), other.asPath()) && Objects.equals(this.networkEventTypeAsString(), other.networkEventTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkImpairment").add("Networks", this.hasNetworks() ? this.networks() : null).add("AsPath", this.hasAsPath() ? this.asPath() : null).add("NetworkEventType", (Object)this.networkEventTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Networks": {
                return Optional.ofNullable(clazz.cast(this.networks()));
            }
            case "AsPath": {
                return Optional.ofNullable(clazz.cast(this.asPath()));
            }
            case "NetworkEventType": {
                return Optional.ofNullable(clazz.cast(this.networkEventTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkImpairment, T> g) {
        return obj -> g.apply((NetworkImpairment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Network> networks = DefaultSdkAutoConstructList.getInstance();
        private List<Network> asPath = DefaultSdkAutoConstructList.getInstance();
        private String networkEventType;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkImpairment model) {
            this.networks(model.networks);
            this.asPath(model.asPath);
            this.networkEventType(model.networkEventType);
        }

        public final List<Network.Builder> getNetworks() {
            List<Network.Builder> result = NetworkListCopier.copyToBuilder(this.networks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworks(Collection<Network.BuilderImpl> networks) {
            this.networks = NetworkListCopier.copyFromBuilder(networks);
        }

        @Override
        public final Builder networks(Collection<Network> networks) {
            this.networks = NetworkListCopier.copy(networks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(Network ... networks) {
            this.networks(Arrays.asList(networks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(Consumer<Network.Builder> ... networks) {
            this.networks(Stream.of(networks).map(c -> (Network)((Network.Builder)Network.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Network.Builder> getAsPath() {
            List<Network.Builder> result = NetworkListCopier.copyToBuilder(this.asPath);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAsPath(Collection<Network.BuilderImpl> asPath) {
            this.asPath = NetworkListCopier.copyFromBuilder(asPath);
        }

        @Override
        public final Builder asPath(Collection<Network> asPath) {
            this.asPath = NetworkListCopier.copy(asPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asPath(Network ... asPath) {
            this.asPath(Arrays.asList(asPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asPath(Consumer<Network.Builder> ... asPath) {
            this.asPath(Stream.of(asPath).map(c -> (Network)((Network.Builder)Network.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNetworkEventType() {
            return this.networkEventType;
        }

        public final void setNetworkEventType(String networkEventType) {
            this.networkEventType = networkEventType;
        }

        @Override
        public final Builder networkEventType(String networkEventType) {
            this.networkEventType = networkEventType;
            return this;
        }

        @Override
        public final Builder networkEventType(TriangulationEventType networkEventType) {
            this.networkEventType(networkEventType == null ? null : networkEventType.toString());
            return this;
        }

        public NetworkImpairment build() {
            return new NetworkImpairment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkImpairment> {
        public Builder networks(Collection<Network> var1);

        public Builder networks(Network ... var1);

        public Builder networks(Consumer<Network.Builder> ... var1);

        public Builder asPath(Collection<Network> var1);

        public Builder asPath(Network ... var1);

        public Builder asPath(Consumer<Network.Builder> ... var1);

        public Builder networkEventType(String var1);

        public Builder networkEventType(TriangulationEventType var1);
    }
}

