/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspectorscan.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspectorscan.model.InspectorScanException;
import software.amazon.awssdk.services.inspectorscan.model.InternalServerExceptionReason;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InternalServerException
extends InspectorScanException
implements ToCopyableBuilder<Builder, InternalServerException> {
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(InternalServerException.getter(InternalServerException::reasonAsString)).setter(InternalServerException.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<Integer> RETRY_AFTER_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retryAfterSeconds").getter(InternalServerException.getter(InternalServerException::retryAfterSeconds)).setter(InternalServerException.setter(Builder::retryAfterSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Retry-After").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD, RETRY_AFTER_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reason;
    private final Integer retryAfterSeconds;

    private InternalServerException(BuilderImpl builder) {
        super(builder);
        this.reason = builder.reason;
        this.retryAfterSeconds = builder.retryAfterSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public InternalServerExceptionReason reason() {
        return InternalServerExceptionReason.fromValue(this.reason);
    }

    public String reasonAsString() {
        return this.reason;
    }

    public Integer retryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InternalServerException, T> g) {
        return obj -> g.apply((InternalServerException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorScanException.BuilderImpl
    implements Builder {
        private String reason;
        private Integer retryAfterSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(InternalServerException model) {
            super(model);
            this.reason(model.reason);
            this.retryAfterSeconds(model.retryAfterSeconds);
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(InternalServerExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final Integer getRetryAfterSeconds() {
            return this.retryAfterSeconds;
        }

        public final void setRetryAfterSeconds(Integer retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
        }

        @Override
        public final Builder retryAfterSeconds(Integer retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public InternalServerException build() {
            return new InternalServerException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InternalServerException>,
    InspectorScanException.Builder {
        public Builder reason(String var1);

        public Builder reason(InternalServerExceptionReason var1);

        public Builder retryAfterSeconds(Integer var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);
    }
}

