/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.ClusterInformation;
import software.amazon.awssdk.services.inspector2.model.ClusterInformationListCopier;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetClustersForImageResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, GetClustersForImageResponse> {
    private static final SdkField<List<ClusterInformation>> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cluster").getter(GetClustersForImageResponse.getter(GetClustersForImageResponse::cluster)).setter(GetClustersForImageResponse.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetClustersForImageResponse.getter(GetClustersForImageResponse::nextToken)).setter(GetClustersForImageResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetClustersForImageResponse.memberNameToFieldInitializer();
    private final List<ClusterInformation> cluster;
    private final String nextToken;

    private GetClustersForImageResponse(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCluster() {
        return this.cluster != null && !(this.cluster instanceof SdkAutoConstructList);
    }

    public final List<ClusterInformation> cluster() {
        return this.cluster;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCluster() ? this.cluster() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClustersForImageResponse)) {
            return false;
        }
        GetClustersForImageResponse other = (GetClustersForImageResponse)((Object)obj);
        return this.hasCluster() == other.hasCluster() && Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetClustersForImageResponse").add("Cluster", this.hasCluster() ? this.cluster() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cluster", CLUSTER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetClustersForImageResponse, T> g) {
        return obj -> g.apply((GetClustersForImageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private List<ClusterInformation> cluster = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClustersForImageResponse model) {
            super(model);
            this.cluster(model.cluster);
            this.nextToken(model.nextToken);
        }

        public final List<ClusterInformation.Builder> getCluster() {
            List<ClusterInformation.Builder> result = ClusterInformationListCopier.copyToBuilder(this.cluster);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCluster(Collection<ClusterInformation.BuilderImpl> cluster) {
            this.cluster = ClusterInformationListCopier.copyFromBuilder(cluster);
        }

        @Override
        public final Builder cluster(Collection<ClusterInformation> cluster) {
            this.cluster = ClusterInformationListCopier.copy(cluster);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cluster(ClusterInformation ... cluster) {
            this.cluster(Arrays.asList(cluster));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cluster(Consumer<ClusterInformation.Builder> ... cluster) {
            this.cluster(Stream.of(cluster).map(c -> (ClusterInformation)((ClusterInformation.Builder)ClusterInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetClustersForImageResponse build() {
            return new GetClustersForImageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetClustersForImageResponse> {
        public Builder cluster(Collection<ClusterInformation> var1);

        public Builder cluster(ClusterInformation ... var1);

        public Builder cluster(Consumer<ClusterInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

