/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendCisSessionHealthRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, SendCisSessionHealthRequest> {
    private static final SdkField<String> SCAN_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanJobId").getter(SendCisSessionHealthRequest.getter(SendCisSessionHealthRequest::scanJobId)).setter(SendCisSessionHealthRequest.setter(Builder::scanJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanJobId").build()}).build();
    private static final SdkField<String> SESSION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionToken").getter(SendCisSessionHealthRequest.getter(SendCisSessionHealthRequest::sessionToken)).setter(SendCisSessionHealthRequest.setter(Builder::sessionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_JOB_ID_FIELD, SESSION_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendCisSessionHealthRequest.memberNameToFieldInitializer();
    private final String scanJobId;
    private final String sessionToken;

    private SendCisSessionHealthRequest(BuilderImpl builder) {
        super(builder);
        this.scanJobId = builder.scanJobId;
        this.sessionToken = builder.sessionToken;
    }

    public final String scanJobId() {
        return this.scanJobId;
    }

    public final String sessionToken() {
        return this.sessionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scanJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCisSessionHealthRequest)) {
            return false;
        }
        SendCisSessionHealthRequest other = (SendCisSessionHealthRequest)((Object)obj);
        return Objects.equals(this.scanJobId(), other.scanJobId()) && Objects.equals(this.sessionToken(), other.sessionToken());
    }

    public final String toString() {
        return ToString.builder((String)"SendCisSessionHealthRequest").add("ScanJobId", (Object)this.scanJobId()).add("SessionToken", (Object)this.sessionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scanJobId": {
                return Optional.ofNullable(clazz.cast(this.scanJobId()));
            }
            case "sessionToken": {
                return Optional.ofNullable(clazz.cast(this.sessionToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("scanJobId", SCAN_JOB_ID_FIELD);
        map.put("sessionToken", SESSION_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendCisSessionHealthRequest, T> g) {
        return obj -> g.apply((SendCisSessionHealthRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private String scanJobId;
        private String sessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCisSessionHealthRequest model) {
            super(model);
            this.scanJobId(model.scanJobId);
            this.sessionToken(model.sessionToken);
        }

        public final String getScanJobId() {
            return this.scanJobId;
        }

        public final void setScanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
        }

        @Override
        public final Builder scanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
            return this;
        }

        public final String getSessionToken() {
            return this.sessionToken;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendCisSessionHealthRequest build() {
            return new SendCisSessionHealthRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendCisSessionHealthRequest> {
        public Builder scanJobId(String var1);

        public Builder sessionToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

