/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CodeVulnerabilityDetails;
import software.amazon.awssdk.services.inspector2.model.EpssDetails;
import software.amazon.awssdk.services.inspector2.model.ExploitAvailable;
import software.amazon.awssdk.services.inspector2.model.ExploitabilityDetails;
import software.amazon.awssdk.services.inspector2.model.FindingStatus;
import software.amazon.awssdk.services.inspector2.model.FindingType;
import software.amazon.awssdk.services.inspector2.model.FixAvailable;
import software.amazon.awssdk.services.inspector2.model.InspectorScoreDetails;
import software.amazon.awssdk.services.inspector2.model.NetworkReachabilityDetails;
import software.amazon.awssdk.services.inspector2.model.PackageVulnerabilityDetails;
import software.amazon.awssdk.services.inspector2.model.Remediation;
import software.amazon.awssdk.services.inspector2.model.Resource;
import software.amazon.awssdk.services.inspector2.model.ResourceListCopier;
import software.amazon.awssdk.services.inspector2.model.Severity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Finding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Finding> {
    private static final SdkField<String> FINDING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingArn").getter(Finding.getter(Finding::findingArn)).setter(Finding.setter(Builder::findingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArn").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(Finding.getter(Finding::awsAccountId)).setter(Finding.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Finding.getter(Finding::typeAsString)).setter(Finding.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Finding.getter(Finding::description)).setter(Finding.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(Finding.getter(Finding::title)).setter(Finding.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<Remediation> REMEDIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("remediation").getter(Finding.getter(Finding::remediation)).setter(Finding.setter(Builder::remediation)).constructor(Remediation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("severity").getter(Finding.getter(Finding::severityAsString)).setter(Finding.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<Instant> FIRST_OBSERVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstObservedAt").getter(Finding.getter(Finding::firstObservedAt)).setter(Finding.setter(Builder::firstObservedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstObservedAt").build()}).build();
    private static final SdkField<Instant> LAST_OBSERVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastObservedAt").getter(Finding.getter(Finding::lastObservedAt)).setter(Finding.setter(Builder::lastObservedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastObservedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Finding.getter(Finding::updatedAt)).setter(Finding.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Finding.getter(Finding::statusAsString)).setter(Finding.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resources").getter(Finding.getter(Finding::resources)).setter(Finding.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> INSPECTOR_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("inspectorScore").getter(Finding.getter(Finding::inspectorScore)).setter(Finding.setter(Builder::inspectorScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectorScore").build()}).build();
    private static final SdkField<InspectorScoreDetails> INSPECTOR_SCORE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inspectorScoreDetails").getter(Finding.getter(Finding::inspectorScoreDetails)).setter(Finding.setter(Builder::inspectorScoreDetails)).constructor(InspectorScoreDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectorScoreDetails").build()}).build();
    private static final SdkField<NetworkReachabilityDetails> NETWORK_REACHABILITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkReachabilityDetails").getter(Finding.getter(Finding::networkReachabilityDetails)).setter(Finding.setter(Builder::networkReachabilityDetails)).constructor(NetworkReachabilityDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkReachabilityDetails").build()}).build();
    private static final SdkField<PackageVulnerabilityDetails> PACKAGE_VULNERABILITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("packageVulnerabilityDetails").getter(Finding.getter(Finding::packageVulnerabilityDetails)).setter(Finding.setter(Builder::packageVulnerabilityDetails)).constructor(PackageVulnerabilityDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageVulnerabilityDetails").build()}).build();
    private static final SdkField<String> FIX_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fixAvailable").getter(Finding.getter(Finding::fixAvailableAsString)).setter(Finding.setter(Builder::fixAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixAvailable").build()}).build();
    private static final SdkField<String> EXPLOIT_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exploitAvailable").getter(Finding.getter(Finding::exploitAvailableAsString)).setter(Finding.setter(Builder::exploitAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exploitAvailable").build()}).build();
    private static final SdkField<ExploitabilityDetails> EXPLOITABILITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exploitabilityDetails").getter(Finding.getter(Finding::exploitabilityDetails)).setter(Finding.setter(Builder::exploitabilityDetails)).constructor(ExploitabilityDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exploitabilityDetails").build()}).build();
    private static final SdkField<CodeVulnerabilityDetails> CODE_VULNERABILITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("codeVulnerabilityDetails").getter(Finding.getter(Finding::codeVulnerabilityDetails)).setter(Finding.setter(Builder::codeVulnerabilityDetails)).constructor(CodeVulnerabilityDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeVulnerabilityDetails").build()}).build();
    private static final SdkField<EpssDetails> EPSS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("epss").getter(Finding.getter(Finding::epss)).setter(Finding.setter(Builder::epss)).constructor(EpssDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epss").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_ARN_FIELD, AWS_ACCOUNT_ID_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, TITLE_FIELD, REMEDIATION_FIELD, SEVERITY_FIELD, FIRST_OBSERVED_AT_FIELD, LAST_OBSERVED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD, RESOURCES_FIELD, INSPECTOR_SCORE_FIELD, INSPECTOR_SCORE_DETAILS_FIELD, NETWORK_REACHABILITY_DETAILS_FIELD, PACKAGE_VULNERABILITY_DETAILS_FIELD, FIX_AVAILABLE_FIELD, EXPLOIT_AVAILABLE_FIELD, EXPLOITABILITY_DETAILS_FIELD, CODE_VULNERABILITY_DETAILS_FIELD, EPSS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Finding.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String findingArn;
    private final String awsAccountId;
    private final String type;
    private final String description;
    private final String title;
    private final Remediation remediation;
    private final String severity;
    private final Instant firstObservedAt;
    private final Instant lastObservedAt;
    private final Instant updatedAt;
    private final String status;
    private final List<Resource> resources;
    private final Double inspectorScore;
    private final InspectorScoreDetails inspectorScoreDetails;
    private final NetworkReachabilityDetails networkReachabilityDetails;
    private final PackageVulnerabilityDetails packageVulnerabilityDetails;
    private final String fixAvailable;
    private final String exploitAvailable;
    private final ExploitabilityDetails exploitabilityDetails;
    private final CodeVulnerabilityDetails codeVulnerabilityDetails;
    private final EpssDetails epss;

    private Finding(BuilderImpl builder) {
        this.findingArn = builder.findingArn;
        this.awsAccountId = builder.awsAccountId;
        this.type = builder.type;
        this.description = builder.description;
        this.title = builder.title;
        this.remediation = builder.remediation;
        this.severity = builder.severity;
        this.firstObservedAt = builder.firstObservedAt;
        this.lastObservedAt = builder.lastObservedAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
        this.resources = builder.resources;
        this.inspectorScore = builder.inspectorScore;
        this.inspectorScoreDetails = builder.inspectorScoreDetails;
        this.networkReachabilityDetails = builder.networkReachabilityDetails;
        this.packageVulnerabilityDetails = builder.packageVulnerabilityDetails;
        this.fixAvailable = builder.fixAvailable;
        this.exploitAvailable = builder.exploitAvailable;
        this.exploitabilityDetails = builder.exploitabilityDetails;
        this.codeVulnerabilityDetails = builder.codeVulnerabilityDetails;
        this.epss = builder.epss;
    }

    public final String findingArn() {
        return this.findingArn;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final FindingType type() {
        return FindingType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final String title() {
        return this.title;
    }

    public final Remediation remediation() {
        return this.remediation;
    }

    public final Severity severity() {
        return Severity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final Instant firstObservedAt() {
        return this.firstObservedAt;
    }

    public final Instant lastObservedAt() {
        return this.lastObservedAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final FindingStatus status() {
        return FindingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<Resource> resources() {
        return this.resources;
    }

    public final Double inspectorScore() {
        return this.inspectorScore;
    }

    public final InspectorScoreDetails inspectorScoreDetails() {
        return this.inspectorScoreDetails;
    }

    public final NetworkReachabilityDetails networkReachabilityDetails() {
        return this.networkReachabilityDetails;
    }

    public final PackageVulnerabilityDetails packageVulnerabilityDetails() {
        return this.packageVulnerabilityDetails;
    }

    public final FixAvailable fixAvailable() {
        return FixAvailable.fromValue(this.fixAvailable);
    }

    public final String fixAvailableAsString() {
        return this.fixAvailable;
    }

    public final ExploitAvailable exploitAvailable() {
        return ExploitAvailable.fromValue(this.exploitAvailable);
    }

    public final String exploitAvailableAsString() {
        return this.exploitAvailable;
    }

    public final ExploitabilityDetails exploitabilityDetails() {
        return this.exploitabilityDetails;
    }

    public final CodeVulnerabilityDetails codeVulnerabilityDetails() {
        return this.codeVulnerabilityDetails;
    }

    public final EpssDetails epss() {
        return this.epss;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.findingArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediation());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inspectorScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.inspectorScoreDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkReachabilityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVulnerabilityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixAvailableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exploitAvailableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exploitabilityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeVulnerabilityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.epss());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding other = (Finding)obj;
        return Objects.equals(this.findingArn(), other.findingArn()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.remediation(), other.remediation()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.firstObservedAt(), other.firstObservedAt()) && Objects.equals(this.lastObservedAt(), other.lastObservedAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.inspectorScore(), other.inspectorScore()) && Objects.equals(this.inspectorScoreDetails(), other.inspectorScoreDetails()) && Objects.equals(this.networkReachabilityDetails(), other.networkReachabilityDetails()) && Objects.equals(this.packageVulnerabilityDetails(), other.packageVulnerabilityDetails()) && Objects.equals(this.fixAvailableAsString(), other.fixAvailableAsString()) && Objects.equals(this.exploitAvailableAsString(), other.exploitAvailableAsString()) && Objects.equals(this.exploitabilityDetails(), other.exploitabilityDetails()) && Objects.equals(this.codeVulnerabilityDetails(), other.codeVulnerabilityDetails()) && Objects.equals(this.epss(), other.epss());
    }

    public final String toString() {
        return ToString.builder((String)"Finding").add("FindingArn", (Object)this.findingArn()).add("AwsAccountId", (Object)this.awsAccountId()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).add("Title", (Object)this.title()).add("Remediation", (Object)this.remediation()).add("Severity", (Object)this.severityAsString()).add("FirstObservedAt", (Object)this.firstObservedAt()).add("LastObservedAt", (Object)this.lastObservedAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Status", (Object)this.statusAsString()).add("Resources", this.hasResources() ? this.resources() : null).add("InspectorScore", (Object)this.inspectorScore()).add("InspectorScoreDetails", (Object)this.inspectorScoreDetails()).add("NetworkReachabilityDetails", (Object)this.networkReachabilityDetails()).add("PackageVulnerabilityDetails", (Object)this.packageVulnerabilityDetails()).add("FixAvailable", (Object)this.fixAvailableAsString()).add("ExploitAvailable", (Object)this.exploitAvailableAsString()).add("ExploitabilityDetails", (Object)this.exploitabilityDetails()).add("CodeVulnerabilityDetails", (Object)this.codeVulnerabilityDetails()).add("Epss", (Object)this.epss()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findingArn": {
                return Optional.ofNullable(clazz.cast(this.findingArn()));
            }
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "remediation": {
                return Optional.ofNullable(clazz.cast(this.remediation()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "firstObservedAt": {
                return Optional.ofNullable(clazz.cast(this.firstObservedAt()));
            }
            case "lastObservedAt": {
                return Optional.ofNullable(clazz.cast(this.lastObservedAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "inspectorScore": {
                return Optional.ofNullable(clazz.cast(this.inspectorScore()));
            }
            case "inspectorScoreDetails": {
                return Optional.ofNullable(clazz.cast(this.inspectorScoreDetails()));
            }
            case "networkReachabilityDetails": {
                return Optional.ofNullable(clazz.cast(this.networkReachabilityDetails()));
            }
            case "packageVulnerabilityDetails": {
                return Optional.ofNullable(clazz.cast(this.packageVulnerabilityDetails()));
            }
            case "fixAvailable": {
                return Optional.ofNullable(clazz.cast(this.fixAvailableAsString()));
            }
            case "exploitAvailable": {
                return Optional.ofNullable(clazz.cast(this.exploitAvailableAsString()));
            }
            case "exploitabilityDetails": {
                return Optional.ofNullable(clazz.cast(this.exploitabilityDetails()));
            }
            case "codeVulnerabilityDetails": {
                return Optional.ofNullable(clazz.cast(this.codeVulnerabilityDetails()));
            }
            case "epss": {
                return Optional.ofNullable(clazz.cast(this.epss()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("findingArn", FINDING_ARN_FIELD);
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("remediation", REMEDIATION_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("firstObservedAt", FIRST_OBSERVED_AT_FIELD);
        map.put("lastObservedAt", LAST_OBSERVED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("resources", RESOURCES_FIELD);
        map.put("inspectorScore", INSPECTOR_SCORE_FIELD);
        map.put("inspectorScoreDetails", INSPECTOR_SCORE_DETAILS_FIELD);
        map.put("networkReachabilityDetails", NETWORK_REACHABILITY_DETAILS_FIELD);
        map.put("packageVulnerabilityDetails", PACKAGE_VULNERABILITY_DETAILS_FIELD);
        map.put("fixAvailable", FIX_AVAILABLE_FIELD);
        map.put("exploitAvailable", EXPLOIT_AVAILABLE_FIELD);
        map.put("exploitabilityDetails", EXPLOITABILITY_DETAILS_FIELD);
        map.put("codeVulnerabilityDetails", CODE_VULNERABILITY_DETAILS_FIELD);
        map.put("epss", EPSS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Finding, T> g) {
        return obj -> g.apply((Finding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String findingArn;
        private String awsAccountId;
        private String type;
        private String description;
        private String title;
        private Remediation remediation;
        private String severity;
        private Instant firstObservedAt;
        private Instant lastObservedAt;
        private Instant updatedAt;
        private String status;
        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();
        private Double inspectorScore;
        private InspectorScoreDetails inspectorScoreDetails;
        private NetworkReachabilityDetails networkReachabilityDetails;
        private PackageVulnerabilityDetails packageVulnerabilityDetails;
        private String fixAvailable;
        private String exploitAvailable;
        private ExploitabilityDetails exploitabilityDetails;
        private CodeVulnerabilityDetails codeVulnerabilityDetails;
        private EpssDetails epss;

        private BuilderImpl() {
        }

        private BuilderImpl(Finding model) {
            this.findingArn(model.findingArn);
            this.awsAccountId(model.awsAccountId);
            this.type(model.type);
            this.description(model.description);
            this.title(model.title);
            this.remediation(model.remediation);
            this.severity(model.severity);
            this.firstObservedAt(model.firstObservedAt);
            this.lastObservedAt(model.lastObservedAt);
            this.updatedAt(model.updatedAt);
            this.status(model.status);
            this.resources(model.resources);
            this.inspectorScore(model.inspectorScore);
            this.inspectorScoreDetails(model.inspectorScoreDetails);
            this.networkReachabilityDetails(model.networkReachabilityDetails);
            this.packageVulnerabilityDetails(model.packageVulnerabilityDetails);
            this.fixAvailable(model.fixAvailable);
            this.exploitAvailable(model.exploitAvailable);
            this.exploitabilityDetails(model.exploitabilityDetails);
            this.codeVulnerabilityDetails(model.codeVulnerabilityDetails);
            this.epss(model.epss);
        }

        public final String getFindingArn() {
            return this.findingArn;
        }

        public final void setFindingArn(String findingArn) {
            this.findingArn = findingArn;
        }

        @Override
        public final Builder findingArn(String findingArn) {
            this.findingArn = findingArn;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FindingType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Remediation.Builder getRemediation() {
            return this.remediation != null ? this.remediation.toBuilder() : null;
        }

        public final void setRemediation(Remediation.BuilderImpl remediation) {
            this.remediation = remediation != null ? remediation.build() : null;
        }

        @Override
        public final Builder remediation(Remediation remediation) {
            this.remediation = remediation;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final Instant getFirstObservedAt() {
            return this.firstObservedAt;
        }

        public final void setFirstObservedAt(Instant firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
        }

        @Override
        public final Builder firstObservedAt(Instant firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
            return this;
        }

        public final Instant getLastObservedAt() {
            return this.lastObservedAt;
        }

        public final void setLastObservedAt(Instant lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
        }

        @Override
        public final Builder lastObservedAt(Instant lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getInspectorScore() {
            return this.inspectorScore;
        }

        public final void setInspectorScore(Double inspectorScore) {
            this.inspectorScore = inspectorScore;
        }

        @Override
        public final Builder inspectorScore(Double inspectorScore) {
            this.inspectorScore = inspectorScore;
            return this;
        }

        public final InspectorScoreDetails.Builder getInspectorScoreDetails() {
            return this.inspectorScoreDetails != null ? this.inspectorScoreDetails.toBuilder() : null;
        }

        public final void setInspectorScoreDetails(InspectorScoreDetails.BuilderImpl inspectorScoreDetails) {
            this.inspectorScoreDetails = inspectorScoreDetails != null ? inspectorScoreDetails.build() : null;
        }

        @Override
        public final Builder inspectorScoreDetails(InspectorScoreDetails inspectorScoreDetails) {
            this.inspectorScoreDetails = inspectorScoreDetails;
            return this;
        }

        public final NetworkReachabilityDetails.Builder getNetworkReachabilityDetails() {
            return this.networkReachabilityDetails != null ? this.networkReachabilityDetails.toBuilder() : null;
        }

        public final void setNetworkReachabilityDetails(NetworkReachabilityDetails.BuilderImpl networkReachabilityDetails) {
            this.networkReachabilityDetails = networkReachabilityDetails != null ? networkReachabilityDetails.build() : null;
        }

        @Override
        public final Builder networkReachabilityDetails(NetworkReachabilityDetails networkReachabilityDetails) {
            this.networkReachabilityDetails = networkReachabilityDetails;
            return this;
        }

        public final PackageVulnerabilityDetails.Builder getPackageVulnerabilityDetails() {
            return this.packageVulnerabilityDetails != null ? this.packageVulnerabilityDetails.toBuilder() : null;
        }

        public final void setPackageVulnerabilityDetails(PackageVulnerabilityDetails.BuilderImpl packageVulnerabilityDetails) {
            this.packageVulnerabilityDetails = packageVulnerabilityDetails != null ? packageVulnerabilityDetails.build() : null;
        }

        @Override
        public final Builder packageVulnerabilityDetails(PackageVulnerabilityDetails packageVulnerabilityDetails) {
            this.packageVulnerabilityDetails = packageVulnerabilityDetails;
            return this;
        }

        public final String getFixAvailable() {
            return this.fixAvailable;
        }

        public final void setFixAvailable(String fixAvailable) {
            this.fixAvailable = fixAvailable;
        }

        @Override
        public final Builder fixAvailable(String fixAvailable) {
            this.fixAvailable = fixAvailable;
            return this;
        }

        @Override
        public final Builder fixAvailable(FixAvailable fixAvailable) {
            this.fixAvailable(fixAvailable == null ? null : fixAvailable.toString());
            return this;
        }

        public final String getExploitAvailable() {
            return this.exploitAvailable;
        }

        public final void setExploitAvailable(String exploitAvailable) {
            this.exploitAvailable = exploitAvailable;
        }

        @Override
        public final Builder exploitAvailable(String exploitAvailable) {
            this.exploitAvailable = exploitAvailable;
            return this;
        }

        @Override
        public final Builder exploitAvailable(ExploitAvailable exploitAvailable) {
            this.exploitAvailable(exploitAvailable == null ? null : exploitAvailable.toString());
            return this;
        }

        public final ExploitabilityDetails.Builder getExploitabilityDetails() {
            return this.exploitabilityDetails != null ? this.exploitabilityDetails.toBuilder() : null;
        }

        public final void setExploitabilityDetails(ExploitabilityDetails.BuilderImpl exploitabilityDetails) {
            this.exploitabilityDetails = exploitabilityDetails != null ? exploitabilityDetails.build() : null;
        }

        @Override
        public final Builder exploitabilityDetails(ExploitabilityDetails exploitabilityDetails) {
            this.exploitabilityDetails = exploitabilityDetails;
            return this;
        }

        public final CodeVulnerabilityDetails.Builder getCodeVulnerabilityDetails() {
            return this.codeVulnerabilityDetails != null ? this.codeVulnerabilityDetails.toBuilder() : null;
        }

        public final void setCodeVulnerabilityDetails(CodeVulnerabilityDetails.BuilderImpl codeVulnerabilityDetails) {
            this.codeVulnerabilityDetails = codeVulnerabilityDetails != null ? codeVulnerabilityDetails.build() : null;
        }

        @Override
        public final Builder codeVulnerabilityDetails(CodeVulnerabilityDetails codeVulnerabilityDetails) {
            this.codeVulnerabilityDetails = codeVulnerabilityDetails;
            return this;
        }

        public final EpssDetails.Builder getEpss() {
            return this.epss != null ? this.epss.toBuilder() : null;
        }

        public final void setEpss(EpssDetails.BuilderImpl epss) {
            this.epss = epss != null ? epss.build() : null;
        }

        @Override
        public final Builder epss(EpssDetails epss) {
            this.epss = epss;
            return this;
        }

        public Finding build() {
            return new Finding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Finding> {
        public Builder findingArn(String var1);

        public Builder awsAccountId(String var1);

        public Builder type(String var1);

        public Builder type(FindingType var1);

        public Builder description(String var1);

        public Builder title(String var1);

        public Builder remediation(Remediation var1);

        default public Builder remediation(Consumer<Remediation.Builder> remediation) {
            return this.remediation((Remediation)((Remediation.Builder)Remediation.builder().applyMutation(remediation)).build());
        }

        public Builder severity(String var1);

        public Builder severity(Severity var1);

        public Builder firstObservedAt(Instant var1);

        public Builder lastObservedAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(FindingStatus var1);

        public Builder resources(Collection<Resource> var1);

        public Builder resources(Resource ... var1);

        public Builder resources(Consumer<Resource.Builder> ... var1);

        public Builder inspectorScore(Double var1);

        public Builder inspectorScoreDetails(InspectorScoreDetails var1);

        default public Builder inspectorScoreDetails(Consumer<InspectorScoreDetails.Builder> inspectorScoreDetails) {
            return this.inspectorScoreDetails((InspectorScoreDetails)((InspectorScoreDetails.Builder)InspectorScoreDetails.builder().applyMutation(inspectorScoreDetails)).build());
        }

        public Builder networkReachabilityDetails(NetworkReachabilityDetails var1);

        default public Builder networkReachabilityDetails(Consumer<NetworkReachabilityDetails.Builder> networkReachabilityDetails) {
            return this.networkReachabilityDetails((NetworkReachabilityDetails)((NetworkReachabilityDetails.Builder)NetworkReachabilityDetails.builder().applyMutation(networkReachabilityDetails)).build());
        }

        public Builder packageVulnerabilityDetails(PackageVulnerabilityDetails var1);

        default public Builder packageVulnerabilityDetails(Consumer<PackageVulnerabilityDetails.Builder> packageVulnerabilityDetails) {
            return this.packageVulnerabilityDetails((PackageVulnerabilityDetails)((PackageVulnerabilityDetails.Builder)PackageVulnerabilityDetails.builder().applyMutation(packageVulnerabilityDetails)).build());
        }

        public Builder fixAvailable(String var1);

        public Builder fixAvailable(FixAvailable var1);

        public Builder exploitAvailable(String var1);

        public Builder exploitAvailable(ExploitAvailable var1);

        public Builder exploitabilityDetails(ExploitabilityDetails var1);

        default public Builder exploitabilityDetails(Consumer<ExploitabilityDetails.Builder> exploitabilityDetails) {
            return this.exploitabilityDetails((ExploitabilityDetails)((ExploitabilityDetails.Builder)ExploitabilityDetails.builder().applyMutation(exploitabilityDetails)).build());
        }

        public Builder codeVulnerabilityDetails(CodeVulnerabilityDetails var1);

        default public Builder codeVulnerabilityDetails(Consumer<CodeVulnerabilityDetails.Builder> codeVulnerabilityDetails) {
            return this.codeVulnerabilityDetails((CodeVulnerabilityDetails)((CodeVulnerabilityDetails.Builder)CodeVulnerabilityDetails.builder().applyMutation(codeVulnerabilityDetails)).build());
        }

        public Builder epss(EpssDetails var1);

        default public Builder epss(Consumer<EpssDetails.Builder> epss) {
            return this.epss((EpssDetails)((EpssDetails.Builder)EpssDetails.builder().applyMutation(epss)).build());
        }
    }
}

